/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.exec;

import java.io.ByteArrayOutputStream;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import org.cdlib.xtf.saxonExt.exec.RunElement;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class InputElement
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableFingerprint();
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String localName = atts.getLocalName(a);
            if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNameCode(a));
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof RunElement)) {
            this.compileError("parent node must be exec:run");
        }
        if (this.select != null) {
            this.select = this.typeCheck("select", this.select);
            try {
                RoleLocator role = new RoleLocator(4, "exec:run/input", 0, null);
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_ATOMIC, false, role, this.getStaticContext());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        InputInstruction inst = new InputInstruction();
        this.initializeInstruction(exec, inst);
        return inst;
    }

    protected static class InputInstruction
    extends GeneralVariable {
        public InstructionInfo getInstructionInfo() {
            InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
            details.setConstructType(2005);
            return details;
        }

        public TailCall processLeavingTail(XPathContext context) {
            return null;
        }

        public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
            throw new UnsupportedOperationException();
        }

        public byte[] getStream(XPathContext context) throws XPathException {
            try {
                Item kid;
                Value value = Value.asValue(this.getSelectValue(context));
                NodeInfo node = (NodeInfo)value.convertToJava(NodeInfo.class, context);
                boolean anyElements = false;
                AxisIterator iter = node.iterateAxis((byte)3);
                while ((kid = iter.next()) != null) {
                    if (!(kid instanceof NodeInfo) || !((NodeInfo)kid).hasChildNodes()) continue;
                    anyElements = true;
                }
                if (!anyElements) {
                    String str = value.toString() + "\n";
                    return str.getBytes("UTF-8");
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream(100);
                StreamResult streamResult = new StreamResult(outStream);
                TransformerFactoryImpl factory = new TransformerFactoryImpl();
                ((TransformerFactory)factory).setAttribute("http://saxon.sf.net/feature/namePool", node.getNamePool());
                Transformer trans = ((TransformerFactory)factory).newTransformer();
                Properties props = trans.getOutputProperties();
                props.put("indent", "yes");
                props.put("method", "xml");
                trans.setOutputProperties(props);
                if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
                    trans.setErrorListener(new XTFSaxonErrorListener());
                }
                trans.transform(node, streamResult);
                outStream.write("\n".getBytes());
                outStream.close();
                return outStream.toByteArray();
            }
            catch (Exception e) {
                this.dynamicError("Exception occurred converting input for external command: " + e, "EXEC001", context);
                return null;
            }
        }
    }
}

