/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.cdlib.xtf.saxonExt.exec.ArgElement;
import org.cdlib.xtf.saxonExt.exec.InputElement;

public class RunElement
extends ExtensionInstruction {
    String command;
    int timeoutMsec;

    public void prepareAttributes() throws XPathException {
        this.command = this.getAttributeList().getValue("", "command");
        if (this.command == null) {
            this.reportAbsence("command");
            return;
        }
        String timeoutStr = this.getAttributeList().getValue("", "timeout");
        if (timeoutStr == null) {
            this.timeoutMsec = 0;
        } else {
            try {
                this.timeoutMsec = (int)(Float.parseFloat(timeoutStr) * 1000.0f);
                this.timeoutMsec = Math.max(0, this.timeoutMsec);
            }
            catch (NumberFormatException e) {
                this.compileError("'timeout' must be a number");
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return new RunInstruction(this.command, this.timeoutMsec, this.getArgInstructions(exec));
    }

    public List getArgInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof ArgElement) {
                list.add(((ArgElement)child).compile(exec));
            }
            if (!(child instanceof InputElement)) continue;
            list.add(((InputElement)child).compile(exec));
        }
        return list;
    }

    private static class OutputGrabber
    extends Thread {
        private InputStream inStream;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        public byte[] outBytes = new byte[0];
        public Throwable error;
        public boolean done = false;

        public OutputGrabber(InputStream stream) {
            this.inStream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int got;
                byte[] byArray = new byte[4096];
                while ((got = this.inStream.read(byArray)) >= 0) {
                    this.buffer.write(byArray, 0, got);
                }
                this.outBytes = this.buffer.toByteArray();
            }
            catch (IOException iOException) {
                this.error = iOException;
            }
            finally {
                OutputGrabber outputGrabber = this;
                synchronized (outputGrabber) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }

    private static class InputStuffer
    extends Thread {
        private OutputStream outStream;
        private byte[] bytes;
        public Throwable error;
        public boolean done = false;

        public InputStuffer(OutputStream stream, byte[] bytes) throws UnsupportedEncodingException {
            this.outStream = stream;
            this.bytes = bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.outStream.write(this.bytes);
                this.outStream.close();
            }
            catch (IOException e) {
                this.error = e;
            }
            finally {
                InputStuffer inputStuffer = this;
                synchronized (inputStuffer) {
                    this.done = true;
                    this.notifyAll();
                }
            }
        }
    }

    private static class Interrupter
    extends TimerTask {
        public Thread mainThread;

        public Interrupter(Thread mainThread) {
            this.mainThread = mainThread;
        }

        public synchronized void run() {
            if (this.mainThread != null) {
                this.mainThread.interrupt();
            }
        }
    }

    private static class RunInstruction
    extends SimpleExpression {
        String command;
        int timeout;
        int nArgs;
        InputElement.InputInstruction inputExpr;

        public RunInstruction(String command, int timeout, List args) {
            this.command = command;
            this.timeout = timeout;
            this.nArgs = args.size();
            if (args.size() > 0 && args.get(args.size() - 1) instanceof InputElement.InputInstruction) {
                this.inputExpr = (InputElement.InputInstruction)args.get(args.size() - 1);
                --this.nArgs;
            }
            Expression[] sub = new Expression[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                sub[i] = (Expression)args.get(i);
            }
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "exec:run";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            int i;
            OutputStream stdin;
            Thread stderrGrabber;
            InputStream stderr;
            Thread stdoutGrabber;
            InputStream stdout;
            Process process;
            block64: {
                Thread e2;
                block63: {
                    ArrayList<String> args = new ArrayList<String>(10);
                    args.add(this.command);
                    for (int c = 0; c < this.nArgs; ++c) {
                        String strVal = ((ArgElement.ArgInstruction)this.arguments[c]).getSelectValue(context).getStringValue();
                        args.add(strVal);
                    }
                    byte[] inputBytes = null;
                    if (this.inputExpr != null) {
                        inputBytes = this.inputExpr.getStream(context);
                    }
                    process = null;
                    stdout = null;
                    stdoutGrabber = null;
                    stderr = null;
                    stderrGrabber = null;
                    stdin = null;
                    Thread stdinStuffer = null;
                    Timer timer = new Timer();
                    Runnable interrupter = null;
                    try {
                        Object argArray = args.toArray(new String[args.size()]);
                        process = Runtime.getRuntime().exec((String[])argArray);
                        if (inputBytes != null) {
                            stdin = process.getOutputStream();
                            stdinStuffer = new InputStuffer(stdin, inputBytes);
                            stdinStuffer.start();
                        }
                        stdout = process.getInputStream();
                        stdoutGrabber = new OutputGrabber(stdout);
                        stderr = process.getErrorStream();
                        stderrGrabber = new OutputGrabber(stderr);
                        stdoutGrabber.start();
                        stderrGrabber.start();
                        if (this.timeout > 0) {
                            interrupter = new Interrupter(Thread.currentThread());
                            timer.schedule((TimerTask)interrupter, this.timeout);
                        }
                        process.waitFor();
                    }
                    catch (IOException e2) {
                        if (stdin != null) {
                            try {
                                stdin.close();
                            }
                            catch (IOException e22) {
                                // empty catch block
                            }
                        }
                        if (stdout != null) {
                            try {
                                stdout.close();
                            }
                            catch (IOException e23) {
                                // empty catch block
                            }
                        }
                        if (stderr != null) {
                            try {
                                stderr.close();
                            }
                            catch (IOException e24) {
                                // empty catch block
                            }
                        }
                        this.dynamicError("IO exception occurred processing external command '" + this.command + "': " + e2, "EXEC005", context);
                    }
                    catch (InterruptedException e3) {
                        if (stdinStuffer != null) {
                            stdinStuffer.interrupt();
                        }
                        if (stdoutGrabber != null) {
                            stdoutGrabber.interrupt();
                        }
                        if (stderrGrabber != null) {
                            stderrGrabber.interrupt();
                        }
                        if (process != null) {
                            process.destroy();
                        }
                        this.dynamicError("External command '" + this.command + "' exceeded timeout of " + new DecimalFormat().format((double)this.timeout / 1000.0) + " sec", "EXEC002", context);
                    }
                    finally {
                        if (interrupter != null) {
                            e2 = interrupter;
                            synchronized (e2) {
                                timer.cancel();
                                ((Interrupter)interrupter).mainThread = null;
                                Thread.interrupted();
                            }
                        }
                    }
                    try {
                        if (stdinStuffer == null) break block63;
                        while (true) {
                            e2 = stdinStuffer;
                            synchronized (e2) {
                                if (((InputStuffer)stdinStuffer).done) {
                                    break;
                                }
                                stdinStuffer.wait();
                            }
                        }
                    }
                    catch (InterruptedException e4) {
                        assert (false) : "should not be interrupted at this stage";
                        break block64;
                    }
                }
                while (true) {
                    e2 = stdoutGrabber;
                    synchronized (e2) {
                        if (((OutputGrabber)stdoutGrabber).done) {
                            break;
                        }
                        stdoutGrabber.wait();
                    }
                }
                while (true) {
                    e2 = stderrGrabber;
                    synchronized (e2) {
                        if (((OutputGrabber)stderrGrabber).done) {
                            break;
                        }
                        stderrGrabber.wait();
                    }
                }
            }
            if (stdin != null) {
                try {
                    stdin.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (stdout != null) {
                try {
                    stdout.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (stderr != null) {
                try {
                    stderr.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (process.exitValue() != 0 && ((OutputGrabber)stderrGrabber).outBytes.length > 0) {
                String errStr = new String(((OutputGrabber)stderrGrabber).outBytes);
                String outStr = new String(((OutputGrabber)stdoutGrabber).outBytes);
                this.dynamicError("External command '" + this.command + "' exited with status " + process.exitValue() + ". Output from stderr:\n" + errStr + "\nOutput from stdout:\n" + outStr, "EXEC003", context);
            }
            byte[] outBytes = ((OutputGrabber)stdoutGrabber).outBytes;
            byte[] lookFor = "<?xml".getBytes();
            for (i = 0; i < lookFor.length && i < outBytes.length && outBytes[i] == lookFor[i]; ++i) {
            }
            if (i < lookFor.length) {
                return new StringValue(new String(outBytes));
            }
            StreamSource src = new StreamSource(new ByteArrayInputStream(outBytes));
            NodeInfo doc = null;
            try {
                return TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), context.getController().getConfiguration());
            }
            catch (XPathException e) {
                this.dynamicError("Error parsing XML output from external command '" + this.command + "': " + e, "EXEC004", context);
            }
            return doc;
        }
    }
}

