/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.InstructionWithContent;

public class SendElement
extends ExtensionInstruction {
    HashMap<String, Expression> outAtts = new HashMap();

    public void prepareAttributes() throws XPathException {
        String[] mandatoryAtts = new String[]{"smtpHost", "from", "to", "subject"};
        String[] optionalAtts = new String[]{"smtpUser", "smtpPassword", "useSSL"};
        AttributeCollection inAtts = this.getAttributeList();
        for (int i = 0; i < inAtts.getLength(); ++i) {
            String attName = inAtts.getLocalName(i);
            for (String m : mandatoryAtts) {
                if (!m.equals(attName)) continue;
                this.outAtts.put(attName, this.makeAttributeValueTemplate(inAtts.getValue(i)));
            }
            for (String m : optionalAtts) {
                if (!m.equals(attName)) continue;
                this.outAtts.put(attName, this.makeAttributeValueTemplate(inAtts.getValue(i)));
            }
        }
        for (String m : mandatoryAtts) {
            if (this.outAtts.containsKey(m)) continue;
            this.reportAbsence(m);
            return;
        }
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        return new SendInstruction(this.outAtts, content);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SendInstruction
    extends InstructionWithContent {
        public SendInstruction(HashMap<String, Expression> attribs, Expression content) {
            super("mail:send", attribs, content);
        }

        @Override
        public TailCall processLeavingTail(final XPathContext context) throws XPathException {
            boolean debug = false;
            try {
                Session session;
                String protocol = "";
                String useSSL = ((Expression)this.attribs.get("useSSL")).evaluateAsString(context);
                protocol = useSSL != null && useSSL.matches("^(yes|Yes|true|True|1)$") ? "smtps" : "smtp";
                boolean doAuth = this.attribs.containsKey("smtpUser") && this.attribs.containsKey("smtpPassword");
                Properties props = new Properties();
                String server = ((Expression)this.attribs.get("smtpHost")).evaluateAsString(context);
                props.put("mail." + protocol + ".host", server);
                props.put("mail." + protocol + ".auth", doAuth ? "true" : "false");
                if (doAuth) {
                    Authenticator auth = new Authenticator(){

                        public PasswordAuthentication getPasswordAuthentication() {
                            try {
                                String username = ((Expression)SendInstruction.this.attribs.get("smtpUser")).evaluateAsString(context);
                                String password = ((Expression)SendInstruction.this.attribs.get("smtpPassword")).evaluateAsString(context);
                                return new PasswordAuthentication(username, password);
                            }
                            catch (XPathException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    session = Session.getInstance((Properties)props, (Authenticator)auth);
                } else {
                    session = Session.getInstance((Properties)props);
                }
                session.setDebug(debug);
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((Address)new InternetAddress(((Expression)this.attribs.get("from")).evaluateAsString(context)));
                String recips = ((Expression)this.attribs.get("to")).evaluateAsString(context).trim();
                ArrayList<InternetAddress> addressTo = new ArrayList<InternetAddress>();
                for (String recip : recips.split(",")) {
                    if ((recip = recip.trim()).length() <= 0) continue;
                    addressTo.add(new InternetAddress(recip));
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo.toArray(new InternetAddress[addressTo.size()]));
                msg.setSubject(((Expression)this.attribs.get("subject")).evaluateAsString(context));
                msg.setText(SendInstruction.sequenceToString(this.content, context), "UTF-8");
                msg.saveChanges();
                Transport tr = session.getTransport(protocol);
                tr.connect();
                tr.sendMessage((Message)msg, msg.getAllRecipients());
                try {
                    tr.close();
                }
                catch (MessagingException e) {}
            }
            catch (MessagingException e) {
                throw new DynamicError(e);
            }
            catch (XPathException e) {
                throw e;
            }
            return null;
        }
    }
}

