/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;

public class SQLDelete
extends ExtensionInstruction {
    Expression connection;
    Expression table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        }
        this.connection = this.makeExpression(connectAtt);
        String tableAtt = this.attributeList.getValue("", "table");
        if (tableAtt == null) {
            this.reportAbsence("table");
        }
        this.table = this.makeAttributeValueTemplate(tableAtt);
        String whereAtt = this.attributeList.getValue("", "where");
        if (whereAtt == null) {
            this.reportAbsence("where");
        }
        this.where = this.makeAttributeValueTemplate(whereAtt);
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new DeleteInstruction(this.connection, this.table, this.where);
    }

    private static class DeleteInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int TABLE = 1;
        public static final int WHERE = 2;

        public DeleteInstruction(Expression connection, Expression table, Expression where) {
            Expression[] sub = new Expression[]{connection, table, where};
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:delete";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            String dbTab = this.arguments[1].evaluateAsString(context);
            String dbWhere = this.arguments[2].evaluateAsString(context);
            StringBuffer statement = new StringBuffer(120);
            statement.append("DELETE FROM " + dbTab + " WHERE " + dbWhere);
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            PreparedStatement ps = null;
            int nDeleted = -1;
            try {
                ps = connection.prepareStatement(statement.toString());
                nDeleted = ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL DELETE) " + ex.getMessage(), "SXSQ0004", context);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return null;
        }
    }
}

