/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import org.cdlib.xtf.saxonExt.sql.SQLColumn;

public class SQLInsert
extends ExtensionInstruction {
    Expression connection;
    String table;
    boolean ignoreDuplicate = false;

    public void prepareAttributes() throws XPathException {
        String connectAtt;
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        if ((connectAtt = this.getAttributeList().getValue("", "connection")) == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
        String ignoreAtt = this.getAttributeList().getValue("", "ignoreDuplicate");
        if (ignoreAtt != null && ignoreAtt.matches("^true$|^yes$|^1$")) {
            this.ignoreDuplicate = true;
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new InsertInstruction(this.connection, this.table, this.getColumnInstructions(exec), this.ignoreDuplicate);
    }

    public List getColumnInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            list.add(((SQLColumn)child).compile(exec));
        }
        return list;
    }

    private static class InsertInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int FIRST_COLUMN = 1;
        String table;
        boolean ignoreDuplicate;

        public InsertInstruction(Expression connection, String table, List columnInstructions, boolean ignoreDuplicate) {
            Expression[] sub = new Expression[columnInstructions.size() + 1];
            sub[0] = connection;
            for (int i = 0; i < columnInstructions.size(); ++i) {
                sub[i + 1] = (Expression)columnInstructions.get(i);
            }
            this.table = table;
            this.setArguments(sub);
            this.ignoreDuplicate = ignoreDuplicate;
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:insert";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            SQLColumn.ColumnInstruction colInst;
            int c;
            StringBuffer statement = new StringBuffer(120);
            statement.append("INSERT ");
            if (this.ignoreDuplicate) {
                statement.append("IGNORE ");
            }
            statement.append("INTO " + this.table + " (");
            for (c = 1; c < this.arguments.length; ++c) {
                if (c > 1) {
                    statement.append(',');
                }
                colInst = (SQLColumn.ColumnInstruction)this.arguments[c];
                String colname = colInst.getColumnName();
                statement.append(colname);
            }
            statement.append(") VALUES (");
            for (c = 1; c < this.arguments.length; ++c) {
                if (c > 1) {
                    statement.append(',');
                }
                if ((colInst = (SQLColumn.ColumnInstruction)this.arguments[c]).evalSql()) {
                    String val = colInst.getSelectValue(context).toString();
                    if (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
                        val = val.substring(1, val.length() - 1);
                    }
                    statement.append(val);
                    continue;
                }
                statement.append("?");
            }
            statement.append(')');
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            PreparedStatement ps = null;
            try {
                ps = connection.prepareStatement(statement.toString());
                int i = 1;
                for (int c2 = 1; c2 < this.arguments.length; ++c2) {
                    AtomicValue v = (AtomicValue)((SQLColumn.ColumnInstruction)this.arguments[c2]).getSelectValue(context);
                    String val = v.getStringValue();
                    if (val.length() == 1) {
                        val = val + " ";
                    }
                    ps.setObject(i++, val);
                }
                ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL INSERT) " + ex.getMessage(), "SXSQ0004", context);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return null;
        }
    }
}

