/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import org.cdlib.xtf.saxonExt.sql.SQLColumn;

public class SQLUpdate
extends ExtensionInstruction {
    Expression connection;
    Expression table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        }
        this.connection = this.makeExpression(connectAtt);
        String tableAtt = this.attributeList.getValue("", "table");
        if (tableAtt == null) {
            this.reportAbsence("table");
        }
        this.table = this.makeAttributeValueTemplate(tableAtt);
        String whereAtt = this.attributeList.getValue("", "where");
        if (whereAtt == null) {
            this.reportAbsence("where");
        }
        this.where = this.makeAttributeValueTemplate(whereAtt);
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
        this.table = this.typeCheck("table", this.table);
        this.where = this.typeCheck("where", this.where);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new UpdateInstruction(this.connection, this.table, this.where, this.getColumnInstructions(exec));
    }

    public List getColumnInstructions(Executable exec) throws XPathException {
        NodeInfo child;
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (!(child instanceof SQLColumn)) continue;
            list.add(((SQLColumn)child).compile(exec));
        }
        return list;
    }

    private static class UpdateInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int TABLE = 1;
        public static final int WHERE = 2;
        public static final int FIRST_COLUMN = 3;

        public UpdateInstruction(Expression connection, Expression table, Expression where, List columnInstructions) {
            Expression[] sub = new Expression[columnInstructions.size() + 3];
            sub[0] = connection;
            sub[1] = table;
            sub[2] = where;
            for (int i = 0; i < columnInstructions.size(); ++i) {
                sub[i + 3] = (Expression)columnInstructions.get(i);
            }
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:update";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            String dbTab = this.arguments[1].evaluateAsString(context);
            String dbWhere = this.arguments[2].evaluateAsString(context);
            StringBuffer statement = new StringBuffer(120);
            statement.append("UPDATE " + dbTab + " SET ");
            for (int c = 3; c < this.arguments.length; ++c) {
                if (c > 3) {
                    statement.append(',');
                }
                SQLColumn.ColumnInstruction colInst = (SQLColumn.ColumnInstruction)this.arguments[c];
                String colname = colInst.getColumnName();
                statement.append(colname);
                if (colInst.evalSql()) {
                    String val = colInst.getSelectValue(context).toString();
                    if (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
                        val = val.substring(1, val.length() - 1);
                    }
                    statement.append("=" + val);
                    continue;
                }
                statement.append("=?");
            }
            statement.append(" WHERE " + dbWhere);
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            PreparedStatement ps = null;
            int nUpdated = -1;
            try {
                ps = connection.prepareStatement(statement.toString());
                int i = 1;
                for (int c = 3; c < this.arguments.length; ++c) {
                    SQLColumn.ColumnInstruction colInst = (SQLColumn.ColumnInstruction)this.arguments[c];
                    if (colInst.evalSql()) continue;
                    String val = ((AtomicValue)colInst.getSelectValue(context)).getStringValue();
                    if (val.length() == 1) {
                        val = val + " ";
                    }
                    ps.setObject(i++, val);
                }
                nUpdated = ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("(SQL UPDATE) " + ex.getMessage(), "SXSQ0004", context);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return null;
        }
    }
}

