/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.servletBase;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.cdlib.xtf.util.Trace;

class LatencyCutoffStream
extends ServletOutputStream {
    private OutputStream realOut;
    private int total = 0;
    private int limit;
    private String url;
    private long reqStartTime;
    private boolean isReported = false;

    public LatencyCutoffStream(OutputStream realOut, int limit, long reqStartTime, String url) {
        this.realOut = realOut;
        this.limit = limit;
        this.url = url;
        this.reqStartTime = reqStartTime;
    }

    public void close() throws IOException {
        this.realOut.close();
    }

    public void flush() throws IOException {
        this.realOut.flush();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isReported && this.total > this.limit) {
            this.reportLatency();
        }
        this.realOut.write(b, off, len);
        this.total += len;
    }

    public void write(int b) throws IOException {
        if (!this.isReported && this.total > this.limit) {
            this.reportLatency();
        }
        this.realOut.write(b);
        ++this.total;
    }

    public boolean isReported() {
        return this.isReported;
    }

    private void reportLatency() {
        this.isReported = true;
        long latency = System.currentTimeMillis() - this.reqStartTime;
        Trace.info("Latency (cutoff): " + latency + " msec for request: " + this.url);
    }
}

