/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.servletBase;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.om.NamePool;
import org.cdlib.xtf.cache.FileDependency;
import org.cdlib.xtf.cache.GeneratingCache;
import org.cdlib.xtf.lazyTree.ProfilingListener;
import org.cdlib.xtf.servletBase.DTDSuppressingXMLReader;
import org.cdlib.xtf.util.GeneralException;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XTFSaxonErrorListener;
import org.xml.sax.InputSource;

public class StylesheetCache
extends GeneratingCache {
    private boolean dependencyChecking = false;
    private GeneratingCache dependencyReceiver = null;
    private boolean enableProfiling = false;
    private TransformerFactory factory;

    public StylesheetCache(int maxEntries, int maxTime, boolean dependencyChecking) {
        super(maxEntries, maxTime);
        this.dependencyChecking = dependencyChecking;
        Configuration config = new Configuration();
        config.setNamePool(NamePool.getDefaultNamePool());
        this.factory = new TransformerFactoryImpl(config);
        if (!(this.factory.getErrorListener() instanceof XTFSaxonErrorListener)) {
            this.factory.setErrorListener(new XTFSaxonErrorListener());
        }
        this.factory.setAttribute("http://saxon.sf.net/feature/sourceParserClass", DTDSuppressingXMLReader.class.getName());
        if (dependencyChecking) {
            this.factory.setURIResolver(new DepResolver(this, this.factory.getURIResolver()));
        }
    }

    public Templates find(String path) throws Exception {
        return (Templates)super.find(path);
    }

    public void enableProfiling(boolean flag) {
        this.enableProfiling = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object generate(Object key) throws Exception {
        assert (this.dependencyReceiver == null) : "stylesheet cache should only have dependencyReceiver during external calls, not during find().";
        if (this.dependencyChecking) {
            this.dependencyReceiver = this;
        }
        try {
            String url;
            Templates x;
            String path = (String)key;
            File file = new File(path);
            if (this.dependencyChecking) {
                this.addDependency(new FileDependency(file));
            }
            if (!path.startsWith("http:") && !file.canRead()) {
                throw new GeneralException("Cannot read stylesheet: " + path);
            }
            if (this.enableProfiling) {
                ProfilingListener profilingListener = new ProfilingListener();
                this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", profilingListener);
                this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
            }
            if ((x = this.factory.newTemplates(new SAXSource(new InputSource(url = path.startsWith("http:") ? path : file.toURL().toString())))) == null) {
                throw new TransformerException("Cannot read stylesheet: " + path);
            }
            Templates templates = x;
            return templates;
        }
        finally {
            this.dependencyReceiver = null;
        }
    }

    protected void logAction(String action, Object key, Object value) {
        Trace.debug("StylesheetCache: " + action + ". Path=" + (String)key);
    }

    private class DepResolver
    implements URIResolver {
        GeneratingCache cache;
        URIResolver realResolver;

        DepResolver(GeneratingCache cache, URIResolver realResolver) {
            this.cache = cache;
            this.realResolver = realResolver;
        }

        public Source resolve(String href, String base) throws TransformerException {
            String sysId;
            Source src;
            if (href.indexOf(32) >= 0) {
                href = href.replaceAll(" ", "%20");
            }
            if (base != null && base.indexOf(32) >= 0) {
                base = base.replaceAll(" ", "%20");
            }
            if ((src = this.realResolver.resolve(href, base)) != null && StylesheetCache.this.dependencyReceiver != null && (sysId = src.getSystemId()) != null && sysId.startsWith("file:")) {
                String path = sysId.substring("file:".length());
                while (path.startsWith("//")) {
                    path = path.substring(1);
                }
                StylesheetCache.this.dependencyReceiver.addDependency(new FileDependency(path));
            }
            return src;
        }
    }
}

