/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.servletBase;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.util.AttribList;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.GeneralException;

public abstract class TextConfig {
    public TextServlet servlet;
    public String logLevel = "info";
    public int stylesheetCacheSize = 10;
    public int stylesheetCacheExpire = 0;
    public String errorGenSheet;
    public boolean dependencyCheckingEnabled = true;
    public boolean reportLatency = false;
    public int latencyCutoffSize = 0;
    public long runawayNormalTime = 0L;
    public long runawayKillTime = 0L;
    public boolean trackSessions = true;
    public Pattern sessionEncodeURLPattern = null;
    public Map tokenizerMap = new HashMap();
    public AttribList attribs = new AttribList();
    private Configuration config = new Configuration();
    private String tokenizeParam;
    private String tokenizeTokenizer;

    public TextConfig(TextServlet servlet) {
        this.servlet = servlet;
    }

    public void read(String expectedRootTag, String path) throws GeneralException {
        try {
            StreamSource src = new StreamSource(new File(path));
            NodeInfo doc = null;
            try {
                doc = TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), this.config);
            }
            catch (XPathException e) {
                throw new RuntimeException(e);
            }
            EasyNode root = new EasyNode(doc);
            String rootTag = root.name();
            if (rootTag.equals("") && root.nChildren() == 1) {
                root = root.child(0);
                rootTag = root.name();
            }
            if (!rootTag.equals(expectedRootTag)) {
                throw new GeneralException("Config file \"" + path + "\" " + "should contain <" + expectedRootTag + ">");
            }
            for (int i = 0; i < root.nChildren(); ++i) {
                EasyNode el = root.child(i);
                if (!el.isElement()) continue;
                String tagName = el.name();
                for (int j = 0; j < el.nAttrs(); ++j) {
                    String attrName = el.attrName(j);
                    String strVal = el.attrValue(j);
                    if (!this.handleProperty(tagName + "." + attrName, strVal)) {
                        // empty if block
                    }
                    this.attribs.put(tagName + "." + attrName, strVal);
                }
            }
        }
        catch (Exception e) {
            throw new GeneralException("Error reading config file " + path + ": " + e);
        }
        TextConfig.requireOrElse(this.errorGenSheet, "Config file error: errorGen stylesheet not specified");
    }

    protected boolean handleProperty(String tagAttr, String strVal) {
        if (tagAttr.equalsIgnoreCase("logging.level")) {
            if (strVal.equals("0")) {
                strVal = "silent";
            } else if (strVal.equals("1")) {
                strVal = "info";
            } else if (strVal.equals("2")) {
                strVal = "debug";
            }
            this.logLevel = strVal;
            return true;
        }
        if (tagAttr.equalsIgnoreCase("stylesheetCache.size")) {
            this.stylesheetCacheSize = TextConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("stylesheetCache.expire")) {
            this.stylesheetCacheExpire = TextConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("errorGen.path")) {
            this.errorGenSheet = this.servlet.getRealPath(strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("dependencyChecking.check")) {
            this.dependencyCheckingEnabled = TextConfig.parseBoolean(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("reportLatency.report") || tagAttr.equalsIgnoreCase("reportLatency.enable")) {
            this.reportLatency = TextConfig.parseBoolean(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("reportLatency.cutoffSize")) {
            this.latencyCutoffSize = TextConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("runawayTimer.normalTime")) {
            this.runawayNormalTime = TextConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("runawayTimer.killTime")) {
            this.runawayKillTime = TextConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("trackSessions.track")) {
            this.trackSessions = TextConfig.parseBoolean(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("trackSessions.encodeURLPattern") && strVal.length() > 0) {
            try {
                this.sessionEncodeURLPattern = Pattern.compile(strVal);
            }
            catch (PatternSyntaxException e) {
                throw new GeneralException("Config file property " + tagAttr + " must be a valid regular expression");
            }
            return true;
        }
        if (tagAttr.equalsIgnoreCase("tokenize.param") || tagAttr.equalsIgnoreCase("tokenize.tokenizer")) {
            if (tagAttr.equalsIgnoreCase("tokenize.param")) {
                this.tokenizeParam = strVal;
            } else {
                this.tokenizeTokenizer = strVal;
            }
            if (this.tokenizeParam != null && this.tokenizeTokenizer != null) {
                this.tokenizerMap.put(this.tokenizeParam, this.tokenizeTokenizer);
                this.tokenizeParam = null;
                this.tokenizeTokenizer = null;
            }
            return true;
        }
        return false;
    }

    public static int parseInt(String tagAttr, String strVal) throws GeneralException {
        try {
            return Integer.parseInt(strVal);
        }
        catch (NumberFormatException e) {
            throw new GeneralException("Integer value expected for " + tagAttr);
        }
    }

    public static boolean parseBoolean(String tagAttr, String strVal) throws GeneralException {
        if (strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("yes") || strVal.equals("1")) {
            return true;
        }
        if (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("no") || strVal.equals("0")) {
            return false;
        }
        throw new GeneralException("Boolean value expected for " + tagAttr + " (value must be one of: " + "'true', 'false', 'yes', 'no', '1', or '0')");
    }

    public static void requireOrElse(String value, String descrip) throws GeneralException {
        if (value == null || value.equals("")) {
            throw new GeneralException(descrip);
        }
    }
}

