/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.servletBase;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.value.StringValue;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.limit.ExcessiveWorkException;
import org.apache.lucene.limit.TermLimitException;
import org.cdlib.xtf.saxonExt.sql.SQLConnect;
import org.cdlib.xtf.servletBase.CQLParseException;
import org.cdlib.xtf.servletBase.LatencyCutoffStream;
import org.cdlib.xtf.servletBase.SessionURLRewriter;
import org.cdlib.xtf.servletBase.StylesheetCache;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.textEngine.DefaultQueryProcessor;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textIndexer.tokenizer.XTFTokenizer;
import org.cdlib.xtf.util.Attrib;
import org.cdlib.xtf.util.AttribList;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.GeneralException;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.ThreadWatcher;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLFormatter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;
import org.cdlib.xtf.xslt.FileUtils;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParser;

public abstract class TextServlet
extends HttpServlet {
    public StylesheetCache stylesheetCache;
    private ServletContext staticContext;
    private String baseDir;
    private boolean isInitted = false;
    private ThreadLocal<String> errorGenSheet = new ThreadLocal();
    private long configFileLastModified = 0L;
    private static ThreadLocal curServlet = new ThreadLocal();
    private static ThreadLocal curRequest = new ThreadLocal();
    private static ThreadLocal curResponse = new ThreadLocal();
    private static final String SAVE_WILD_STAR = "jwxbkn";
    private static final String SAVE_WILD_QMARK = "vkyqxw";

    public static String getText(EasyNode element) {
        String text = "";
        for (int i = 0; i < element.nChildren(); ++i) {
            EasyNode n = element.child(i);
            if (!n.isText()) continue;
            text = text + n.toString();
        }
        return text.trim();
    }

    public String getRealPath(String partialPath) {
        if (this.staticContext == null) {
            return partialPath;
        }
        if (partialPath.startsWith("http://")) {
            return partialPath;
        }
        if (partialPath.startsWith("/") || partialPath.startsWith("\\")) {
            return partialPath;
        }
        if (partialPath.length() > 1 && partialPath.charAt(1) == ':') {
            return partialPath;
        }
        if (!TextServlet.isEmpty(this.baseDir)) {
            return Path.resolveRelOrAbs(this.baseDir, partialPath);
        }
        return this.staticContext.getRealPath(partialPath);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static void requireOrElse(String value, String descrip) throws GeneralException {
        if (TextServlet.isEmpty(value)) {
            throw new GeneralException(descrip);
        }
    }

    public static TextServlet getCurServlet() {
        return (TextServlet)((Object)curServlet.get());
    }

    public static HttpServletRequest getCurRequest() {
        return (HttpServletRequest)curRequest.get();
    }

    public static HttpServletResponse getCurResponse() {
        return (HttpServletResponse)curResponse.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void firstTimeInit(boolean forceInit) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            this.staticContext = this.getServletContext();
            this.baseDir = this.getServletConfig().getInitParameter("base-dir");
            if (!TextServlet.isEmpty(this.baseDir) && !this.baseDir.endsWith("/")) {
                this.baseDir = this.baseDir + "/";
            }
            String configPath = this.getRealPath(this.getConfigName());
            File configFile = new File(configPath);
            if (this.configFileLastModified > 0L && configFile.lastModified() != this.configFileLastModified) {
                this.stylesheetCache.clear();
                this.isInitted = false;
            }
            this.configFileLastModified = configFile.lastModified();
            if (forceInit) {
                this.isInitted = false;
            }
            if (this.isInitted) {
                return;
            }
            TextConfig config = this.readConfig(configPath);
            Trace.printTimestamps(true);
            Trace.setAutoFlush(true);
            Trace.setOutputLevel(config.logLevel.equals("silent") ? 0 : (config.logLevel.equals("errors") ? 1 : (config.logLevel.equals("warnings") ? 2 : (config.logLevel.equals("debug") ? 8 : 4))));
            Trace.error("");
            Trace.error("*** SERVLET RESTART: " + this.getServletInfo() + " ***");
            Trace.error("");
            Trace.error("Log level: " + config.logLevel);
            this.stylesheetCache = new StylesheetCache(config.stylesheetCacheSize, config.stylesheetCacheExpire, config.dependencyCheckingEnabled);
            this.isInitted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        LatencyCutoffStream cutoffStream;
        String requestUrl;
        long reqStartTime;
        TextConfig config;
        block9: {
            String clearCaches = req.getParameter("clear-caches");
            this.firstTimeInit("yes".equals(clearCaches));
            config = this.getConfig();
            reqStartTime = 0L;
            if (config.reportLatency) {
                reqStartTime = System.currentTimeMillis();
            }
            req = new RequestWrapper((HttpServletRequest)req);
            requestUrl = TextServlet.getRequestURL(req);
            cutoffStream = null;
            if (config.reportLatency && config.latencyCutoffSize > 0) {
                cutoffStream = new LatencyCutoffStream((OutputStream)res.getOutputStream(), config.latencyCutoffSize, reqStartTime, requestUrl);
                res = new ResponseWrapper((HttpServletResponse)res, cutoffStream);
            }
            curServlet.set(this);
            curRequest.set(req);
            curResponse.set(res);
            XTFSaxonErrorListener.clearThreadErrors();
            this.errorGenSheet.set(config.errorGenSheet);
            if (config.trackSessions) {
                req.getSession(true);
            }
            boolean trackRunaway = config.runawayNormalTime > 0L || config.runawayKillTime > 0L;
            try {
                if (trackRunaway) {
                    ThreadWatcher.beginWatch(requestUrl, config.runawayNormalTime * 1000L, config.runawayKillTime * 1000L);
                }
                super.service(req, res);
                res.getOutputStream().flush();
                Object var11_9 = null;
                if (!trackRunaway) break block9;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (trackRunaway) {
                    ThreadWatcher.endWatch();
                }
                SQLConnect.closeThreadConnections();
                if (config.reportLatency) {
                    long latency = System.currentTimeMillis() - reqStartTime;
                    boolean alreadyPrinted = cutoffStream != null && cutoffStream.isReported();
                    String extraText = alreadyPrinted ? " (final)" : "";
                    Trace.info("Latency" + extraText + ": " + latency + " msec for request: " + requestUrl);
                }
                FileUtils.deleteTempFiles();
                curServlet.set(null);
                curRequest.set(null);
                curResponse.set(null);
                throw throwable;
            }
            ThreadWatcher.endWatch();
        }
        SQLConnect.closeThreadConnections();
        if (config.reportLatency) {
            long latency = System.currentTimeMillis() - reqStartTime;
            boolean alreadyPrinted = cutoffStream != null && cutoffStream.isReported();
            String extraText = alreadyPrinted ? " (final)" : "";
            Trace.info("Latency" + extraText + ": " + latency + " msec for request: " + requestUrl);
        }
        FileUtils.deleteTempFiles();
        curServlet.set(null);
        curRequest.set(null);
        curResponse.set(null);
    }

    public void setErrorGenSheet(String newPath) {
        this.errorGenSheet.set(newPath);
    }

    public abstract void doGet(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doGet(req, resp);
    }

    public abstract String getConfigName();

    protected abstract TextConfig readConfig(String var1);

    public abstract TextConfig getConfig();

    public boolean isSessionTrackingEnabled() {
        return this.getConfig().trackSessions;
    }

    public static String getRequestURL(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        if (url.indexOf(63) < 0 && req.getQueryString() != null && req.getQueryString().length() > 0) {
            url = url + "?" + req.getQueryString();
        }
        if (url.indexOf("jsessionid") >= 0) {
            url = url.replaceAll("[&;]jsessionid=[a-zA-Z0-9]+", "");
        }
        url = TextServlet.decodeURL(url);
        url = TextServlet.convertUTF8inURL(url);
        return url;
    }

    public void stuffAttribs(Transformer trans, HttpServletRequest req) {
        Enumeration p = req.getParameterNames();
        while (p.hasMoreElements()) {
            String name = (String)p.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (String value : values) {
                if (value == null || value.length() == 0) continue;
                value = TextServlet.convertUTF8inURL(value);
                trans.setParameter(name, new StringValue(value));
            }
        }
        this.stuffSpecialAttribs(req, trans);
    }

    public static void stuffAttribs(Transformer trans, AttribList list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Attrib a = (Attrib)i.next();
            if (a.value == null || a.value.length() == 0) continue;
            trans.setParameter(a.key, new StringValue(a.value));
        }
    }

    public void stuffSpecialAttribs(HttpServletRequest req, Transformer trans) {
        String lookFor;
        int slashPos;
        String uri = req.getRequestURL().toString();
        if (!uri.startsWith("http")) {
            uri = req.getRequestURI();
        }
        if (uri.indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        uri = TextServlet.decodeURL(uri);
        uri = TextServlet.convertUTF8inURL(uri);
        trans.setParameter("servlet.URL", new StringValue(uri));
        trans.setParameter("servlet.path", new StringValue(uri));
        String rootPath = uri;
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if ((slashPos = rootPath.lastIndexOf(47)) >= 1) {
            rootPath = rootPath.substring(0, slashPos);
        }
        if (rootPath.endsWith(lookFor = "/servlet")) {
            rootPath = rootPath.substring(0, rootPath.length() - lookFor.length());
        }
        rootPath = rootPath + "/";
        trans.setParameter("root.URL", new StringValue(rootPath));
        trans.setParameter("root.path", new StringValue(rootPath));
        String xtfHome = Path.normalizePath(this.getRealPath(""));
        trans.setParameter("servlet.dir", xtfHome);
        Enumeration i = req.getHeaderNames();
        trans.setParameter("http.URL", TextServlet.getRequestURL(req));
        while (i.hasMoreElements()) {
            String name = (String)i.nextElement();
            String value = req.getHeader(name);
            trans.setParameter("http." + name, new StringValue(value));
            if (name.equals(name.toLowerCase())) continue;
            trans.setParameter("http." + name.toLowerCase(), new StringValue(value));
        }
    }

    protected void readBranding(String path, HttpServletRequest req, Transformer targetTrans) throws Exception {
        if (path == null || path.equals("")) {
            return;
        }
        Templates pss = this.stylesheetCache.find(path);
        Transformer trans = pss.newTransformer();
        this.stuffAttribs(trans, req);
        TextServlet.stuffAttribs(trans, this.getConfig().attribs);
        String doc = "<dummy>dummy</dummy>\n";
        StreamSource src = new StreamSource(new StringReader(doc));
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        TreeBuilder result = new TreeBuilder();
        trans.transform(src, result);
        EasyNode root = new EasyNode(result.getCurrentRoot());
        for (int i = 0; i < root.nChildren(); ++i) {
            EasyNode el = root.child(i);
            if (!el.isElement()) continue;
            String tagName = el.name();
            String strVal = TextServlet.getText(el);
            targetTrans.setParameter(tagName, new StringValue(strVal));
        }
    }

    public Result createFilteredReceiver(Transformer trans, HttpServletRequest req, HttpServletResponse res) throws XPathException, IOException {
        StreamResult stream = new StreamResult((OutputStream)res.getOutputStream());
        TextConfig config = this.getConfig();
        if (config.trackSessions && config.sessionEncodeURLPattern != null) {
            Controller controller = (Controller)trans;
            SerializerFactory factory = controller.getConfiguration().getSerializerFactory();
            Receiver target = factory.getReceiver(stream, controller.makePipelineConfiguration(), trans.getOutputProperties());
            return new SessionURLRewriter(target, config.sessionEncodeURLPattern, req, res);
        }
        return stream;
    }

    public static String makeHtmlString(String s) {
        return TextServlet.makeHtmlString(s, false);
    }

    public static String makeHtmlString(String s, boolean keepTags) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean inTag = false;
        block40: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (keepTags && !inTag && c == '<') {
                inTag = true;
                buf.append(c);
                continue;
            }
            if (keepTags && inTag && c == '>') {
                inTag = false;
                buf.append(c);
                continue;
            }
            if (inTag) {
                buf.append(c);
                continue;
            }
            if (c == '&') {
                int j;
                for (j = i + 1; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
                }
                if (j < s.length() && s.charAt(j) == ';') {
                    while (i <= j) {
                        buf.append(s.charAt(i++));
                    }
                    --i;
                    continue;
                }
            }
            if (c >= '\u0000' && c <= '\u001f' && c != '\t' && c != '\u000b' && c != '\r') continue;
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block40;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block40;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block40;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block40;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block40;
                }
                case '\n': {
                    buf.append("<br/>\n");
                    continue block40;
                }
                case '\u0080': {
                    buf.append("\u20ac");
                    continue block40;
                }
                case '\u0081': {
                    buf.append("\u0081");
                    continue block40;
                }
                case '\u0082': {
                    buf.append("\u201a");
                    continue block40;
                }
                case '\u0083': {
                    buf.append("\u0192");
                    continue block40;
                }
                case '\u0084': {
                    buf.append("\u201e");
                    continue block40;
                }
                case '\u0085': {
                    buf.append("\u2026");
                    continue block40;
                }
                case '\u0086': {
                    buf.append("\u2020");
                    continue block40;
                }
                case '\u0087': {
                    buf.append("\u2021");
                    continue block40;
                }
                case '\u0088': {
                    buf.append("\u02c6");
                    continue block40;
                }
                case '\u0089': {
                    buf.append("\u2030");
                    continue block40;
                }
                case '\u008a': {
                    buf.append("\u0160");
                    continue block40;
                }
                case '\u008b': {
                    buf.append("\u2039");
                    continue block40;
                }
                case '\u008c': {
                    buf.append("\u0152");
                    continue block40;
                }
                case '\u008d': {
                    buf.append("\u008d");
                    continue block40;
                }
                case '\u008e': {
                    buf.append("\u017d");
                    continue block40;
                }
                case '\u008f': {
                    buf.append("\u008f");
                    continue block40;
                }
                case '\u0090': {
                    buf.append("\u0090");
                    continue block40;
                }
                case '\u0091': {
                    buf.append("\u2018");
                    continue block40;
                }
                case '\u0092': {
                    buf.append("\u2019");
                    continue block40;
                }
                case '\u0093': {
                    buf.append("\u201c");
                    continue block40;
                }
                case '\u0094': {
                    buf.append("\u201d");
                    continue block40;
                }
                case '\u0095': {
                    buf.append("\u2022");
                    continue block40;
                }
                case '\u0096': {
                    buf.append("\u2013");
                    continue block40;
                }
                case '\u0097': {
                    buf.append("\u2014");
                    continue block40;
                }
                case '\u0098': {
                    buf.append("\u02dc");
                    continue block40;
                }
                case '\u0099': {
                    buf.append("\u2122");
                    continue block40;
                }
                case '\u009a': {
                    buf.append("\u0161");
                    continue block40;
                }
                case '\u009b': {
                    buf.append("\u203a");
                    continue block40;
                }
                case '\u009c': {
                    buf.append("\u0153");
                    continue block40;
                }
                case '\u009d': {
                    buf.append("\u009d");
                    continue block40;
                }
                case '\u009e': {
                    buf.append("\u017e");
                    continue block40;
                }
                case '\u009f': {
                    buf.append("\u0178");
                    continue block40;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static QueryProcessor createQueryProcessor() {
        String propName = "org.cdlib.xtf.QueryProcessorClass";
        String className = System.getProperty("org.cdlib.xtf.QueryProcessorClass");
        Class theClass = DefaultQueryProcessor.class;
        try {
            if (className != null) {
                theClass = Class.forName(className);
            }
            return (QueryProcessor)theClass.newInstance();
        }
        catch (ClassCastException e) {
            Trace.error("Error: Class '" + className + "' specified by " + "the '" + "org.cdlib.xtf.QueryProcessorClass" + "' property is not an instance of " + QueryProcessor.class.getName());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Trace.error("Error creating instance of class '" + className + "' specified by the '" + "org.cdlib.xtf.QueryProcessorClass" + "' property");
            throw new RuntimeException(e);
        }
    }

    public static String decodeURL(String value) {
        try {
            return URLDecoder.decode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertUTF8inURL(String value) {
        char[] chars = value.toCharArray();
        boolean foundUTF = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ((c & 0xFF00) != 0) {
                return value;
            }
            if (c <= '\u007f') continue;
            if (c >= '\u00c0' && c <= '\u00df' && i + 1 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf') {
                foundUTF = true;
                ++i;
                continue;
            }
            if (c >= '\u00e0' && c <= '\u00ef' && i + 2 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf' && chars[i + 2] >= '\u0080' && chars[i + 2] <= '\u00bf') {
                foundUTF = true;
                i += 2;
                continue;
            }
            if (c >= '\u00f0' && c <= '\u00f7' && i + 3 < chars.length && chars[i + 1] >= '\u0080' && chars[i + 1] <= '\u00bf' && chars[i + 2] >= '\u0080' && chars[i + 2] <= '\u00bf' && chars[i + 3] >= '\u0080' && chars[i + 3] <= '\u00bf') {
                foundUTF = true;
                i += 3;
                continue;
            }
            if (c >= '\u0080' && c <= '\u00bf') {
                return value;
            }
            if (c < '\u00f8' || c > '\u00ff') continue;
            return value;
        }
        if (!foundUTF) {
            return value;
        }
        try {
            byte[] bytes = value.getBytes("ISO-8859-1");
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public void buildParamBlock(AttribList atts, XMLFormatter fmt, Map tokenizerMap, String extra) {
        fmt.beginTag("parameters");
        if (extra != null) {
            fmt.rawText(extra + "\n");
        }
        Iterator iter = atts.iterator();
        while (iter.hasNext()) {
            Attrib att = (Attrib)iter.next();
            if (att.key.equals("servlet.path") || att.key.equals("root.path") || att.key.startsWith("http.") || att.key.equals("raw") || att.key.equals("debugStep") || att.value == null || att.value.length() == 0) continue;
            this.addParam(fmt, att.key, att.value, tokenizerMap);
        }
        fmt.endTag();
    }

    protected void addParam(XMLFormatter fmt, String name, String val, Map tokenizerMap) {
        fmt.beginTag("param");
        fmt.attr("name", name);
        fmt.attr("value", val);
        if (tokenizerMap != null) {
            String tokenizer = (String)tokenizerMap.get(name);
            if (tokenizer == null || tokenizer.equalsIgnoreCase("default") || tokenizer.equalsIgnoreCase("basic")) {
                this.defaultTokenize(fmt, name, val);
            } else if (tokenizer.equalsIgnoreCase("CQL")) {
                this.cqlTokenize(fmt, name, val);
            } else if (tokenizer.equalsIgnoreCase("raw")) {
                this.rawTokenize(fmt, name, val);
            }
        }
        fmt.endTag();
    }

    protected void rawTokenize(XMLFormatter fmt, String name, String val) {
        StringWriter strOut = new StringWriter();
        try {
            Transformer trans = IndexUtil.createTransformer();
            Properties props = trans.getOutputProperties();
            props.put("indent", "yes");
            props.put("method", "xml");
            props.put("omit-xml-declaration", "yes");
            trans.setOutputProperties(props);
            trans.transform(new StreamSource(new StringReader(val)), new StreamResult(strOut));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        fmt.rawText(strOut.toString());
    }

    protected void defaultTokenize(XMLFormatter fmt, String name, String val) {
        String tmpStr;
        int i;
        char[] chars = val.toCharArray();
        char inQuote = '\u0000';
        int start = 0;
        for (i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == inQuote) {
                if (i > start) {
                    tmpStr = new String(chars, start, i - start);
                    this.addTokens(inQuote, fmt, tmpStr);
                }
                inQuote = '\u0000';
                start = i + 1;
                continue;
            }
            if (inQuote != '\u0000' || c != '\"') continue;
            if (i > start) {
                tmpStr = new String(chars, start, i - start);
                this.addTokens(inQuote, fmt, tmpStr);
            }
            inQuote = c;
            start = i + 1;
        }
        if (i > start) {
            tmpStr = new String(chars, start, i - start);
            this.addTokens(inQuote, fmt, tmpStr);
        }
    }

    protected void cqlTokenize(XMLFormatter fmt, String name, String val) {
        CQLParser parser = new CQLParser();
        try {
            CQLNode parsed = parser.parse(val);
            String text = parsed.toXCQL(fmt.tabCount() / 2);
            fmt.rawText(text);
        }
        catch (org.z3950.zing.cql.CQLParseException e) {
            throw new CQLParseException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addTokens(char inQuote, XMLFormatter fmt, String str) {
        block6: {
            if (inQuote != '\u0000') {
                fmt.beginTag("phrase");
                fmt.attr("value", str);
                this.defaultTokenize(fmt, "phrase", str);
                fmt.endTag();
                return;
            }
            str = TextServlet.saveWildcards(str);
            try {
                Token tok;
                XTFTokenizer toks = new XTFTokenizer(new StringReader(str));
                int prevEnd = 0;
                while ((tok = toks.next()) != null) {
                    if (tok.startOffset() > prevEnd) {
                        this.addToken(fmt, str.substring(prevEnd, tok.startOffset()), false);
                    }
                    prevEnd = tok.endOffset();
                    this.addToken(fmt, tok.termText(), true);
                }
                if (str.length() > prevEnd) {
                    this.addToken(fmt, str.substring(prevEnd, str.length()), false);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)"How can analyzer throw IO error on string buffer?");
            }
        }
    }

    protected void addToken(XMLFormatter fmt, String str, boolean isWord) {
        if ((str = str.trim()).length() == 0) {
            return;
        }
        str = TextServlet.restoreWildcards(str);
        fmt.beginTag("token");
        fmt.attr("value", str);
        fmt.attr("isWord", isWord ? "yes" : "no");
        fmt.endTag();
    }

    protected static String saveWildcards(String s) {
        if (s.indexOf(42) < 0 && s.indexOf(63) < 0) {
            return s;
        }
        s = s.replaceAll("\\*", SAVE_WILD_STAR);
        s = s.replaceAll("\\?", SAVE_WILD_QMARK);
        return s;
    }

    protected static String restoreWildcards(String s) {
        if (s.indexOf(SAVE_WILD_STAR) < 0 && s.indexOf(SAVE_WILD_QMARK) < 0) {
            return s;
        }
        s = s.replaceAll(SAVE_WILD_STAR, "*");
        s = s.replaceAll(SAVE_WILD_QMARK, "?");
        return s;
    }

    protected static String calcMimeType(Templates stylesheet) {
        Properties details = stylesheet.getOutputProperties();
        String mime = details.getProperty("media-type");
        if (mime == null) {
            String method = details.getProperty("method");
            mime = method == null ? "text/html" : (method.equalsIgnoreCase("xml") ? "text/xml" : (method.equalsIgnoreCase("xhtml") ? "application/xhtml+xml" : (method.equals("text") ? "text/plain" : (method.equals("html") ? "text/html" : "text/html"))));
        }
        return mime;
    }

    protected void genErrorPage(HttpServletRequest req, HttpServletResponse res, Exception exc) {
        ByteArrayOutputStream traceStream = new ByteArrayOutputStream();
        exc.printStackTrace(new PrintStream(traceStream));
        String strStackTrace = traceStream.toString();
        String[] saxonErrors = XTFSaxonErrorListener.getThreadErrors();
        if (saxonErrors != null) {
            StringBuffer buf = new StringBuffer();
            for (String s : saxonErrors) {
                buf.append(s + "\n");
            }
            buf.append("\n");
            strStackTrace = buf.toString() + strStackTrace;
        }
        String htmlStackTrace = TextServlet.makeHtmlString(strStackTrace);
        try {
            Transformer trans;
            ServletOutputStream out = res.getOutputStream();
            String raw = req.getParameter("raw");
            if (raw == null) {
                raw = (String)req.getAttribute("org.cdlib.xtf.servlet.raw");
            }
            if ("yes".equals(raw) || "true".equals(raw) || "1".equals(raw)) {
                res.setContentType("text/xml");
                trans = IndexUtil.createTransformer();
                Properties props = trans.getOutputProperties();
                props.put("indent", "yes");
                props.put("method", "xml");
                trans.setOutputProperties(props);
            } else {
                TextConfig config = this.getConfig();
                Templates pss = this.stylesheetCache.find(this.errorGenSheet.get());
                res.setContentType(TextServlet.calcMimeType(pss));
                trans = pss.newTransformer();
                this.stuffAttribs(trans, req);
                TextServlet.stuffAttribs(trans, config.attribs);
            }
            String className = exc.getClass().getName().replaceAll(".*\\.", "").replaceAll(".*\\$", "").replaceAll("Exception", "").replaceAll("Error", "");
            StringBuffer doc = new StringBuffer(2048);
            doc.append("<" + className + ">\n");
            trans.setParameter("exception", new StringValue(className));
            String msg = TextServlet.makeHtmlString(exc.getMessage());
            if (!TextServlet.isEmpty(msg)) {
                doc.append("<message>" + msg + "</message>\n");
                trans.setParameter("message", new StringValue(msg));
            }
            if (exc instanceof GeneralException) {
                GeneralException bve = (GeneralException)exc;
                Iterator i = bve.attribs.iterator();
                while (i.hasNext()) {
                    Attrib a = (Attrib)i.next();
                    doc.append("<" + a.key + ">");
                    doc.append(a.value);
                    doc.append("</" + a.key + ">\n");
                    trans.setParameter(a.key, new StringValue(a.value));
                }
            }
            if (!(exc instanceof ExcessiveWorkException || exc instanceof TermLimitException || exc instanceof GeneralException && !((GeneralException)exc).isSevere())) {
                doc.append("<stackTrace>\n" + htmlStackTrace + "</stackTrace>\n");
                trans.setParameter("stackTrace", new StringValue(htmlStackTrace));
            }
            doc.append("</" + className + ">\n");
            if (!(exc instanceof GeneralException) || ((GeneralException)exc).isSevere()) {
                Trace.error("Error: " + doc.toString().replaceAll("<br/>\n", ""));
            }
            StreamSource src = new StreamSource(new StringReader(doc.toString()));
            StreamResult dst = new StreamResult((OutputStream)out);
            trans.transform(src, dst);
        }
        catch (Exception e) {
            try {
                Trace.error("Unable to generate error page because: " + e.getMessage() + "\n" + "Original problem: " + exc.getMessage() + "\n" + strStackTrace);
                ServletOutputStream out = res.getOutputStream();
                out.println("<HTML><BODY>");
                out.println("<B>Servlet configuration error:</B><br/>");
                out.println("Unable to generate error page: " + e.getMessage() + "<br>");
                out.println("Caused by: " + exc.getMessage() + "<br/>" + htmlStackTrace);
                out.println("</BODY></HTML>");
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
    }

    protected AttribList makeAttribList(HttpServletRequest req) {
        AttribList attribs = new AttribList();
        Enumeration p = req.getParameterNames();
        while (p.hasMoreElements()) {
            String name = (String)p.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (String value : values) {
                attribs.put(name, TextServlet.convertUTF8inURL(value));
            }
        }
        return attribs;
    }

    private class ResponseWrapper
    extends HttpServletResponseWrapper {
        private ServletOutputStream substOutStream;

        ResponseWrapper(HttpServletResponse toWrap, ServletOutputStream substOutStream) {
            super(toWrap);
            this.substOutStream = substOutStream;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.substOutStream;
        }
    }

    private class RequestWrapper
    extends HttpServletRequestWrapper {
        HttpServletRequest inReq;
        HashMap<String, ArrayList<String>> params;

        RequestWrapper(HttpServletRequest inReq) {
            super(inReq);
            this.inReq = inReq;
        }

        private void init() {
            if (this.params != null) {
                return;
            }
            this.params = new HashMap();
            Enumeration paramNames = this.inReq.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String[] vals;
                String name = (String)paramNames.nextElement();
                for (String val : vals = this.inReq.getParameterValues(name)) {
                    if (val.indexOf(59) < 0) {
                        if (name.equals("jsessionid")) continue;
                        this.addParam(name, val);
                        continue;
                    }
                    StringTokenizer tokenizer = new StringTokenizer(val, ";");
                    while (tokenizer.hasMoreTokens()) {
                        String tok = tokenizer.nextToken();
                        int equalPos = tok.indexOf(61);
                        if (equalPos >= 0) {
                            name = tok.substring(0, equalPos);
                            val = tok.substring(equalPos + 1);
                        } else {
                            val = tok;
                        }
                        if (name != null && !name.equals("jsessionid")) {
                            this.addParam(name, val);
                        }
                        name = null;
                    }
                }
            }
        }

        private void addParam(String name, String val) {
            ArrayList<String> vals = this.params.get(name);
            if (vals == null) {
                vals = new ArrayList();
                this.params.put(name, vals);
            }
            vals.add(val);
        }

        public Enumeration getParameterNames() {
            this.init();
            Set<String> keys = this.params.keySet();
            ArrayList<String> keyColl = new ArrayList<String>(keys);
            Collections.sort(keyColl);
            final Iterator<String> iter = keyColl.iterator();
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                public Object nextElement() {
                    return iter.next();
                }
            };
        }

        public String getParameter(String name) {
            this.init();
            ArrayList<String> vals = this.params.get(name);
            if (vals == null) {
                return null;
            }
            return vals.get(0);
        }

        public String[] getParameterValues(String name) {
            this.init();
            ArrayList<String> vals = this.params.get(name);
            if (vals == null) {
                return null;
            }
            return vals.toArray(new String[vals.size()]);
        }

        public Map getParameterMap() {
            throw new UnsupportedOperationException();
        }
    }
}

