/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.tree.TreeBuilder;
import org.cdlib.xtf.lazyTree.LazyKeyManager;
import org.cdlib.xtf.lazyTree.SearchTree;
import org.cdlib.xtf.servletBase.StylesheetCache;
import org.cdlib.xtf.textEngine.DefaultQueryProcessor;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryRequestParser;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.textEngine.XtfBigramQueryRewriter;
import org.cdlib.xtf.textIndexer.TagFilter;
import org.cdlib.xtf.textIndexer.TextIndexer;
import org.cdlib.xtf.util.CircularQueue;
import org.cdlib.xtf.util.DiskHashWriter;
import org.cdlib.xtf.util.FastIntCache;
import org.cdlib.xtf.util.FastStringCache;
import org.cdlib.xtf.util.IntHash;
import org.cdlib.xtf.util.IntMultiMap;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.TagArray;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class RegressTest {
    int nRun = 0;
    int nSucceeded = 0;
    String baseDir;
    File filterDir;
    File filterFile;
    LinkedList failedTests = new LinkedList();
    static Configuration config = new Configuration();
    StylesheetCache stylesheetCache = new StylesheetCache(10, 0, false);

    public static void main(String[] args) {
        boolean ok = false;
        if (!$assertionsDisabled) {
            ok = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!ok) {
            Trace.error("Error: Regression requires assertions to be enabled.\n       Pass -enableassertions command-line switch to JVM.");
            System.exit(1);
        }
        Path.tester.test();
        StructuredFile.tester.test();
        IntHash.tester.test();
        DiskHashWriter.tester.test();
        CircularQueue.tester.test();
        XtfBigramQueryRewriter.tester.test();
        TagFilter.tester.test();
        FastIntCache.tester.test();
        FastStringCache.tester.test();
        TagArray.tester.test();
        IntMultiMap.tester.test();
        RegressTest test = new RegressTest();
        test.run(args);
        System.exit(0);
    }

    public void run(String[] args) {
        try {
            if (args.length > 0) {
                this.filterFile = new File(args[0]).getAbsoluteFile();
                if (!this.filterFile.exists()) {
                    this.filterFile = new File(args[0] + "-in.xml").getAbsoluteFile();
                }
                if (!this.filterFile.exists()) {
                    Trace.error("Unable to locate " + args[0]);
                    System.exit(1);
                }
                if (this.filterFile.isDirectory()) {
                    this.filterDir = this.filterFile;
                    this.filterFile = null;
                } else {
                    this.filterDir = this.filterFile.getParentFile();
                }
            }
            this.processDir(new File(System.getProperty("user.dir")), new LinkedList());
        }
        catch (Exception e) {
            Trace.error("Unexpected regress error: " + e);
        }
        if (this.nRun == 0) {
            Trace.info("\nNo tests found to run.");
        } else if (this.nRun == this.nSucceeded) {
            Trace.info("\nAll " + this.nRun + " tests passed.");
        } else {
            Trace.info("\n" + this.nRun + " tests ran, but " + (this.nRun - this.nSucceeded) + " failed.");
        }
        if (!this.failedTests.isEmpty()) {
            Trace.warning("Failed tests:");
            while (!this.failedTests.isEmpty()) {
                Trace.warning(this.failedTests.removeFirst().toString());
            }
        }
    }

    private void processDir(File curFile, LinkedList inFiles) throws IOException {
        if (this.baseDir == null) {
            this.baseDir = curFile.toString();
        }
        if (curFile.isDirectory()) {
            String[] files = curFile.list();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                list.add(files[i]);
            }
            Collections.sort(list);
            LinkedList newInFiles = new LinkedList();
            for (int i = 0; i < list.size(); ++i) {
                this.processDir(new File(curFile, (String)list.get(i)), newInFiles);
            }
            if (newInFiles.isEmpty()) {
                return;
            }
            this.runTests(newInFiles);
            return;
        }
        String path = curFile.toString();
        if (path.endsWith("IndexConfig.xml")) {
            if (this.filterDir == null || curFile.getParentFile().equals(this.filterDir)) {
                this.index(curFile);
            }
            return;
        }
        if (path.endsWith("-in.xml") && (this.filterDir == null || curFile.getParentFile().equals(this.filterDir)) && (this.filterFile == null || curFile.equals(this.filterFile))) {
            inFiles.add(curFile);
        }
    }

    private void index(File configFile) throws IOException {
        String dir = configFile.getParentFile().toString();
        System.setProperty("user.dir", new File(dir).getAbsolutePath());
        File indexDir = new File(dir, "IndexDB");
        Path.deleteDir(indexDir);
        System.setProperty("xtf.home", dir);
        String[] args = new String[]{"-trace", "info", "-config", "", "-clean", "-index", "all"};
        args[3] = configFile.toString();
        TextIndexer.main(args);
        Trace.info("");
        Trace.info("");
    }

    private void runTests(LinkedList inFiles) throws IOException {
        while (!inFiles.isEmpty()) {
            File inFile = (File)inFiles.removeFirst();
            this.runTest(inFile);
        }
    }

    private String chopPath(String in) {
        if (in.startsWith(this.baseDir)) {
            in = in.substring(this.baseDir.length());
        }
        if (in.endsWith("-in.xml")) {
            in = in.substring(0, in.length() - 7);
        }
        if (in.startsWith("\\") || in.startsWith("/")) {
            in = in.substring(1);
        }
        return "\"" + in + "\"";
    }

    private void runTest(File inFile) throws IOException {
        ++this.nRun;
        String dir = inFile.getParentFile().toString();
        System.setProperty("user.dir", dir);
        String inFilePath = inFile.toString();
        Trace.info("Running test " + this.chopPath(inFilePath) + "...");
        String testFilePath = this.formPath(inFilePath, "actual");
        File testFile = new File(testFilePath);
        Path.createPath(testFile.getParent());
        NodeInfo queryDoc = null;
        try {
            StreamSource src = new StreamSource(inFile.toString());
            queryDoc = TreeBuilder.build((Source)src, (Stripper)new AllElementStripper(), config);
        }
        catch (Exception e) {
            Trace.error("Unexpected exception while reading " + this.chopPath(inFilePath) + ":\n" + e);
            return;
        }
        try {
            String inSpec = this.readFile(inFile);
            DefaultQueryProcessor processor = new DefaultQueryProcessor();
            QueryRequest request = new QueryRequestParser().parseRequest(queryDoc, new File(dir));
            if (inSpec.indexOf("regress-search-tree") >= 0) {
                Configuration config;
                int n = inSpec.indexOf("regress-search-tree");
                n = inSpec.indexOf("=\"", n) + 2;
                int n2 = inSpec.indexOf("\"", n);
                String docPath = Path.normalizeFileName(dir + "/" + inSpec.substring(n, n2));
                String configPath = Path.normalizeFileName(dir + "/" + "IndexConfig.xml");
                File lazyFile = IndexUtil.calcLazyPath(inFile.getParentFile(), new File(configPath), "all", new File(docPath), false);
                PreparedStylesheet displaySheet = null;
                if (request.displayStyle == null || request.displayStyle.indexOf("NullStyle") >= 0) {
                    config = new Configuration();
                } else {
                    displaySheet = (PreparedStylesheet)this.stylesheetCache.find(request.displayStyle);
                    config = displaySheet.getConfiguration();
                }
                String docKey = IndexUtil.calcDocKey(inFile.getParentFile(), new File(configPath), "all", new File(docPath));
                StructuredFile treeStore = StructuredFile.open(lazyFile);
                SearchTree tree = new SearchTree(config, docKey, treeStore);
                tree.suppressScores(true);
                tree.search(processor, request);
                if (displaySheet == null) {
                    this.writeTree(testFile, tree);
                } else {
                    this.formatTree(testFile, tree, displaySheet);
                }
            } else {
                QueryResult result = ((QueryProcessor)processor).processRequest(request);
                if (request.displayStyle == null || request.displayStyle.indexOf("NullStyle") >= 0) {
                    this.writeHits(testFile, result);
                } else {
                    this.formatHits(testFile, result, request.displayStyle);
                }
            }
        }
        catch (Exception e) {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(testFile), "UTF-8"));
            out.println("Exception encountered:\n" + e);
            out.close();
        }
        String goldFilePath = this.formPath(inFilePath, "gold");
        File goldFile = new File(goldFilePath);
        if (!goldFile.exists()) {
            Trace.info("Missing gold file. Test result was:\n" + this.readFile(testFile));
            Trace.error("   ...test " + this.chopPath(inFilePath) + " failed (missing gold file).\n");
            this.failedTests.add(this.chopPath(inFilePath));
        } else if (!this.filesEqual(goldFile, testFile)) {
            Trace.error("   ...Incorrect result. Test " + this.chopPath(inFilePath) + " failed!\n");
            this.failedTests.add(this.chopPath(inFilePath));
        } else {
            Trace.info("   ...ok");
            ++this.nSucceeded;
        }
    }

    private String formPath(String path, String sub) {
        String tmp = path.replaceAll("-in", "");
        int slashPos = tmp.lastIndexOf(47);
        if (slashPos < 0) {
            slashPos = tmp.lastIndexOf(92);
        }
        assert (slashPos >= 0) : "invalid path";
        tmp = tmp.substring(0, slashPos + 1) + sub + tmp.substring(slashPos);
        return tmp;
    }

    private void writeHits(File outFile, QueryResult result) throws IOException {
        Source hitDoc = result.hitsToSource("crossQueryResult", null);
        String str = XMLWriter.toString(hitDoc);
        str = str.replaceAll(" score=\"\\d+\"", "");
        str = str.replaceAll(" path=\"all:", " file=\"");
        str = str.replaceAll("(<suggestion.*) freq=\"[0-9]+\"", "$1");
        str = str.replaceAll("(<suggestion.*) score=\"[0-9.]+\"", "$1");
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        out.println(str);
        out.close();
    }

    protected void formatHits(File outFile, QueryResult result, String displayStyle) throws Exception {
        Templates displaySheet = this.stylesheetCache.find(displayStyle);
        Transformer trans = displaySheet.newTransformer();
        String hitsString = result.hitsToString("crossQueryResult", null);
        StreamSource sourceDoc = new StreamSource(new StringReader(hitsString));
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        FileOutputStream out = new FileOutputStream(outFile);
        trans.transform(sourceDoc, new StreamResult(out));
        out.close();
    }

    private void writeTree(File outFile, SearchTree tree) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
        PrintWriter out = new PrintWriter(ow);
        String strVersion = XMLWriter.toString(tree);
        out.println(strVersion);
        out.close();
    }

    protected void formatTree(File outFile, SearchTree tree, PreparedStylesheet displaySheet) throws Exception {
        Transformer trans = displaySheet.newTransformer();
        Controller controller = (Controller)trans;
        Executable e = controller.getExecutable();
        KeyManager k = e.getKeyManager();
        if (!(k instanceof LazyKeyManager)) {
            e.setKeyManager(new LazyKeyManager(controller.getConfiguration(), k));
        }
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        FileOutputStream out = new FileOutputStream(outFile);
        trans.transform(tree, new StreamResult(out));
        out.close();
    }

    String[] slurp(String str) {
        BufferedReader br = new BufferedReader(new StringReader(str));
        Vector<String> lines = new Vector<String>(100);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            assert (false) : "String reader should never have IO exception";
            throw new RuntimeException(e);
        }
        return lines.toArray(new String[lines.size()]);
    }

    private boolean sameResults(String result1, String result2) {
        if (result1.equals(result2)) {
            return true;
        }
        if (result1.startsWith("Exception encountered") && result2.startsWith("Exception encountered")) {
            Trace.warning("\nExceptions differ: " + result1 + "\nvs\n" + result2);
            return true;
        }
        Trace.info("\n*** Mismatch! ***");
        return false;
    }

    private boolean filesEqual(File file1, File file2) throws IOException {
        String s1 = this.readFile(file1);
        String s2 = this.readFile(file2);
        return this.sameResults(s1, s2);
    }

    private String readFile(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        int size = (int)file.length();
        char[] buf = new char[size + 1];
        int got = reader.read(buf);
        reader.close();
        if (got == size + 1 || got <= 0) {
            throw new IOException("Error reading file " + file.toString());
        }
        return new String(buf, 0, got).replaceAll("\r\n", "\n");
    }

    static {
        config.setNamePool(NamePool.getDefaultNamePool());
    }
}

