/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;
import org.cdlib.xtf.util.CharMap;

public class AccentFoldingRewriter
extends XtfQueryRewriter {
    private CharMap accentMap;
    private Set tokenizedFields;

    public AccentFoldingRewriter(CharMap accentMap, Set tokFields) {
        this.accentMap = accentMap;
        this.tokenizedFields = tokFields;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        Term t = q.getTerm();
        if (!this.tokenizedFields.contains(t.field())) {
            return q;
        }
        String mapped = this.accentMap.mapWord(t.text());
        if (mapped == null) {
            return q;
        }
        Term newTerm = new Term(t.field(), mapped);
        return this.copyBoost(q, new SpanTermQuery(newTerm, q.getTermLength()));
    }

    protected Query rewrite(SpanWildcardQuery q) {
        assert (q instanceof XtfSpanWildcardQuery);
        Term t = q.getTerm();
        if (!this.tokenizedFields.contains(t.field())) {
            return q;
        }
        String mapped = this.accentMap.mapWord(t.text());
        if (mapped == null) {
            return q;
        }
        Term newTerm = new Term(t.field(), mapped);
        return this.copyBoost(q, new XtfSpanWildcardQuery(newTerm, q.getTermLimit()));
    }
}

