/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.mark.BasicWordIter;
import org.apache.lucene.mark.MarkPos;
import org.cdlib.xtf.textEngine.BoundedMarkPos;

class BoundedWordIter
extends BasicWordIter {
    int boundSize;

    public BoundedWordIter(String text, TokenStream stream, int boundSize) throws IOException {
        super(text, stream);
        this.boundSize = boundSize;
    }

    public final boolean next(boolean force) {
        if (force) {
            return super.next(force);
        }
        if (this.tokNum < this.tokens.length - 1 && this.tokens[this.tokNum + 1].getPositionIncrement() >= this.boundSize) {
            return false;
        }
        int offset = this.tokens[this.tokNum].endOffset();
        if (offset < this.text.length() && this.text.charAt(offset) == '\uee1d') {
            return false;
        }
        return super.next(force);
    }

    public final boolean prev(boolean force) {
        if (force) {
            return super.prev(force);
        }
        if (this.tokens[this.tokNum].getPositionIncrement() >= this.boundSize) {
            return false;
        }
        int offset = this.tokens[this.tokNum].startOffset();
        if (offset > 0 && this.text.charAt(offset - 1) == '\uebeb') {
            return false;
        }
        return super.prev(force);
    }

    public MarkPos getPos(int startOrEnd) {
        BoundedMarkPos pos = new BoundedMarkPos(this.tokens);
        this.getPos(pos, startOrEnd);
        return pos;
    }

    public void getPos(MarkPos pos, int startOrEnd) {
        super.getPos(pos, startOrEnd);
        switch (startOrEnd) {
            case 0: {
                ((BoundedMarkPos)pos).setTokNum(0);
                break;
            }
            case 4: {
                ((BoundedMarkPos)pos).setTokNum(this.tokens.length - 1);
                break;
            }
            case 3: {
                if (startOrEnd == 3) {
                    ((BoundedMarkPos)pos).stripMarkers(this.tokens[this.tokNum].endOffset());
                }
            }
            default: {
                ((BoundedMarkPos)pos).setTokNum(this.tokNum);
            }
        }
    }
}

