/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.FieldSpans;
import org.cdlib.xtf.textEngine.BoostSet;
import org.cdlib.xtf.textEngine.BoostSetParams;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.HitLoadException;
import org.cdlib.xtf.textEngine.Snippet;
import org.cdlib.xtf.textEngine.SnippetMaker;
import org.cdlib.xtf.util.AttribList;

public class DocHitImpl
extends DocHit {
    private SnippetMaker snippetMaker;
    private FieldSpans fieldSpans;
    private Snippet[] snippets;
    private String docKey;
    private long fileDate = -1L;
    private int recordNum = 0;
    private int chunkCount = -1;
    private AttribList metaData;
    private Explanation explanation;
    private static final char bumpMarker = '\uebbb';

    DocHitImpl(int docNum, float score) {
        super(docNum, score);
    }

    void setSpans(FieldSpans spans) {
        this.fieldSpans = spans;
    }

    void finish(SnippetMaker snippetMaker, float docScoreNorm) {
        if (this.snippetMaker != null) {
            return;
        }
        this.snippetMaker = snippetMaker;
        this.score *= docScoreNorm;
    }

    void finishWithExplain(SnippetMaker snippetMaker, float docScoreNorm, Weight weight, BoostSet boostSet, BoostSetParams boostParams) throws IOException {
        if (this.snippetMaker != null) {
            return;
        }
        this.finish(snippetMaker, docScoreNorm);
        this.explanation = weight.explain(snippetMaker.reader, this.doc);
        if (boostSet != null) {
            Explanation result = new Explanation(0.0f, "boosted, product of:");
            Explanation boostExpl = new Explanation(boostSet.getBoost(this.doc, boostParams.defaultBoost), "boostSetFactor");
            if (boostParams.exponent != 1.0f) {
                Explanation exponentExpl = new Explanation((float)Math.pow(boostExpl.getValue(), boostParams.exponent), "exponentBoosted");
                exponentExpl.addDetail(boostExpl);
                exponentExpl.addDetail(new Explanation(boostParams.exponent, "boostSetExponent"));
                boostExpl = exponentExpl;
            }
            result.addDetail(boostExpl);
            result.addDetail(this.explanation);
            result.setValue(boostExpl.getValue() * this.explanation.getValue());
            this.explanation = result;
        }
    }

    private void load() {
        Document docContents;
        try {
            assert (!this.snippetMaker.reader.isDeleted(this.doc));
            docContents = this.snippetMaker.reader.document(this.doc);
        }
        catch (IOException e) {
            throw new HitLoadException(e);
        }
        this.metaData = new AttribList();
        for (Field f : docContents.getFields()) {
            String name = f.name();
            String value = f.stringValue();
            if (name.equals("key")) {
                this.docKey = value;
                continue;
            }
            if (name.equals("fileDate")) {
                try {
                    this.fileDate = DateTools.stringToTime(value);
                }
                catch (ParseException e1) {}
                continue;
            }
            if (name.equals("chunkCount")) {
                this.chunkCount = Integer.parseInt(value);
                continue;
            }
            if (name.equals("recordNum")) {
                this.recordNum = Integer.parseInt(value);
                continue;
            }
            if (name.equals("docInfo")) continue;
            this.loadMetaField(name, value, docContents, this.metaData, f.isTokenized());
        }
        assert (this.docKey != null) : "Incomplete data in index - missing 'key'";
        assert (this.chunkCount != -1) : "Incomplete data in index - missing 'chunkCount'";
    }

    private void loadMetaField(String name, String value, Document docContents, AttribList metaData, boolean isTokenized) {
        String markedValue = isTokenized ? this.snippetMaker.markField(docContents, this.fieldSpans, name, value) : value;
        StringBuffer buf = new StringBuffer(markedValue.length() * 2);
        int prevStart = 0;
        boolean startFound = false;
        for (int i = 0; i < markedValue.length(); ++i) {
            char c = markedValue.charAt(i);
            if (c == '\uebeb') {
                startFound = true;
                if (i > 0 && markedValue.charAt(i - 1) == '>') {
                    int tagStart = buf.lastIndexOf("<$ ");
                    if (tagStart < prevStart) {
                        throw new RuntimeException("Invalid tag data");
                    }
                    buf.replace(tagStart + 1, tagStart + 2, name);
                    continue;
                }
                buf.append("<");
                buf.append(name);
                buf.append(">");
                continue;
            }
            if (c == '\uee1d') {
                buf.append("</");
                buf.append(name);
                buf.append(">");
                continue;
            }
            buf.append(c);
        }
        if (!startFound) {
            if (buf.length() > 3 && buf.substring(0, 3).equals("<$ ")) {
                buf.replace(1, 2, name);
            } else {
                buf.insert(0, "<" + name + ">");
            }
            buf.append("</" + name + ">");
        }
        if ((markedValue = buf.toString()).indexOf(60347) < 0) {
            metaData.put(name, markedValue);
            return;
        }
        int startPos = 0;
        while (startPos < markedValue.length()) {
            int bumpPos = markedValue.indexOf(60347, startPos);
            if (bumpPos < 0) {
                metaData.put(name, markedValue.substring(startPos));
                break;
            }
            String val = markedValue.substring(startPos, bumpPos);
            metaData.put(name, val);
            startPos = 1 + markedValue.indexOf(60347, bumpPos + 1);
            if (!Character.isWhitespace(markedValue.charAt(startPos))) continue;
            ++startPos;
        }
    }

    public Set textTerms() {
        if (this.fieldSpans == null) {
            return null;
        }
        return this.fieldSpans.getTerms("text");
    }

    public final String filePath() {
        if (this.docKey == null) {
            this.load();
        }
        return this.docKey;
    }

    public final int recordNum() {
        if (this.docKey == null) {
            this.load();
        }
        return this.recordNum;
    }

    public final AttribList metaData() {
        if (this.docKey == null) {
            this.load();
        }
        return this.metaData;
    }

    public final int totalSnippets() {
        if (this.fieldSpans == null) {
            return 0;
        }
        return this.fieldSpans.getSpanTotal("text");
    }

    public final int nSnippets() {
        if (this.fieldSpans == null) {
            return 0;
        }
        return this.fieldSpans.getSpanCount("text");
    }

    public final Snippet snippet(int hitNum, boolean getText) {
        if (this.snippets == null || getText && this.snippets[hitNum].text == null) {
            this.snippets = this.snippetMaker.makeSnippets(this.fieldSpans, this.doc, "text", getText);
        }
        return this.snippets[hitNum];
    }

    public Explanation explanation() {
        return this.explanation;
    }
}

