/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.IntList;
import org.apache.lucene.util.LongList;

public class NumericFieldData {
    private static WeakHashMap cache = new WeakHashMap();
    private IntList docs = new IntList();
    private LongList values = new LongList();

    public static NumericFieldData getCachedData(IndexReader reader, String field) throws IOException {
        NumericFieldData data;
        HashMap<String, NumericFieldData> readerCache = (HashMap<String, NumericFieldData>)cache.get(reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, NumericFieldData>();
            cache.put(reader, readerCache);
        }
        if ((data = (NumericFieldData)readerCache.get(field)) == null) {
            data = new NumericFieldData(reader, field);
            readerCache.put(field, data);
        }
        return data;
    }

    public static long parseVal(String str) {
        long ret = 0L;
        for (int i = 0; i < str.length(); ++i) {
            int digit = Character.digit(str.charAt(i), 10);
            if (digit < 0) continue;
            ret = ret * 10L + (long)digit;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NumericFieldData(IndexReader reader, String field) throws IOException {
        TermDocs termDocs = reader.termDocs();
        TermEnum termEnum = reader.terms(new Term(field, ""));
        try {
            Term term;
            if (termEnum.term() == null) {
                throw new IOException("no terms in field " + field);
            }
            while ((term = termEnum.term()).field() == field) {
                String termText = term.text();
                if (termText.length() <= 1 || termText.charAt(0) != '\uebeb' && termText.charAt(termText.length() - 1) != '\uee1d') {
                    long value = NumericFieldData.parseVal(termText);
                    termDocs.seek(termEnum);
                    while (termDocs.next()) {
                        int doc = termDocs.doc();
                        this.docs.add(doc);
                        this.values.add(value);
                    }
                }
                if (termEnum.next()) continue;
            }
            this.docs.compact();
            this.values.compact();
            int[] map = this.docs.calcSortMap();
            this.docs.remap(map);
            this.values.remap(map);
            for (int i = 1; i < this.docs.size(); ++i) {
                if (this.docs.get(i - 1) != this.docs.get(i)) continue;
                throw new IOException("A document contains more than one value in numeric field '" + field + "': values " + this.values.get(i - 1) + " and " + this.values.get(i));
            }
        }
        finally {
            termEnum.close();
            termDocs.close();
        }
    }

    public final int size() {
        return this.docs.size();
    }

    public final int doc(int index) {
        return this.docs.get(index);
    }

    public final long value(int index) {
        return this.values.get(index);
    }

    public final int findDocIndex(int docId) {
        int idx = this.docs.binarySearch(docId);
        if (idx >= 0) {
            return idx;
        }
        return -idx - 1;
    }

    public final int docPos(int docId) {
        return this.docs.binarySearch(docId);
    }
}

