/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanExactQuery
extends SpanQuery {
    private SpanQuery[] clauses;

    public SpanExactQuery(SpanQuery[] clauses) {
        if (clauses == null || clauses.length == 0) {
            throw new RuntimeException("SpanExactQuery requires at least one clause");
        }
        this.clauses = clauses;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ArrayList<SpanQuery> newClauses = new ArrayList<SpanQuery>(this.clauses.length);
        boolean anyChanged = false;
        for (int i = 0; i < this.clauses.length; ++i) {
            SpanQuery clause = this.clauses[i];
            SpanQuery rewrittenClause = (SpanQuery)clause.rewrite(reader);
            newClauses.add(rewrittenClause);
            if (clause == rewrittenClause) continue;
            anyChanged = true;
        }
        if (!anyChanged) {
            return this;
        }
        SpanExactQuery clone = (SpanExactQuery)this.clone();
        clone.clauses = newClauses.toArray(new SpanQuery[newClauses.size()]);
        return clone;
    }

    public SpanQuery[] getClauses() {
        return this.clauses;
    }

    public Query[] getSubQueries() {
        return this.clauses;
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        ArrayList<SpanQuery> newClauses = new ArrayList<SpanQuery>(this.clauses.length);
        for (int i = 0; i < this.clauses.length; ++i) {
            boolean isLast;
            if (!(this.clauses[i] instanceof SpanTermQuery)) {
                throw new RuntimeException("Exact queries only support plain terms");
            }
            boolean isFirst = i == 0;
            boolean bl = isLast = i == this.clauses.length - 1;
            if (!isFirst && !isLast) {
                newClauses.add(this.clauses[i]);
                continue;
            }
            SpanTermQuery oldClause = (SpanTermQuery)this.clauses[i];
            String oldTerm = oldClause.getTerm().text();
            String field = oldClause.getTerm().field();
            int length = oldClause.getTermLength();
            SpanTermQuery detachedStartQuery = new SpanTermQuery(new Term(field, "\uebeb"));
            SpanTermQuery detachedEndQuery = new SpanTermQuery(new Term(field, "\uee1d"));
            ArrayList orClauses = new ArrayList();
            for (int startAtt = 0; startAtt < 3; ++startAtt) {
                if (startAtt == 0 && isFirst || startAtt != 0 && !isFirst) continue;
                for (int endAtt = 0; endAtt < 3; ++endAtt) {
                    int nTerms;
                    if (endAtt == 0 && isLast || endAtt != 0 && !isLast) continue;
                    ArrayList<SpanTermQuery> phraseClauses = new ArrayList<SpanTermQuery>();
                    if (startAtt == 1) {
                        phraseClauses.add(detachedStartQuery);
                    }
                    String newTerm = oldTerm;
                    if (startAtt == 2) {
                        newTerm = '\uebeb' + newTerm;
                    }
                    if (endAtt == 2) {
                        newTerm = newTerm + '\uee1d';
                    }
                    SpanTermQuery newClause = new SpanTermQuery(new Term(field, newTerm), length);
                    newClause.setBoost(oldClause.getBoost());
                    phraseClauses.add(newClause);
                    if (endAtt == 1) {
                        phraseClauses.add(detachedEndQuery);
                    }
                    if ((nTerms = phraseClauses.size()) == 1) {
                        orClauses.add(phraseClauses.get(0));
                        continue;
                    }
                    orClauses.add(new SpanNearQuery(phraseClauses.toArray(new SpanQuery[nTerms]), 0, true));
                }
            }
            if (orClauses.size() == 1) {
                newClauses.add((SpanQuery)orClauses.get(0));
                continue;
            }
            SpanOrQuery orQuery = new SpanOrQuery(orClauses.toArray(new SpanQuery[orClauses.size()]));
            newClauses.add(orQuery);
        }
        SpanNearQuery q = new SpanNearQuery(newClauses.toArray(new SpanQuery[newClauses.size()]), 0, true);
        q.setSpanRecording(this.getSpanRecording());
        return ((SpanQuery)q).getSpans(reader, searcher);
    }

    public String getField() {
        return this.clauses[0].getField();
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (int i = 0; i < this.clauses.length; ++i) {
            SpanQuery clause = this.clauses[i];
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanExact(");
        for (int i = 0; i < this.clauses.length; ++i) {
            SpanQuery clause = this.clauses[i];
            buffer.append(clause.toString(field));
            if (i >= this.clauses.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

