/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.apache.lucene.util.StringUtil;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpellingSuggestion;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;

public class SpellSuggRewriter
extends XtfQueryRewriter {
    private Map suggs;
    private Set fields;

    public SpellSuggRewriter(Map suggs, Set fields) {
        this.suggs = suggs;
        this.fields = fields;
    }

    protected Query rewrite(SpanExactQuery q) {
        return q;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        Term t = q.getTerm();
        if (!this.fields.contains(t.field())) {
            return q;
        }
        SpellingSuggestion sugg = (SpellingSuggestion)this.suggs.get(t.text());
        if (sugg == null) {
            return q;
        }
        if (sugg.suggestedTerm == null) {
            return null;
        }
        if (!sugg.suggestedTerm.contains(" ")) {
            Term newTerm = new Term(t.field(), sugg.suggestedTerm);
            return this.copyBoost(q, new SpanTermQuery(newTerm, q.getTermLength()));
        }
        String[] words = StringUtil.splitWords(sugg.suggestedTerm);
        SpanQuery[] termQueries = new SpanTermQuery[words.length];
        for (int i = 0; i < words.length; ++i) {
            termQueries[i] = new SpanTermQuery(new Term(t.field(), words[i]), 1);
        }
        return this.copyBoost(q, new SpanNearQuery(termQueries, 10, false));
    }

    protected Query rewrite(SpanWildcardQuery q) {
        return q;
    }
}

