/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.cdlib.xtf.util.FastStringReader;
import org.cdlib.xtf.util.FastTokenizer;

public class StdTermFilter {
    private DribbleStream dribble = new DribbleStream();
    private TokenStream filter = new StandardFilter(new LowerCaseFilter(this.dribble));
    private static final String SAVE_WILD_STAR = "jwxbkn";
    private static final String SAVE_WILD_QMARK = "vkyqxw";

    public String filter(String term) {
        this.dribble.nextToken = StdTermFilter.saveWildcards(term);
        try {
            Token mapped = this.filter.next();
            String restored = StdTermFilter.restoreWildcards(mapped.termText());
            if (restored.equals(term)) {
                return term;
            }
            return restored;
        }
        catch (IOException e) {
            throw new RuntimeException("Very unexpected IO exception: " + e);
        }
    }

    protected static String saveWildcards(String s) {
        if (s.indexOf(42) < 0 && s.indexOf(63) < 0) {
            return s;
        }
        s = s.replaceAll("\\*", SAVE_WILD_STAR);
        s = s.replaceAll("\\?", SAVE_WILD_QMARK);
        return s;
    }

    protected static String restoreWildcards(String s) {
        if (s.indexOf(SAVE_WILD_STAR) < 0 && s.indexOf(SAVE_WILD_QMARK) < 0) {
            return s;
        }
        s = s.replaceAll(SAVE_WILD_STAR, "*");
        s = s.replaceAll(SAVE_WILD_QMARK, "?");
        return s;
    }

    private class DribbleStream
    extends TokenStream {
        public String nextToken;

        private DribbleStream() {
        }

        public Token next() throws IOException {
            FastTokenizer toks = new FastTokenizer(new FastStringReader(this.nextToken));
            Token t = toks.next();
            if (t == null) {
                return new Token(this.nextToken, 0, this.nextToken.length());
            }
            if (t.startOffset() != 0 || t.endOffset() != this.nextToken.length()) {
                return new Token(this.nextToken, 0, this.nextToken.length());
            }
            return t;
        }
    }
}

