/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;
import org.cdlib.xtf.textEngine.StdTermFilter;
import org.cdlib.xtf.textEngine.XtfQueryRewriter;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;

public class StdTermRewriter
extends XtfQueryRewriter {
    private Set tokenizedFields;
    private StdTermFilter filter = new StdTermFilter();

    public StdTermRewriter(Set tokFields) {
        this.tokenizedFields = tokFields;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        Term t = q.getTerm();
        String mapped = this.mapTerm(t);
        if (mapped == null) {
            return q;
        }
        Term newTerm = new Term(t.field(), mapped);
        return this.copyBoost(q, new SpanTermQuery(newTerm, q.getTermLength()));
    }

    protected Query rewrite(SpanWildcardQuery q) {
        assert (q instanceof XtfSpanWildcardQuery);
        Term t = q.getTerm();
        String mapped = this.mapTerm(t);
        if (mapped == null) {
            return q;
        }
        Term newTerm = new Term(t.field(), mapped);
        return this.copyBoost(q, new XtfSpanWildcardQuery(newTerm, q.getTermLimit()));
    }

    private String mapTerm(Term t) {
        if (!this.tokenizedFields.contains(t.field())) {
            return null;
        }
        String mapped = this.filter.filter(t.text());
        if (mapped.equals(t.text())) {
            return null;
        }
        return mapped;
    }
}

