/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.lucene.bigram.BigramQueryRewriter;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRewriter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.cdlib.xtf.textEngine.MoreLikeThisQuery;
import org.cdlib.xtf.textEngine.NumericRangeQuery;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpanSectionTypeQuery;
import org.cdlib.xtf.util.Tester;
import org.cdlib.xtf.util.Trace;

public class XtfBigramQueryRewriter
extends BigramQueryRewriter {
    private Set tokenizedFields;
    public static final Tester tester = new Tester("XtfBigramStopFilter"){
        private Set stopSet = new HashSet();

        private String queryToText(Query q) {
            StringBuffer buf = new StringBuffer();
            if (q.getBoost() != 1.0f) {
                float boost = q.getBoost();
                q.setBoost(1.0f);
                buf.append(this.queryToText(q));
                q.setBoost(boost);
                buf.append("^" + (int)boost);
                return buf.toString();
            }
            if (q instanceof SpanTermQuery) {
                return ((SpanTermQuery)q).getTerm().text();
            }
            if (q instanceof TermQuery) {
                return ((TermQuery)q).getTerm().text();
            }
            if (q instanceof SpanNearQuery) {
                SpanQuery[] clauses = ((SpanNearQuery)q).getClauses();
                int slop = ((SpanNearQuery)q).getSlop();
                buf.append("\"");
                for (int i = 0; i < clauses.length; ++i) {
                    if (buf.length() > 1) {
                        buf.append(" ");
                    }
                    buf.append(this.queryToText(clauses[i]));
                }
                buf.append("\"");
                if (slop != 0) {
                    buf.append("~" + slop);
                }
                return buf.toString();
            }
            if (q instanceof SpanOrQuery) {
                SpanQuery[] clauses = ((SpanOrQuery)q).getClauses();
                buf.append("(");
                for (int i = 0; i < clauses.length; ++i) {
                    if (buf.length() > 1) {
                        buf.append(" OR ");
                    }
                    buf.append(this.queryToText(clauses[i]));
                }
                buf.append(")");
                return buf.toString();
            }
            if (q instanceof SpanChunkedNotQuery) {
                SpanChunkedNotQuery nq = (SpanChunkedNotQuery)q;
                buf.append("(");
                buf.append(this.queryToText(nq.getInclude()));
                buf.append(" NOT ");
                buf.append(this.queryToText(nq.getExclude()));
                buf.append(")~" + nq.getSlop());
                return buf.toString();
            }
            if (q instanceof BooleanQuery) {
                BooleanClause[] clauses = ((BooleanQuery)q).getClauses();
                buf.append("(");
                for (int i = 0; i < clauses.length; ++i) {
                    if (buf.length() > 1) {
                        buf.append(" ");
                    }
                    if (clauses[i].getOccur() == BooleanClause.Occur.MUST) {
                        buf.append("+");
                    } else if (clauses[i].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        buf.append("-");
                    }
                    buf.append(this.queryToText(clauses[i].getQuery()));
                }
                buf.append(")");
                return buf.toString();
            }
            return q.toString();
        }

        private SpanQuery term(String text) {
            return new SpanTermQuery(new Term("text", text));
        }

        private SpanQuery[] terms(String text) {
            Vector<SpanQuery> v = new Vector<SpanQuery>();
            StringTokenizer st = new StringTokenizer(text);
            while (st.hasMoreTokens()) {
                v.add(this.term(st.nextToken()));
            }
            return v.toArray(new SpanQuery[v.size()]);
        }

        private SpanQuery or(SpanQuery[] clauses) {
            return new SpanOrQuery(clauses);
        }

        private SpanQuery not(int slop, SpanQuery include, SpanQuery exclude) {
            return new SpanChunkedNotQuery(include, exclude, slop);
        }

        private SpanQuery near(int slop, SpanQuery[] clauses) {
            return new SpanNearQuery(clauses, slop, false);
        }

        private SpanQuery and(SpanQuery[] clauses) {
            return this.near(20, clauses);
        }

        private SpanQuery phrase(SpanQuery[] clauses) {
            return this.near(0, clauses);
        }

        private SpanQuery[] join(SpanQuery q1, SpanQuery q2) {
            SpanQuery[] array = new SpanQuery[]{q1, q2};
            return array;
        }

        private SpanQuery[] join(SpanQuery q1, SpanQuery q2, SpanQuery q3) {
            SpanQuery[] array = new SpanQuery[]{q1, q2, q3};
            return array;
        }

        private Query bool(Query q1, BooleanClause.Occur occur1, Query q2, BooleanClause.Occur occur2, Query q3, BooleanClause.Occur occur3) {
            BooleanQuery q = new BooleanQuery();
            q.add(q1, occur1);
            q.add(q2, occur2);
            if (q3 != null) {
                q.add(q3, occur3);
            }
            return q;
        }

        private Query regTerm(String text) {
            return new TermQuery(new Term("text", text));
        }

        private SpanQuery boost(float factor, SpanQuery q) {
            q.setBoost(factor);
            return q;
        }

        private Query boost(float factor, Query q) {
            q.setBoost(factor);
            return q;
        }

        private void testQuery(Query query, String expectedResult) {
            BigramQueryRewriter rewriter = new BigramQueryRewriter(this.stopSet, 20);
            Query newQ = rewriter.rewriteQuery(query);
            String result = this.queryToText(newQ);
            Trace.debug(this.queryToText(query) + " --> " + result);
            assert (result.equals(expectedResult));
        }

        private void testUnchanged(Query query) {
            BigramQueryRewriter rewriter = new BigramQueryRewriter(this.stopSet, 20);
            Query newQ = rewriter.rewriteQuery(query);
            assert (query == newQ);
        }

        protected void testImpl() {
            this.stopSet = BigramQueryRewriter.makeStopSet("a and it is the of");
            this.testUnchanged(this.phrase(this.terms("hello there")));
            this.testQuery(this.phrase(this.terms("man of war")), "\"man~of of~war\"");
            this.testQuery(this.phrase(this.terms("man of the world")), "\"man~of of~the the~world\"");
            this.testQuery(this.phrase(this.terms("when it is a problem")), "\"when~it it~is is~a a~problem\"");
            this.testQuery(this.phrase(this.terms("and martha is")), "\"and~martha martha~is\"");
            this.testQuery(this.phrase(this.join(this.term("the"), this.or(this.terms("white beige")), this.term("rabbit"))), "\"(the~white OR the~beige) rabbit\"");
            this.testQuery(this.phrase(this.join(this.term("eat"), this.or(this.terms("the a")), this.term("rabbit"))), "\"eat rabbit\"");
            this.testQuery(this.phrase(this.join(this.term("eat"), this.boost(5.0f, this.term("the")), this.term("wave"))), "\"eat~the^5 the~wave^5\"");
            this.testQuery(this.phrase(this.join(this.term("eat"), this.term("the"), this.boost(5.0f, this.term("wave")))), "\"eat~the the~wave^5\"");
            this.testUnchanged(this.and(this.terms("hello there")));
            this.testQuery(this.and(this.terms("man of war")), "\"(man^0 OR man~of) (of~war OR war^0)\"~20");
            this.testQuery(this.and(this.join(this.term("the"), this.or(this.terms("white beige")), this.term("rabbit"))), "\"((the~white OR the~beige) OR (white OR beige)^0) rabbit\"~20");
            this.testQuery(this.boost(2.0f, this.and(this.join(this.term("eat"), this.boost(5.0f, this.term("the")), this.term("wave")))), "\"(eat^0 OR eat~the^5) (the~wave^5 OR wave^0)\"~20^2");
            this.testQuery(this.boost(5.0f, this.and(this.join(this.boost(2.0f, this.term("eat")), this.boost(3.0f, this.or(this.terms("the a")))))), "eat^10");
            this.testUnchanged(this.near(5, this.terms("three freezy trees")));
            this.testUnchanged(this.near(5, this.join(this.term("three"), this.or(this.terms("freezy breezy")), this.term("trees"))));
            this.testQuery(this.near(5, this.terms("man of war")), "\"(man^0 OR man~of) (of~war OR war^0)\"~5");
            this.testQuery(this.near(5, this.terms("when it is a problem")), "(\"when~it it~is is~a a~problem\"~5 OR \"(when^0 OR when~it) (a~problem OR problem^0)\"~5^0)");
            this.testQuery(this.near(5, this.terms("it is a problem")), "(\"it~is is~a a~problem\"~5 OR (a~problem OR problem^0)^0)");
            this.testQuery(this.near(5, this.terms("when it is a")), "(\"when~it it~is is~a\"~5 OR (when^0 OR when~it)^0)");
            this.testQuery(this.near(5, this.join(this.or(this.terms("shake bake")), this.term("it"))), "((shake OR bake)^0 OR (shake~it OR bake~it))");
            this.testQuery(this.near(5, this.join(this.or(this.terms("shake bake")), this.term("it"), this.term("now"))), "\"((shake OR bake)^0 OR (shake~it OR bake~it)) (it~now OR now^0)\"~5");
            this.testQuery(this.near(5, this.join(this.term("jeff"), this.or(this.terms("shakes bakes")), this.term("it"))), "\"jeff ((shakes OR bakes)^0 OR (shakes~it OR bakes~it))\"~5");
            this.testQuery(this.boost(2.0f, this.near(5, this.join(this.boost(3.0f, this.or(this.join(this.boost(4.0f, this.term("shake")), this.boost(5.0f, this.term("bake"))))), this.boost(6.0f, this.term("it")), this.boost(7.0f, this.term("now"))))), "\"((shake^4 OR bake^5)^2 OR (shake~it^6 OR bake~it^6)^3) (it~now^7 OR now^5)\"~5^2");
            this.testQuery(this.boost(7.0f, this.near(5, this.join(this.boost(6.0f, this.or(this.join(this.boost(5.0f, this.term("shake")), this.boost(4.0f, this.term("bake"))))), this.boost(3.0f, this.term("it")), this.boost(2.0f, this.term("now"))))), "\"((shake^5 OR bake^4)^4 OR (shake~it^5 OR bake~it^4)^6) (it~now^3 OR now^1)\"~5^7");
            this.testUnchanged(this.or(this.join(this.term("foo"), this.and(this.terms("bar gaz")))));
            this.testQuery(this.or(this.join(this.term("arf"), this.and(this.terms("the dog")), this.term("said"))), "(arf OR (the~dog OR dog^0) OR said)");
            this.testQuery(this.or(this.join(this.term("the"), this.and(this.terms("very nice")), this.term("rabbit"))), "(\"very nice\"~20 OR rabbit)");
            this.testQuery(this.boost(5.0f, this.or(this.join(this.boost(2.0f, this.term("the")), this.boost(3.0f, this.term("happy")), this.boost(4.0f, this.term("couple"))))), "(happy^3 OR couple^4)^5");
            this.testQuery(this.boost(5.0f, this.or(this.join(this.boost(2.0f, this.term("the")), this.boost(3.0f, this.term("happy")), this.boost(4.0f, this.term("it"))))), "happy^15");
            this.testUnchanged(this.not(5, this.term("hello"), this.term("there")));
            this.testQuery(this.not(5, this.and(this.terms("the cow")), this.and(this.terms("the dog"))), "((the~cow OR cow^0) NOT (the~dog OR dog^0))~5");
            this.testQuery(this.and(this.join(this.term("like"), this.term("a"), this.not(5, this.term("cow"), this.term("dog")))), "\"(like^0 OR like~a) ((a~cow NOT dog)~5 OR (cow NOT dog)~5^0)\"~20");
            this.testQuery(this.and(this.join(this.term("the"), this.not(0, this.term("hat"), this.or(this.terms("hat~p hat~c"))), this.term("trick"))), "\"((the~hat NOT (hat~p OR hat~c))~0 OR (hat NOT (hat~p OR hat~c))~0^0) trick\"~20");
            this.testQuery(this.and(this.join(this.term("hank"), this.not(0, this.term("hat"), this.or(this.terms("hat~p hat~c"))), this.term("is"))), "\"hank ((hat NOT (hat~p OR hat~c))~0^0 OR (hat~is NOT (hat~p OR hat~c))~0)\"~20");
            this.testUnchanged(this.bool(this.regTerm("hello"), BooleanClause.Occur.MUST, this.regTerm("kitty"), BooleanClause.Occur.MUST_NOT, this.regTerm("pencil"), BooleanClause.Occur.MUST));
            this.testQuery(this.bool(this.regTerm("cats"), BooleanClause.Occur.MUST, this.regTerm("and"), BooleanClause.Occur.MUST_NOT, this.regTerm("hats"), BooleanClause.Occur.MUST), "(+cats +hats)");
            this.testQuery(this.bool(this.regTerm("cats"), BooleanClause.Occur.MUST, this.regTerm("and"), BooleanClause.Occur.SHOULD, this.regTerm("hats"), BooleanClause.Occur.MUST), "(+cats +hats)");
            this.testQuery(this.bool(this.regTerm("is"), BooleanClause.Occur.MUST, this.regTerm("it"), BooleanClause.Occur.MUST, this.regTerm("fun"), BooleanClause.Occur.SHOULD), "(fun)");
            this.testQuery(this.bool(this.regTerm("whip"), BooleanClause.Occur.MUST, this.or(this.terms("it them")), BooleanClause.Occur.MUST, this.regTerm("good"), BooleanClause.Occur.MUST), "(+whip +them +good)");
            this.testQuery(this.boost(2.0f, this.bool(this.boost(3.0f, this.regTerm("it")), BooleanClause.Occur.SHOULD, this.boost(4.0f, this.regTerm("and")), BooleanClause.Occur.SHOULD, this.boost(5.0f, this.regTerm("harry")), BooleanClause.Occur.MUST)), "harry^10");
        }
    };

    public XtfBigramQueryRewriter(Set stopSet, int maxSlop, Set tokFields) {
        super(stopSet, maxSlop);
        this.tokenizedFields = tokFields;
    }

    public Query rewriteQuery(Query q) {
        if (q instanceof SpanQuery && !this.tokenizedFields.contains(((SpanQuery)q).getField())) {
            return q;
        }
        if (q instanceof SpanSectionTypeQuery) {
            return this.rewrite((SpanSectionTypeQuery)q);
        }
        if (q instanceof SpanExactQuery) {
            return this.rewrite((SpanExactQuery)q);
        }
        if (q instanceof MoreLikeThisQuery) {
            return this.rewrite((MoreLikeThisQuery)q);
        }
        if (q instanceof NumericRangeQuery) {
            return this.rewrite((NumericRangeQuery)q);
        }
        return super.rewriteQuery(q);
    }

    protected Query rewrite(SpanSectionTypeQuery stq) {
        SpanQuery textQuery = (SpanQuery)this.rewriteQuery(stq.getTextQuery());
        SpanQuery secTypeQuery = (SpanQuery)this.rewriteQuery(stq.getSectionTypeQuery());
        if (textQuery == stq.getTextQuery() && secTypeQuery == stq.getSectionTypeQuery()) {
            return stq;
        }
        SpanSectionTypeQuery newq = new SpanSectionTypeQuery(textQuery, secTypeQuery);
        this.copyBoost(stq, newq);
        return newq;
    }

    protected Query rewrite(SpanExactQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, true, 0, new QueryRewriter.SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanExactQuery(clauses);
            }
        });
    }

    protected Query rewrite(MoreLikeThisQuery mlt) {
        Query rewrittenSub = this.rewriteQuery(mlt.getSubQuery());
        if (rewrittenSub == mlt.getSubQuery() && !this.forceRewrite(mlt)) {
            return mlt;
        }
        return this.copyBoost(mlt, new MoreLikeThisQuery(rewrittenSub));
    }

    protected Query rewrite(NumericRangeQuery nrq) {
        if (!this.forceRewrite(nrq)) {
            return nrq;
        }
        return (NumericRangeQuery)nrq.clone();
    }
}

