/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRewriter;
import org.apache.lucene.search.spans.SpanQuery;
import org.cdlib.xtf.textEngine.MoreLikeThisQuery;
import org.cdlib.xtf.textEngine.NumericRangeQuery;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpanSectionTypeQuery;

public abstract class XtfQueryRewriter
extends QueryRewriter {
    public Query rewriteQuery(Query q) {
        if (q instanceof SpanSectionTypeQuery) {
            return this.rewrite((SpanSectionTypeQuery)q);
        }
        if (q instanceof SpanExactQuery) {
            return this.rewrite((SpanExactQuery)q);
        }
        if (q instanceof MoreLikeThisQuery) {
            return this.rewrite((MoreLikeThisQuery)q);
        }
        if (q instanceof NumericRangeQuery) {
            return this.rewrite((NumericRangeQuery)q);
        }
        return super.rewriteQuery(q);
    }

    protected Query rewrite(SpanSectionTypeQuery stq) {
        SpanQuery textQuery = (SpanQuery)this.rewriteQuery(stq.getTextQuery());
        SpanQuery secTypeQuery = (SpanQuery)this.rewriteQuery(stq.getSectionTypeQuery());
        if (textQuery == stq.getTextQuery() && secTypeQuery == stq.getSectionTypeQuery() && !this.forceRewrite(stq)) {
            return stq;
        }
        SpanSectionTypeQuery newq = new SpanSectionTypeQuery(textQuery, secTypeQuery);
        this.copyBoost(stq, newq);
        return newq;
    }

    protected Query rewrite(SpanExactQuery q) {
        return this.rewriteClauses(q, q.getClauses(), false, new QueryRewriter.SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanExactQuery(clauses);
            }
        });
    }

    protected Query rewrite(MoreLikeThisQuery mlt) {
        Query rewrittenSub = this.rewriteQuery(mlt.getSubQuery());
        if (rewrittenSub == mlt.getSubQuery() && !this.forceRewrite(mlt)) {
            return mlt;
        }
        MoreLikeThisQuery ret = (MoreLikeThisQuery)mlt.clone();
        ret.setSubQuery(rewrittenSub);
        return ret;
    }

    protected Query rewrite(NumericRangeQuery nrq) {
        if (!this.forceRewrite(nrq)) {
            return nrq;
        }
        return (NumericRangeQuery)nrq.clone();
    }
}

