/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryTraverser;
import org.apache.lucene.search.spans.SpanQuery;
import org.cdlib.xtf.textEngine.MoreLikeThisQuery;
import org.cdlib.xtf.textEngine.NumericRangeQuery;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpanSectionTypeQuery;

public abstract class XtfQueryTraverser
extends QueryTraverser {
    public void traverseQuery(Query q) {
        if (q instanceof SpanSectionTypeQuery) {
            this.traverse((SpanSectionTypeQuery)q);
        } else if (q instanceof SpanExactQuery) {
            this.traverse((SpanExactQuery)q);
        } else if (q instanceof MoreLikeThisQuery) {
            this.traverse((MoreLikeThisQuery)q);
        } else if (q instanceof NumericRangeQuery) {
            this.traverse((NumericRangeQuery)q);
        } else {
            super.traverseQuery(q);
        }
    }

    protected void traverse(SpanSectionTypeQuery stq) {
        this.traverseQuery(stq.getTextQuery());
        this.traverseQuery(stq.getSectionTypeQuery());
    }

    protected void traverse(SpanExactQuery eq) {
        SpanQuery[] clauses = eq.getClauses();
        for (int i = 0; i < clauses.length; ++i) {
            this.traverseQuery(clauses[i]);
        }
    }

    protected void traverse(MoreLikeThisQuery mlt) {
        this.traverseQuery(mlt.getSubQuery());
    }

    protected void traverse(NumericRangeQuery nrq) {
    }
}

