/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import org.apache.lucene.spelt.WordEquiv;
import org.cdlib.xtf.textEngine.StdTermFilter;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.FastStringCache;
import org.cdlib.xtf.util.WordMap;

public class XtfWordEquiv
implements WordEquiv {
    private CharMap accentMap;
    private WordMap pluralMap;
    private StdTermFilter stdTermFilter = new StdTermFilter();
    private FastStringCache recent = new FastStringCache(1000);

    public XtfWordEquiv(CharMap accentMap, WordMap pluralMap) {
        this.accentMap = accentMap;
        this.pluralMap = pluralMap;
    }

    public boolean isEquivalent(String word1, String word2) {
        word1 = this.filter(word1);
        word2 = this.filter(word2);
        return word1.equals(word2);
    }

    private String filter(String in) {
        String out = (String)this.recent.get(in);
        if (out == null) {
            String tmp;
            out = this.stdTermFilter.filter(in);
            if (this.accentMap != null && (tmp = this.accentMap.mapWord(out)) != null) {
                out = tmp;
            }
            tmp = this.pluralMap.lookup(out);
            if (this.pluralMap != null) {
                if (tmp != null) {
                    out = tmp;
                }
                this.recent.put(in, out);
            }
        }
        return out;
    }
}

