/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.cdlib.xtf.util.IntMultiMap;
import org.cdlib.xtf.util.TagArray;
import org.cdlib.xtf.util.Trace;

public class FRBRData {
    private static WeakHashMap cache = new WeakHashMap();
    public static final int FIRST_TYPE = 1;
    public static final int TYPE_TITLE = 1;
    public static final int TYPE_AUTHOR = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_ID = 4;
    public static final int LAST_TYPE = 4;
    public final TagArray tags;
    public final IntMultiMap docTags;
    public final IntMultiMap tagDocs;

    public static FRBRData getCachedTags(IndexReader reader, String[] fields) throws IOException {
        HashMap<String, FRBRData> readerCache = (HashMap<String, FRBRData>)cache.get(reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, FRBRData>();
            cache.put(reader, readerCache);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            buf.append(fields[i] + "|");
        }
        String allFields = buf.toString();
        FRBRData tags = (FRBRData)readerCache.get(allFields);
        if (tags == null) {
            tags = new FRBRData(reader, fields);
            readerCache.put(allFields, tags);
        }
        return tags;
    }

    private FRBRData(IndexReader reader, String[] fields) throws IOException {
        long startTime = System.currentTimeMillis();
        Trace.debug("Loading FRBR data...");
        Trace.tab();
        this.tags = new TagArray();
        int tt = this.tags.findType("title");
        assert (tt == 1);
        tt = this.tags.findType("author");
        assert (tt == 2);
        tt = this.tags.findType("date");
        assert (tt == 3);
        tt = this.tags.findType("id");
        assert (tt == 4);
        int maxDoc = reader.maxDoc();
        this.docTags = new IntMultiMap(maxDoc);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            int type = this.calcType(field);
            Trace.debug("Reading FRBR field " + field + "...");
            long prevTagSize = this.tags.byteSize();
            int nTagsAdded = this.readField(reader, field, type);
            Trace.debug("..." + nTagsAdded + " tags; " + (this.tags.byteSize() - prevTagSize) + " bytes.");
        }
        Trace.debug("Inverting FRBR map...");
        this.tagDocs = new IntMultiMap(this.tags.size());
        for (int doc = 0; doc < maxDoc; ++doc) {
            int link = this.docTags.firstPos(doc);
            while (link >= 0) {
                this.tagDocs.add(this.docTags.getValue(link), doc);
                link = this.docTags.nextPos(link);
            }
        }
        this.docTags.reverseOrder();
        Trace.debug("Done. Size = " + this.tags.byteSize() + " tags, " + this.tagDocs.byteSize() + " map = " + (this.tags.byteSize() + this.tagDocs.byteSize()) + " total.");
        Trace.debug("Time: " + DecimalFormat.getInstance().format((float)(System.currentTimeMillis() - startTime) / 1000.0f) + " sec");
        Trace.untab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readField(IndexReader reader, String field, int type) throws IOException {
        TermPositions termPositions = reader.termPositions();
        TermEnum termEnum = reader.terms(new Term(field, ""));
        try {
            Term term;
            if (termEnum.term() == null) {
                throw new IOException("no terms in field " + field);
            }
            int nTagsAdded = 0;
            while ((term = termEnum.term()).field().equals(field)) {
                int tag = this.addTag(term.text(), type);
                if (tag >= 0) {
                    ++nTagsAdded;
                    termPositions.seek(termEnum);
                    while (termPositions.next()) {
                        int doc = termPositions.doc();
                        this.docTags.add(doc, tag);
                    }
                }
                if (termEnum.next()) continue;
            }
            int n = nTagsAdded;
            return n;
        }
        finally {
            termPositions.close();
            termEnum.close();
        }
    }

    private int addTag(String term, int type) {
        int start;
        term = term.trim();
        int subType = 0;
        if (term.endsWith("]") && (start = term.lastIndexOf(91)) >= 0) {
            try {
                String sub = term.substring(start + 1, term.length() - 1);
                subType = Integer.parseInt(sub);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            term = term.substring(0, start).trim();
        }
        switch (type) {
            case 1: {
                if (subType == 0) {
                    subType = 245;
                    break;
                }
                if (subType == 245) break;
                return -1;
            }
            case 2: {
                if (subType == 0) {
                    subType = 100;
                    break;
                }
                if (subType == 100 || subType == 700) break;
                return -1;
            }
            case 4: {
                if (subType == 0) {
                    subType = 35;
                } else if (subType != 35 && subType != 900 && subType != 901) {
                    return -1;
                }
                if (term.indexOf(40) >= 6) break;
                return -1;
            }
        }
        return this.tags.add(term, type, subType);
    }

    private int calcType(String field) throws IOException {
        if (field.indexOf("title") >= 0) {
            return 1;
        }
        if (field.indexOf("author") >= 0 || field.indexOf("creator") >= 0) {
            return 2;
        }
        if (field.indexOf("date") >= 0 || field.indexOf("year") >= 0) {
            return 3;
        }
        if (field.indexOf("id") >= 0 || field.indexOf("ID") >= 0) {
            return 4;
        }
        throw new IOException("Unable to identify field type: '" + field + "'");
    }
}

