/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import org.cdlib.xtf.textEngine.facet.GroupSelector;

public class PageSelector
extends GroupSelector {
    private int pageSize = 10;

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void process(int group) {
        int lastPageStart = -1;
        if (this.conservative) {
            this.next.process(group);
            return;
        }
        int parent = this.counts.parent(group);
        int n = 0;
        int kid = this.counts.child(parent);
        while (kid >= 0) {
            if (this.counts.shouldInclude(kid)) {
                if (n % this.pageSize == 0) {
                    lastPageStart = kid;
                }
                if (kid == group) break;
                ++n;
            }
            kid = this.counts.sibling(kid);
        }
        assert (lastPageStart >= 0) : "incorrect tree data";
        n = 0;
        kid = lastPageStart;
        while (kid >= 0) {
            this.next.process(kid);
            if (++n == this.pageSize) break;
            kid = this.counts.sibling(kid);
        }
    }

    public String toString() {
        return "page(" + this.pageSize + ") -> " + this.next.toString();
    }
}

