/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import org.cdlib.xtf.textEngine.facet.GroupCounts;
import org.cdlib.xtf.textEngine.facet.GroupSelector;

public class UnionSelector
extends GroupSelector {
    GroupSelector[] selectors;

    public UnionSelector(GroupSelector[] selectors) {
        this.selectors = selectors;
    }

    public void setCounts(GroupCounts counts) {
        super.setCounts(counts);
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].setCounts(counts);
        }
    }

    public void reset(boolean conservative) {
        super.reset(conservative);
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].reset(conservative);
        }
    }

    public void process(int group) {
        assert (group == 0) : "UnionSelector should only be top-level";
        for (int i = 0; i < this.selectors.length; ++i) {
            this.selectors[i].process(group);
            this.selectors[i].flush();
        }
    }

    public void flush() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("union(");
        for (int i = 0; i < this.selectors.length; ++i) {
            buf.append(this.selectors[i].toString());
            if (i >= this.selectors.length - 1) continue;
            buf.append("|");
        }
        buf.append(")");
        return buf.toString();
    }
}

