/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.cdlib.xtf.util.CharMap;

public class AccentFoldingFilter
extends TokenFilter {
    private CharMap accentMap;

    public AccentFoldingFilter(TokenStream input, CharMap accentMap) {
        super(input);
        this.accentMap = accentMap;
    }

    public Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return t;
        }
        String term = t.termText();
        String mapped = this.accentMap.mapWord(term);
        if (mapped == null) {
            return t;
        }
        Token newToken = new Token(mapped, t.startOffset(), t.endOffset(), t.type());
        newToken.setPositionIncrement(t.getPositionIncrement());
        return newToken;
    }
}

