/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.TraceWriter;
import org.w3c.tidy.Tidy;

public class HTMLToString {
    static Tidy tidy = new Tidy();
    static final String[] htmlCodes = new String[]{"lt", "lt", "gt", "gt", "amp", "amp", "apos", "apos", "quot", "quot", "nbsp", "160", "iexcl", "161", "cent", "162", "cent", "162", "pound", "163", "curren", "164", "yen", "165", "brvbar", "166", "sect", "167", "uml", "168", "copy", "169", "ordf", "170", "laquo", "171", "not", "172", "shy", "173", "reg", "174", "macr", "175", "deg", "176", "plusmn", "177", "sup2", "178", "sup3", "179", "acute", "180", "micro", "181", "para", "182", "middot", "183", "cedil", "184", "sup1", "185", "ordm", "186", "raquo", "187", "frac14", "188", "frac12", "189", "frac34", "190", "iquest", "191", "Agrave", "192", "Aacute", "193", "Acirc", "194", "Atilde", "195", "Auml", "196", "Aring", "197", "AElig", "198", "Ccedil", "199", "Egrave", "200", "Eacute", "201", "Ecirc", "202", "Euml", "203", "Igrave", "204", "Iacute", "205", "Icirc", "206", "Iuml", "207", "ETH", "208", "Ntilde", "209", "Ograve", "210", "Oacute", "211", "Ocirc", "212", "Otilde", "213", "Ouml", "214", "times", "215", "Oslash", "216", "Ugrave", "217", "Uacute", "218", "Ucirc", "219", "Uuml", "220", "Yacute", "221", "THORN", "222", "szlig", "223", "szlig", "223", "agrave", "224", "aacute", "225", "acirc", "226", "atilde", "227", "auml", "228", "aring", "229", "aelig", "230", "ccedil", "231", "egrave", "232", "eacute", "233", "ecirc", "234", "euml", "235", "igrave", "236", "iacute", "237", "icirc", "238", "iuml", "239", "eth", "240", "ntilde", "241", "ograve", "242", "oacute", "243", "ocirc", "244", "otilde", "245", "ouml", "246", "divide", "247", "oslash", "248", "ugrave", "249", "uacute", "250", "ucirc", "251", "uuml", "252", "yacute", "253", "thorn", "254", "yuml", "255", "OElig", "338", "oelig", "339", "Scaron", "352", "scaron", "353", "Yuml", "376", "fnof", "402", "circ", "710", "tilde", "732", "Alpha", "913", "Beta", "914", "Gamma", "915", "Delta", "916", "Epsilon", "917", "Zeta", "918", "Eta", "919", "Theta", "920", "Iota", "921", "Kappa", "922", "Lambda", "923", "Mu", "924", "Nu", "925", "Xi", "926", "Omicron", "927", "Pi", "928", "Rho", "929", "Sigma", "931", "Tau", "932", "Upsilon", "933", "Phi", "934", "Chi", "935", "Psi", "936", "Omega", "937", "alpha", "945", "beta", "946", "gamma", "947", "delta", "948", "epsilon", "949", "zeta", "950", "eta", "951", "theta", "952", "iota", "953", "kappa", "954", "lambda", "955", "mu", "956", "nu", "957", "xi", "958", "omicron", "959", "pi", "960", "rho", "961", "sigmaf", "962", "sigma", "963", "tau", "964", "upsilon", "965", "phi", "966", "chi", "967", "psi", "968", "omega", "969", "thetasym", "977", "upsih", "978", "piv", "982", "ensp", "8194", "emsp", "8195", "thinsp", "8201", "zwnj", "8204", "zwj", "8205", "lrm", "8206", "rlm", "8207", "ndash", "8211", "mdash", "8212", "lsquo", "8216", "rsquo", "8217", "sbquo", "8218", "ldquo", "8220", "rdquo", "8221", "bdquo", "8222", "dagger", "8224", "Dagger", "8225", "bull", "8226", "hellip", "8230", "permil", "8240", "prime", "8242", "Prime", "8243", "lsaquo", "8249", "rsaquo", "8250", "oline", "8254", "frasl", "8260", "euro", "8364", "image", "8465", "weierp", "8472", "real", "8476", "trade", "8482", "alefsym", "8501", "larr", "8592", "uarr", "8593", "rarr", "8594", "darr", "8595", "harr", "8596", "crarr", "8629", "lArr", "8656", "uArr", "8657", "rArr", "8658", "dArr", "8659", "hArr", "8660", "forall", "8704", "part", "8706", "exist", "8707", "empty", "8709", "nabla", "8711", "isin", "8712", "notin", "8713", "ni", "8715", "prod", "8719", "sum", "8721", "minus", "8722", "lowast", "8727", "radic", "8730", "prop", "8733", "infin", "8734", "ang", "8736", "and", "8743", "or", "8744", "cap", "8745", "cup", "8746", "int", "8747", "there4", "8756", "sim", "8764", "cong", "8773", "asymp", "8776", "ne", "8800", "equiv", "8801", "le", "8804", "ge", "8805", "sub", "8834", "sup", "8835", "nsub", "8836", "sube", "8838", "supe", "8839", "oplus", "8853", "otimes", "8855", "perp", "8869", "sdot", "8901", "lceil", "8968", "rceil", "8969", "lfloor", "8970", "rfloor", "8971", "lang", "9001", "rang", "9002", "loz", "9674", "spades", "9824", "clubs", "9827", "hearts", "9829", "diams", "9830"};
    private static HashMap htmlCodeMap = new HashMap();

    public static String convert(InputStream htmlInputStream) {
        if (Trace.getOutputLevel() == 8) {
            tidy.setErrout(new PrintWriter(new TraceWriter(8)));
            tidy.setQuiet(false);
            tidy.setShowWarnings(true);
        } else {
            tidy.setQuiet(true);
            tidy.setShowWarnings(false);
        }
        tidy.setXmlOut(true);
        tidy.setQuoteNbsp(true);
        tidy.setForceOutput(true);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            tidy.parse(htmlInputStream, (OutputStream)out);
            String retStr = out.toString();
            int docStartIdx = retStr.indexOf("<!DOCTYPE");
            if (docStartIdx != -1) {
                int docEndIdx = retStr.indexOf(">", docStartIdx);
                String docTypeStr = retStr.substring(docStartIdx, docEndIdx - docStartIdx + 1);
                retStr = retStr.replaceAll(docTypeStr, "");
            }
            retStr = HTMLToString.replaceHtmlCodes(retStr);
            return retStr;
        }
        catch (Throwable t) {
            Trace.error("*** HTMLToXML.convert() Exception: " + t.getClass());
            Trace.error("                     With message: " + t.getMessage());
            return null;
        }
    }

    public static String replaceHtmlCodes(String in) {
        StringBuffer out = new StringBuffer(in.length() * 3 / 2);
        char[] inChars = in.toCharArray();
        int i = 0;
        while (i < inChars.length) {
            int start;
            int end;
            if (inChars[i] != '&') {
                out.append(inChars[i++]);
                continue;
            }
            for (end = start = i + 1; end < inChars.length && (inChars[end] == '#' || Character.isLetterOrDigit(inChars[end])); ++end) {
            }
            if (end == inChars.length || inChars[end] != ';') {
                out.append(inChars[i++]);
                continue;
            }
            if (inChars[start] == '#') {
                try {
                    int codeNum = Integer.parseInt(in.substring(start + 1, end));
                    if (codeNum >= 128 && codeNum <= 159) {
                        out.append("&#");
                        int outNum = 0;
                        switch (codeNum) {
                            case 128: {
                                outNum = 8364;
                                break;
                            }
                            case 129: {
                                outNum = 129;
                                break;
                            }
                            case 130: {
                                outNum = 8218;
                                break;
                            }
                            case 131: {
                                outNum = 402;
                                break;
                            }
                            case 132: {
                                outNum = 8222;
                                break;
                            }
                            case 133: {
                                outNum = 8230;
                                break;
                            }
                            case 134: {
                                outNum = 8224;
                                break;
                            }
                            case 135: {
                                outNum = 8225;
                                break;
                            }
                            case 136: {
                                outNum = 710;
                                break;
                            }
                            case 137: {
                                outNum = 8240;
                                break;
                            }
                            case 138: {
                                outNum = 352;
                                break;
                            }
                            case 139: {
                                outNum = 8249;
                                break;
                            }
                            case 140: {
                                outNum = 338;
                                break;
                            }
                            case 141: {
                                outNum = 141;
                                break;
                            }
                            case 142: {
                                outNum = 381;
                                break;
                            }
                            case 143: {
                                outNum = 143;
                                break;
                            }
                            case 144: {
                                outNum = 144;
                                break;
                            }
                            case 145: {
                                outNum = 8216;
                                break;
                            }
                            case 146: {
                                outNum = 8217;
                                break;
                            }
                            case 147: {
                                outNum = 8220;
                                break;
                            }
                            case 148: {
                                outNum = 8221;
                                break;
                            }
                            case 149: {
                                outNum = 8226;
                                break;
                            }
                            case 150: {
                                outNum = 8211;
                                break;
                            }
                            case 151: {
                                outNum = 8212;
                                break;
                            }
                            case 152: {
                                outNum = 732;
                                break;
                            }
                            case 153: {
                                outNum = 8482;
                                break;
                            }
                            case 154: {
                                outNum = 353;
                                break;
                            }
                            case 155: {
                                outNum = 8250;
                                break;
                            }
                            case 156: {
                                outNum = 339;
                                break;
                            }
                            case 157: {
                                outNum = 157;
                                break;
                            }
                            case 158: {
                                outNum = 382;
                                break;
                            }
                            case 159: {
                                outNum = 376;
                            }
                        }
                        out.append(Integer.toString(outNum) + ";");
                        i = end + 1;
                        continue;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                out.append(inChars[i++]);
                continue;
            }
            String code = in.substring(start, end);
            String mapTo = (String)htmlCodeMap.get(code);
            if (mapTo == null) {
                i = end + 1;
                continue;
            }
            if (code.equals(mapTo)) {
                out.append(inChars[i++]);
                continue;
            }
            out.append("&#");
            out.append(mapTo);
            out.append(";");
            i = end + 1;
        }
        return out.toString();
    }

    static {
        for (int i = 0; i < htmlCodes.length; i += 2) {
            htmlCodeMap.put(htmlCodes[i], htmlCodes[i + 1]);
        }
    }
}

