/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IdxTreeCleaner {
    public void processDir(File dir) throws Exception {
        if (dir.isDirectory()) {
            if (IndexReader.indexExists(dir)) {
                this.cleanIndex(dir);
            } else {
                String[] files = dir.list();
                for (int i = 0; i < files.length; ++i) {
                    this.processDir(new File(dir, files[i]));
                }
            }
            return;
        }
    }

    public void cleanIndex(File idxDirToClean) throws Exception {
        IndexReader indexReader;
        Trace.info("Index: [" + Path.normalizePath(idxDirToClean.toString()) + "] ");
        try {
            indexReader = IndexReader.open(idxDirToClean);
        }
        catch (Throwable t) {
            Trace.warning("*** Warning: Unable to Open Index [" + idxDirToClean + "] for Cleaning.");
            return;
        }
        int chunkCount = indexReader.numDocs();
        int lastChunk = chunkCount - 1;
        int cleanCount = 0;
        while (lastChunk > 0) {
            if (indexReader.isDeleted(lastChunk)) {
                --lastChunk;
                continue;
            }
            Document chunk = indexReader.document(lastChunk);
            if (chunk.get("docInfo") != null) break;
            try {
                indexReader.deleteDocument(lastChunk);
            }
            catch (Exception e) {
                Trace.tab();
                Trace.error("*** Exception Purging Incomplete Document: " + e.getMessage());
                Trace.untab();
                indexReader.close();
                throw e;
            }
            catch (Throwable t) {
                Trace.tab();
                Trace.error("*** Exception Purging Incomplete Document: " + t.getMessage());
                Trace.untab();
                indexReader.close();
                throw new RuntimeException(t);
            }
            ++cleanCount;
            --lastChunk;
        }
        indexReader.close();
        if (chunkCount == cleanCount) {
            File[] contents;
            int deleteFailCount = 0;
            File[] fileList = idxDirToClean.listFiles();
            for (int j = 0; j < fileList.length; ++j) {
                try {
                    fileList[j].delete();
                    continue;
                }
                catch (Throwable t) {
                    Trace.tab();
                    Trace.warning("*** Warning: Unable to Delete [ " + fileList[j].toString() + " ].");
                    Trace.untab();
                    ++deleteFailCount;
                }
            }
            if (deleteFailCount > 0) {
                if (deleteFailCount > 1) {
                    Trace.info("Empty Index not deleted because " + deleteFailCount + " files could not " + "be removed from index directory.");
                } else {
                    Trace.info("Empty Index not deleted because a file could not be removed from index directory.");
                }
                return;
            }
            File dir = idxDirToClean;
            while ((contents = dir.listFiles()).length == 0) {
                File parentDir = dir.getParentFile();
                try {
                    dir.delete();
                }
                catch (Throwable t) {
                    Trace.tab();
                    Trace.warning("*** Warning: Unable to delete empty index directory [" + dir.getAbsolutePath() + "].");
                    Trace.untab();
                    return;
                }
                dir = parentDir;
            }
        } else if (cleanCount == 1) {
            Trace.info(cleanCount + " Incomplete Document Fragment Purged.");
        } else if (cleanCount > 1) {
            Trace.info(cleanCount + " Incomplete Document Fragments Purged.");
        } else {
            Trace.info("No Incomplete Documents Found.");
        }
        if (chunkCount == cleanCount) {
            Trace.info("Empty Index Deleted.");
        }
    }
}

