/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.TextIndexerException;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IdxTreeCuller {
    public void cullIndex(File xtfHome, IndexInfo idxInfo) throws Exception {
        int docCount = 0;
        int cullCount = 0;
        IndexReader indexReader = null;
        TermEnum termEnum = null;
        try {
            Term term;
            String idxPath = Path.resolveRelOrAbs(xtfHome, idxInfo.indexPath);
            indexReader = IndexReader.open(idxPath);
            termEnum = indexReader.terms(new Term("key", ""));
            while ((term = termEnum.term()) != null && term.field().equals("key")) {
                String key = term.text();
                assert (key.indexOf(58) >= 0) : "Invalid index key - missing ':'";
                String indexName = key.substring(0, key.indexOf(58));
                String relPath = key.substring(key.indexOf(58) + 1);
                if (indexName.equals(idxInfo.indexName) && (idxInfo.subDir == null || relPath.startsWith(idxInfo.subDir))) {
                    ++docCount;
                    String sourceDir = Path.resolveRelOrAbs(xtfHome, idxInfo.sourcePath);
                    String currPath = Path.resolveRelOrAbs(sourceDir, relPath);
                    File currFile = new File(currPath);
                    if (!currFile.exists()) {
                        Trace.tab();
                        Trace.info("[" + relPath + "] ... ");
                        int nDel = indexReader.deleteDocuments(new Term("key", key));
                        if (nDel == 0) {
                            TextIndexerException e = new TextIndexerException("*** Error: Unable to delete chunks from index.");
                            Trace.tab();
                            Trace.error(e.getMessage());
                            Trace.untab();
                            throw e;
                        }
                        File lazyFile = IndexUtil.calcLazyPath(xtfHome, idxInfo, currFile, false);
                        if (lazyFile.canRead() && !Path.deletePath(lazyFile.toString())) {
                            Trace.warning("Could not delete lazy-tree file");
                        }
                        Trace.tab();
                        Trace.debug("Deleted " + nDel + "Chunks.");
                        Trace.untab();
                        ++cullCount;
                        Trace.more(4, "Missing: Removed from Index.");
                        Trace.untab();
                    }
                }
                if (termEnum.next()) continue;
            }
            boolean indexDeleted = false;
            if (docCount == cullCount) {
                boolean anyNotDeleted = false;
                for (int i = 1; i < indexReader.maxDoc(); ++i) {
                    if (indexReader.isDeleted(i)) continue;
                    anyNotDeleted = true;
                    break;
                }
                if (!anyNotDeleted) {
                    this.deleteIndex(new File(Path.resolveRelOrAbs(xtfHome, idxInfo.indexPath)));
                    indexDeleted = true;
                }
            }
            termEnum.close();
            termEnum = null;
            indexReader.close();
            indexReader = null;
            if (cullCount == 1) {
                Trace.info(cullCount + " Missing Document Removed.");
            } else if (cullCount > 1) {
                Trace.info(cullCount + " Missing Documents Removed.");
            } else {
                Trace.info("No Missing Documents to Remove.");
            }
            if (indexDeleted) {
                Trace.info("Empty Index Deleted.");
            }
        }
        catch (Exception e) {
            if (termEnum != null) {
                try {
                    termEnum.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            Trace.info("*** Exception encountered removing missing documents: " + e.getClass() + "\n" + "    With message: " + e.getMessage());
            Trace.error("Skipped Due to Errors.");
            throw e;
        }
    }

    private void deleteIndex(File idxDirToCull) throws IOException {
        File[] contents;
        int deleteFailCount = 0;
        File[] fileList = idxDirToCull.listFiles();
        for (int j = 0; j < fileList.length; ++j) {
            try {
                fileList[j].delete();
                continue;
            }
            catch (Throwable t) {
                Trace.tab();
                Trace.warning("*** Warning: Unable to Delete [ " + Path.normalizeFileName(fileList[j].toString()) + " ].");
                Trace.untab();
                ++deleteFailCount;
            }
        }
        if (deleteFailCount > 0) {
            if (deleteFailCount > 1) {
                Trace.info("Empty Index not deleted because " + deleteFailCount + " files could not " + "be removed from index directory.");
            } else {
                Trace.info("Empty Index not deleted because a file could not be removed from index directory.");
            }
            return;
        }
        File dir = idxDirToCull;
        while ((contents = dir.listFiles()).length == 0) {
            File parentDir = dir.getParentFile();
            try {
                dir.delete();
            }
            catch (Throwable t) {
                Trace.tab();
                Trace.info("*** Warning: Unable to delete empty index directory [" + dir.toString() + "].");
                Trace.untab();
                return;
            }
            dir = parentDir;
        }
    }
}

