/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IndexDump {
    public static void main(String[] args) {
        try {
            IndexerConfig cfgInfo = new IndexerConfig();
            XMLConfigParser cfgParser = new XMLConfigParser();
            int startArg = 0;
            boolean showUsage = false;
            boolean termFreqMode = false;
            cfgInfo.xtfHomePath = System.getProperty("xtf.home");
            if (cfgInfo.xtfHomePath == null || cfgInfo.xtfHomePath.length() == 0) {
                Trace.error("Error: xtf.home property not found");
                return;
            }
            cfgInfo.xtfHomePath = Path.normalizePath(cfgInfo.xtfHomePath);
            if (!new File(cfgInfo.xtfHomePath).isDirectory()) {
                Trace.error("Error: xtf.home directory \"" + cfgInfo.xtfHomePath + "\" does not exist or cannot be read.");
                return;
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            while (true) {
                if (args.length < 4) {
                    showUsage = true;
                } else {
                    int ret = cfgInfo.readCmdLine(args, startArg);
                    if (ret == -1) {
                        if (startArg != 0) break;
                        showUsage = true;
                    } else {
                        if (!new File(cfgInfo.cfgFilePath).isAbsolute()) {
                            cfgInfo.cfgFilePath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.cfgFilePath);
                        }
                        if (cfgParser.configure(cfgInfo) < 0) {
                            Trace.error("Error: index '" + cfgInfo.indexInfo.indexName + "' not found\n");
                            return;
                        }
                    }
                    startArg = ret;
                }
                if (startArg < args.length && args[startArg].equalsIgnoreCase("-termFreq")) {
                    ++startArg;
                    termFreqMode = true;
                }
                Vector<String> fieldNames = new Vector<String>();
                while (startArg < args.length && args[startArg].equals("-field")) {
                    if (++startArg == args.length || args[startArg].startsWith("-")) {
                        showUsage = true;
                        continue;
                    }
                    if (args[startArg].equals("text") && !termFreqMode) {
                        Trace.error("Error: contents of the 'text' field cannot be dumped");
                        System.exit(1);
                    }
                    fieldNames.add(args[startArg]);
                    ++startArg;
                }
                if (fieldNames.isEmpty()) {
                    showUsage = true;
                }
                String[] fieldNameArray = fieldNames.toArray(new String[fieldNames.size()]);
                if (showUsage) {
                    Trace.error("  usage: ");
                    Trace.tab();
                    Trace.error("indexDump {-config <configfile>} -index <indexname> {-termFreq} -field fieldName1 {-field fieldName2}*... \n\n");
                    Trace.untab();
                    System.exit(1);
                }
                IndexInfo idxInfo = cfgInfo.indexInfo;
                String idxPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, idxInfo.indexPath);
                XtfSearcher searcher = new XtfSearcher(idxPath, 30);
                IndexReader indexReader = searcher.indexReader();
                DocNumMap docNumMap = searcher.docNumMap();
                if (termFreqMode) {
                    IndexDump.dumpTermFreqs(indexReader, docNumMap, fieldNameArray, out);
                } else {
                    IndexDump.dumpFields(indexReader, fieldNameArray, out);
                }
                indexReader.close();
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            Trace.error("*** Last Chance Exception: " + e.getClass());
            Trace.error("             With message: " + e.getMessage());
            Trace.error("");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable t) {
            Trace.error("*** Last Chance Exception: " + t.getClass());
            Trace.error("             With message: " + t);
            Trace.error("");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void dumpFields(IndexReader indexReader, String[] fieldNames, Writer out) throws IOException {
        int maxDoc = indexReader.maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            int j;
            if (indexReader.isDeleted(i)) continue;
            Document doc = indexReader.document(i);
            Vector<String> toPrint = new Vector<String>();
            boolean gotAny = false;
            for (j = 0; j < fieldNames.length; ++j) {
                Field[] got = doc.getFields(fieldNames[j]);
                if (got == null || got.length == 0) {
                    toPrint.add("");
                    continue;
                }
                StringBuffer buf = new StringBuffer();
                for (int k = 0; k < got.length; ++k) {
                    if (k > 0) {
                        buf.append(";");
                    }
                    buf.append(IndexDump.stripValue(got[k].stringValue()));
                }
                toPrint.add(buf.toString());
                gotAny = true;
            }
            if (!gotAny) continue;
            for (j = 0; j < toPrint.size(); ++j) {
                out.write((String)toPrint.get(j));
                out.write("|");
            }
            out.write("\n");
        }
    }

    private static void dumpTermFreqs(IndexReader indexReader, DocNumMap docNumMap, String[] fields, Writer out) throws IOException {
        TermDocs docs = indexReader.termDocs();
        for (int i = 0; i < fields.length; ++i) {
            Term t;
            TermEnum terms = indexReader.terms(new Term(fields[i], ""));
            while (terms.next() && (t = terms.term()).field().equals(fields[i])) {
                char c;
                String text = t.text();
                if (text.indexOf("~") >= 0 || text.length() == 0 || (c = text.charAt(0)) == '\uebeb' || c == '\ue111' || c == '\ue112' || (c = text.charAt(text.length() - 1)) == '\uee1d' || c == '\ue111' || c == '\ue112') continue;
                int prevMainDoc = -1;
                int docFreq = 0;
                docs.seek(terms);
                int termFreq = 0;
                while (docs.next()) {
                    int mainDoc = docs.doc();
                    if (t.field().equals("text")) {
                        mainDoc = docNumMap.getDocNum(docs.doc());
                    }
                    if (mainDoc != prevMainDoc) {
                        ++docFreq;
                        prevMainDoc = mainDoc;
                    }
                    termFreq += docs.freq();
                }
                out.write(fields[i] + "|" + docFreq + "|" + termFreq + "|" + t.text() + "\n");
            }
        }
    }

    private static String stripValue(String str) {
        char[] in = str.toCharArray();
        char[] out = new char[in.length];
        int outLen = 0;
        block6: for (int i = 0; i < in.length; ++i) {
            switch (in[i]) {
                case '\ue90d': 
                case '\uebeb': 
                case '\uee1d': {
                    continue block6;
                }
                case '\uebbb': {
                    ++i;
                    while (i < in.length && in[i] != '\uebbb') {
                        ++i;
                    }
                    if (i < in.length) {
                        ++i;
                    }
                    out[outLen++] = 59;
                    continue block6;
                }
                case ';': {
                    out[outLen++] = 44;
                    continue block6;
                }
                case '|': {
                    out[outLen++] = 46;
                    continue block6;
                }
                default: {
                    out[outLen++] = in[i];
                }
            }
        }
        return new String(out, 0, outLen);
    }
}

