/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

public class IndexInfo {
    public String indexName;
    public String subDir;
    public String indexPath;
    public String sourcePath;
    public String docSelectorPath;
    public String stopWords;
    public String pluralMapPath;
    public String accentMapPath;
    public boolean createSpellcheckDict = false;
    public boolean stripWhitespace = false;
    public int[] chunkAtt;
    public static final int chunkSize = 0;
    public static final int chunkOvlp = 1;
    public static final int minChunkSize = 2;
    public static final int defaultChunkSize = 100;
    public static final int defaultChunkOvlp = 50;
    public static final String defaultStopWords = "a an and are as at be but by for if in into is it no not of on or s such t that the their then there these they this to was will with";

    public IndexInfo() {
        this.chunkAtt = new int[2];
        this.chunkAtt[0] = 100;
        this.chunkAtt[1] = 50;
    }

    public IndexInfo(String indexName, String indexPath) {
        this.indexName = indexName;
        this.indexPath = indexPath;
        this.chunkAtt = new int[2];
        this.chunkAtt[0] = 100;
        this.chunkAtt[1] = 50;
        this.stopWords = defaultStopWords;
    }

    public int getChunkSize() {
        return this.chunkAtt[0];
    }

    public String getChunkSizeStr() {
        return Integer.toString(this.chunkAtt[0]);
    }

    public int getChunkOvlp() {
        return this.chunkAtt[1];
    }

    public String getChunkOvlpStr() {
        return Integer.toString(this.chunkAtt[1]);
    }

    public int setChunkSize(int newChunkSize) {
        if (newChunkSize < 2) {
            newChunkSize = 2;
        }
        this.chunkAtt[0] = newChunkSize;
        this.chunkAtt[1] = this.setChunkOvlp(this.chunkAtt[1]);
        return this.chunkAtt[0];
    }

    public int setChunkOvlp(int newChunkOverlap) {
        if (newChunkOverlap > this.chunkAtt[0] / 2) {
            newChunkOverlap = this.chunkAtt[0] / 2;
        }
        this.chunkAtt[1] = newChunkOverlap;
        return this.chunkAtt[1];
    }
}

