/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IndexStats {
    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void calcStats(IndexerConfig cfgInfo) throws IOException {
        Term term;
        Term term2;
        IndexInfo idxInfo = cfgInfo.indexInfo;
        DecimalFormat decFmt = (DecimalFormat)DecimalFormat.getInstance();
        decFmt.setMaximumFractionDigits(1);
        String idxPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, idxInfo.indexPath);
        File idxFile = new File(idxPath);
        IndexReader indexReader = IndexReader.open(idxPath);
        long totalDocs = indexReader.docFreq(new Term("docInfo", "1"));
        long totalChunks = indexReader.numDocs();
        Trace.info("Total Documents (Records)  = " + totalDocs);
        Trace.info("Total Chunks               = " + totalChunks);
        if (indexReader.hasDeletions()) {
            Trace.more(4, "  (total includes some deleted documents)");
        }
        Trace.info("Avg Chunks Per Doc/Rec     = " + decFmt.format((double)(totalChunks + 1L) / (double)(totalDocs + 1L)));
        int totalFiles = 0;
        TermEnum termEnum = indexReader.terms(new Term("key", ""));
        while ((term2 = termEnum.term()) != null && term2.field().equals("key")) {
            ++totalFiles;
            if (termEnum.next()) continue;
        }
        Trace.info("Total Number of Src Files  = " + totalFiles);
        Trace.info("Avg Docs/Recs Per File     = " + decFmt.format((double)(totalDocs + 1L) / (double)(totalFiles + 1)));
        long totalLuceneSize = 0L;
        if (idxFile.isDirectory()) {
            String[] children = idxFile.list();
            for (int i = 0; i < children.length; ++i) {
                File child = new File(idxFile, children[i]);
                if (!child.isFile()) continue;
                totalLuceneSize += child.length();
            }
        }
        Trace.info("Size of Lucene Index       = " + IndexStats.printBig(totalLuceneSize));
        termEnum = indexReader.terms(new Term("key", ""));
        File xtfHomeFile = new File(cfgInfo.xtfHomePath);
        long totalSrcSize = 0L;
        long totalLazySize = 0L;
        long filesDone = 0L;
        long prevPercent = 0L;
        while ((term = termEnum.term()) != null && term.field().equals("key")) {
            long percentDone = filesDone * 100L / (long)totalFiles;
            if (filesDone > 500L && percentDone >= prevPercent + 5L) {
                if (prevPercent == 0L) {
                    Trace.info("");
                }
                Trace.more(4, "\r        (Calculating Source/Lazy File Sizes... " + percentDone + "%)");
                prevPercent = percentDone;
            }
            ++filesDone;
            String key = term.text();
            assert (key.indexOf(58) >= 0) : "Invalid index key - missing ':'";
            String indexName = key.substring(0, key.indexOf(58));
            String relPath = key.substring(key.indexOf(58) + 1);
            if (indexName.equals(idxInfo.indexName)) {
                String sourceDir = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, idxInfo.sourcePath);
                String currPath = Path.resolveRelOrAbs(sourceDir, relPath);
                File currFile = new File(currPath);
                totalSrcSize += currFile.length();
                File lazyFile = IndexUtil.calcLazyPath(xtfHomeFile, idxInfo, currFile, false);
                totalLazySize += lazyFile.length();
            }
            if (termEnum.next()) continue;
        }
        if (prevPercent > 0L && prevPercent < 100L) {
            Trace.more(4, "\r        (Calculating Source/Lazy File Sizes... 100%)");
            Trace.info("");
        }
        Trace.info("Size of Source Files       = " + IndexStats.printBig(totalSrcSize));
        Trace.info("Size of Lazy Trees         = " + IndexStats.printBig(totalLazySize));
        Trace.info("Total Index Size           = " + IndexStats.printBig(totalLuceneSize + totalLazySize) + "  (Lucene + Lazy)");
        termEnum.close();
        termEnum = null;
        indexReader.close();
        indexReader = null;
    }

    private static String printBig(long num) {
        float mBytes = (float)num / 1024.0f / 1024.0f;
        mBytes = (float)((int)(mBytes * 100.0f)) / 100.0f;
        return mBytes + " Mb";
    }
}

