/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.util.Trace;

public class IndexerConfig {
    public String xtfHomePath;
    public String cfgFilePath = "conf/textIndexer.conf";
    public int traceLevel = 4;
    public boolean clean = false;
    public boolean mustClean;
    public boolean buildLazyFiles = true;
    public boolean optimize = true;
    public boolean updateSpellDict = true;
    public boolean skipIndexing = false;
    public IndexInfo indexInfo = new IndexInfo();

    public int readCmdLine(String[] args, int startArg) {
        int i;
        if (startArg >= args.length) {
            return -1;
        }
        boolean gotIdxName = false;
        this.indexInfo.subDir = null;
        for (i = startArg; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-config")) {
                if (++i >= args.length) {
                    return -1;
                }
                this.cfgFilePath = args[i];
            } else if (args[i].equalsIgnoreCase("-index")) {
                if (++i >= args.length) {
                    return -1;
                }
                this.indexInfo.indexName = args[i];
                gotIdxName = true;
            } else if (args[i].equalsIgnoreCase("-dir")) {
                if (++i >= args.length) {
                    return -1;
                }
                if (this.indexInfo.subDir != null) {
                    Trace.error("Error: Only one directory may be specified per index");
                    return -1;
                }
                this.indexInfo.subDir = args[i];
            } else if (args[i].equalsIgnoreCase("-clean")) {
                this.clean = true;
            } else if (args[i].equalsIgnoreCase("-incremental")) {
                this.clean = false;
            } else if (args[i].equalsIgnoreCase("-optimize")) {
                this.optimize = true;
            } else if (args[i].equalsIgnoreCase("-nooptimize")) {
                this.optimize = false;
            } else if (args[i].equalsIgnoreCase("-updatespell")) {
                this.updateSpellDict = true;
            } else if (args[i].equalsIgnoreCase("-noupdatespell")) {
                this.updateSpellDict = false;
            } else if (args[i].equalsIgnoreCase("-buildlazy")) {
                this.buildLazyFiles = true;
            } else if (args[i].equalsIgnoreCase("-nobuildlazy")) {
                this.buildLazyFiles = false;
            } else if (args[i].equalsIgnoreCase("-skipindexing")) {
                this.skipIndexing = true;
            } else if (args[i].equalsIgnoreCase("-trace")) {
                if (++i >= args.length) {
                    return -1;
                }
                String traceLevelStr = args[i];
                this.traceLevel = traceLevelStr.equalsIgnoreCase("warnings") ? 2 : (traceLevelStr.equalsIgnoreCase("info") ? 4 : (traceLevelStr.equalsIgnoreCase("debug") ? 8 : 1));
            } else {
                Trace.error("Unrecognized command-line parameter: " + args[i]);
                return -1;
            }
            if (!gotIdxName) continue;
            ++i;
            break;
        }
        if (!gotIdxName) {
            return -1;
        }
        return i;
    }
}

