/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import java.io.InputStream;
import org.cdlib.xtf.textIndexer.XMLIndexSource;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLFormatter;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PDFToString {
    static boolean mustConfigureLogger = true;
    static PDFTextStripper stripper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String convert(InputStream PDFInputStream) throws IOException {
        if (stripper == null) {
            stripper = new PDFTextStripper();
        }
        XMLFormatter formatter = new XMLFormatter();
        try {
            PDDocument pdfDoc = null;
            try {
                pdfDoc = PDDocument.load((InputStream)PDFInputStream);
                if (pdfDoc.isEncrypted()) {
                    Trace.info("*** PDF File is Encrypted. File Skipped.");
                    throw new Exception();
                }
                formatter.procInstr("xml version=\"1.0\" encoding=\"utf-8\"");
                formatter.tabSize(4);
                formatter.blankLineAfterTag(false);
                int pageCount = pdfDoc.getNumberOfPages();
                formatter.beginTag("pdfDocument");
                formatter.attr("pageCount", pageCount);
                for (int i = 1; i <= pageCount; ++i) {
                    formatter.beginTag("pdfPage");
                    formatter.attr("number", i);
                    stripper.setStartPage(i);
                    stripper.setEndPage(i);
                    String pdfText = stripper.getText(pdfDoc);
                    pdfText = XMLIndexSource.normalize(pdfText);
                    formatter.text(pdfText, 128);
                    formatter.newLineAfterText();
                    formatter.endTag();
                }
                formatter.endAllTags();
            }
            catch (Throwable t) {
                Trace.error("*** PDFToXML.convert() Exception: " + t.getClass());
                Trace.error("                    With message: " + t.getMessage());
            }
            finally {
                if (pdfDoc != null) {
                    pdfDoc.close();
                }
            }
        }
        catch (Throwable t) {
            Trace.error("*** PDFToXML.convert() Exception: " + t.getClass());
            Trace.error("                    With message: " + t.getMessage());
        }
        return formatter.toString();
    }
}

