/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.cdlib.xtf.util.WordMap;

public class PluralFoldingFilter
extends TokenFilter {
    private WordMap pluralMap;

    public PluralFoldingFilter(TokenStream input, WordMap pluralMap) {
        super(input);
        this.pluralMap = pluralMap;
    }

    public Token next() throws IOException {
        String mapped;
        Token t = this.input.next();
        if (t == null) {
            return t;
        }
        String term = t.termText();
        boolean isStartTerm = false;
        boolean isEndTerm = false;
        if (term.length() > 0 && term.charAt(0) == '\uebeb') {
            isStartTerm = true;
            term = term.substring(1);
        }
        if (term.length() > 0 && term.charAt(term.length() - 1) == '\uee1d') {
            isEndTerm = true;
            term = term.substring(0, term.length() - 1);
        }
        if ((mapped = this.pluralMap.lookup(term)) == null) {
            return t;
        }
        if (isStartTerm) {
            mapped = '\uebeb' + mapped;
        }
        if (isEndTerm) {
            mapped = mapped + '\uee1d';
        }
        Token newToken = new Token(mapped, t.startOffset(), t.endOffset(), t.type());
        newToken.setPositionIncrement(t.getPositionIncrement());
        return newToken;
    }
}

