/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.util.Stack;
import org.cdlib.xtf.textIndexer.SectionInfo;

public class SectionInfoStack {
    private Stack infoStack = new Stack();

    public void push(int indexFlag, String sectionType, int sectionBump, float wordBoost, int sentenceBump, int spellFlag) {
        int prevSectionBump = 0;
        SectionInfo info = this.top();
        if (info != null) {
            if (indexFlag == -1) {
                indexFlag = info.indexFlag;
            }
            if (spellFlag == -1) {
                spellFlag = info.spellFlag;
            }
            if (sectionType == "") {
                sectionType = info.sectionType;
            }
            if (!this.valuesChanged(indexFlag, sectionType, sectionBump, wordBoost, sentenceBump, spellFlag)) {
                this.push();
                return;
            }
            prevSectionBump = info.saveSectionBump();
        }
        if (indexFlag == -1) {
            indexFlag = 1;
        }
        if (spellFlag == -1) {
            spellFlag = 1;
        }
        this.infoStack.push(new SectionInfo(0, indexFlag, sectionType, prevSectionBump + sectionBump, wordBoost, sentenceBump, spellFlag));
    }

    public void push() {
        if (this.isEmpty()) {
            this.push(new SectionInfo());
            return;
        }
        ++this.top().depth;
    }

    public void pop() {
        if (this.isEmpty()) {
            return;
        }
        boolean restorePrevSectionBump = false;
        if (this.top().sectionBump != 0) {
            restorePrevSectionBump = true;
        }
        if (--this.top().depth == -1) {
            this.infoStack.pop();
        }
        if (this.isEmpty()) {
            return;
        }
        if (restorePrevSectionBump) {
            this.top().restoreSectionBump();
        }
    }

    public SectionInfo peek() {
        return this.top();
    }

    public boolean isEmpty() {
        return this.infoStack.isEmpty();
    }

    public boolean valuesChanged(int indexFlag, String sectionType, int sectionBump, float wordBoost, int sentenceBump, int spellFlag) {
        if (this.isEmpty()) {
            return true;
        }
        SectionInfo info = this.top();
        if (indexFlag == -1) {
            indexFlag = info.indexFlag;
        }
        if (spellFlag == -1) {
            spellFlag = info.spellFlag;
        }
        sectionBump = sectionBump == 0 ? info.sectionBump : -1;
        return indexFlag != info.indexFlag || sectionType != info.sectionType || sectionBump != info.sectionBump || wordBoost != info.wordBoost || sentenceBump != info.sentenceBump || spellFlag != info.spellFlag;
    }

    public int depth() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.top().depth;
    }

    public int indexFlag() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.top().indexFlag;
    }

    public int spellFlag() {
        if (this.isEmpty()) {
            return 1;
        }
        return this.top().spellFlag;
    }

    public String sectionType() {
        if (this.isEmpty()) {
            return "";
        }
        return this.top().sectionType;
    }

    public int sectionBump() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.top().sectionBump;
    }

    public int useSectionBump() {
        if (this.isEmpty()) {
            return 0;
        }
        SectionInfo info = this.top();
        int sectionBump = info.sectionBump;
        info.sectionBump = 0;
        return sectionBump;
    }

    public int setSectionBump(int newBump) {
        if (this.isEmpty()) {
            return 0;
        }
        SectionInfo info = this.top();
        int retBump = info.sectionBump;
        info.sectionBump = newBump;
        return retBump;
    }

    public float wordBoost() {
        if (this.isEmpty()) {
            return 1.0f;
        }
        return this.top().wordBoost;
    }

    public int sentenceBump() {
        if (this.isEmpty()) {
            return 5;
        }
        return this.top().sentenceBump;
    }

    private void push(SectionInfo info) {
        this.infoStack.push(info);
    }

    private SectionInfo top() {
        if (this.isEmpty()) {
            return null;
        }
        return (SectionInfo)this.infoStack.peek();
    }
}

