/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.TreeBuilder;
import org.apache.lucene.util.StringUtil;
import org.cdlib.xtf.cache.Dependency;
import org.cdlib.xtf.cache.FileDependency;
import org.cdlib.xtf.servletBase.StylesheetCache;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.HTMLIndexSource;
import org.cdlib.xtf.textIndexer.IndexSource;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.MARCIndexSource;
import org.cdlib.xtf.textIndexer.MSWordIndexSource;
import org.cdlib.xtf.textIndexer.PDFIndexSource;
import org.cdlib.xtf.textIndexer.StructuredFileProxy;
import org.cdlib.xtf.textIndexer.TextIndexSource;
import org.cdlib.xtf.textIndexer.XMLIndexSource;
import org.cdlib.xtf.textIndexer.XMLTextProcessor;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLWriter;
import org.xml.sax.InputSource;

public class SrcTreeProcessor {
    private IndexerConfig cfgInfo;
    private XMLTextProcessor textProcessor;
    private StylesheetCache stylesheetCache = new StylesheetCache(100, 0, true);
    private Templates docSelector;
    private int nScanned = 0;
    private StringBuffer docBuf = new StringBuffer(1024);
    private StringBuffer dirBuf = new StringBuffer(1024);
    private String docSelPath;
    private String docSelDependencies;
    private File docSelCacheFile;
    private HashMap docSelCache = new HashMap();

    public SrcTreeProcessor() {
        this.textProcessor = new XMLTextProcessor();
    }

    public void open(IndexerConfig cfgInfo) throws Exception {
        this.cfgInfo = cfgInfo;
        if (cfgInfo.xtfHomePath == null) {
            cfgInfo.xtfHomePath = new File(cfgInfo.cfgFilePath).getParentFile().toString();
        }
        this.docSelPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.docSelectorPath);
        this.docSelector = this.stylesheetCache.find(this.docSelPath);
        this.loadCache(cfgInfo);
        this.textProcessor.open(cfgInfo.xtfHomePath, cfgInfo.indexInfo, cfgInfo.clean);
        cfgInfo.clean = false;
        Trace.info("Scanning Data Directories...");
    }

    public void close() throws IOException {
        Trace.more(" Done.");
        this.textProcessor.processQueuedTexts();
        this.saveCache();
        this.cfgInfo = null;
        this.textProcessor.close();
    }

    public void loadCache(IndexerConfig cfgInfo) {
        this.docSelCache.clear();
        String indexPath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath);
        indexPath = Path.normalizePath(indexPath);
        this.docSelCacheFile = new File(indexPath + "docSelect.cache");
        Iterator iter = this.stylesheetCache.getDependencies(this.docSelPath);
        StringBuffer depBuf = new StringBuffer();
        while (iter.hasNext()) {
            Dependency d = (Dependency)iter.next();
            if (!(d instanceof FileDependency)) continue;
            depBuf.append(d.toString());
            depBuf.append("\n");
        }
        this.docSelDependencies = depBuf.toString();
        if (cfgInfo.clean) {
            this.docSelCacheFile.delete();
            return;
        }
        if (!this.docSelCacheFile.canRead()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(this.docSelCacheFile);
            InflaterInputStream iis = new InflaterInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(iis);
            String fileVersion = ois.readUTF();
            if (!fileVersion.equals("docSelectorCache v1.0")) {
                Trace.warning("Warning: Unrecognized docSelector cache \"" + this.docSelCacheFile + "\"");
                this.docSelCache.clear();
                return;
            }
            String fileDep = ois.readUTF();
            if (!fileDep.equals(this.docSelDependencies)) {
                Trace.debug("Note: docSelector stylesheet or sub-sheet  has changed... throwing away old docSelector cache.");
                ois.close();
                fis.close();
                this.docSelCacheFile.delete();
                this.docSelCache.clear();
                return;
            }
            this.docSelCache = (HashMap)ois.readObject();
        }
        catch (IOException e) {
            Trace.warning("Warning: Error loading docSelector cache \"" + this.docSelCacheFile + "\": " + e);
            this.docSelCache.clear();
            return;
        }
        catch (Exception e) {
            Trace.warning("Warning: Corrupt docSelector cache \"" + this.docSelCacheFile + "\"");
            this.docSelCache.clear();
            return;
        }
    }

    public void saveCache() {
        File newFile = new File(this.docSelCacheFile.toString() + ".new");
        FileOutputStream fos = null;
        DeflaterOutputStream dos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(newFile);
            dos = new DeflaterOutputStream(fos);
            oos = new ObjectOutputStream(dos);
            oos.writeUTF("docSelectorCache v1.0");
            oos.writeUTF(this.docSelDependencies);
            oos.writeObject(this.docSelCache);
            oos.close();
            dos.close();
            fos.close();
            this.docSelCacheFile.delete();
            newFile.renameTo(this.docSelCacheFile);
        }
        catch (IOException e) {
            Trace.warning("Warning: Error writing docSelector cache \"" + newFile + "\": " + e);
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            newFile.delete();
            return;
        }
    }

    public void processDir(File currFile, int level) throws Exception {
        boolean runStylesheet;
        String[] fileStrs = currFile.getAbsoluteFile().list();
        if (fileStrs == null) {
            Trace.warning("Warning: error retrieving file list for directory: " + currFile);
            return;
        }
        ArrayList<String> list = new ArrayList<String>(fileStrs.length);
        for (int i = 0; i < fileStrs.length; ++i) {
            list.add(fileStrs[i]);
        }
        Collections.sort(list);
        this.docBuf.setLength(0);
        this.dirBuf.setLength(0);
        String dirPath = Path.normalizePath(currFile.toString());
        this.docBuf.append("<directory dirPath=\"" + StringUtil.escapeHTMLChars(dirPath) + "\">\n");
        int nFiles = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            File subFile = new File(currFile, (String)i.next());
            if (subFile.getAbsoluteFile().isDirectory()) continue;
            this.docBuf.append("  <file fileName=\"");
            this.docBuf.append(StringUtil.escapeHTMLChars(subFile.getName()));
            this.docBuf.append("\"/>\n");
            this.dirBuf.append(StringUtil.escapeHTMLChars(subFile.getName()));
            this.dirBuf.append(':');
            this.dirBuf.append(subFile.lastModified());
            this.dirBuf.append("\n");
            ++nFiles;
            if (this.nScanned++ % 200 != 0) continue;
            Trace.more(4, ".");
        }
        this.docBuf.append("</directory>\n");
        boolean anyProcessed = false;
        String inStr = this.docBuf.toString();
        String filesAndTimes = this.dirBuf.toString();
        String dirKey = level == 0 ? this.cfgInfo.indexInfo.indexName + ":/" : IndexUtil.calcDocKey(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, currFile);
        if (nFiles == 0) {
            runStylesheet = false;
        } else {
            CacheEntry ent = (CacheEntry)this.docSelCache.get(dirKey);
            if (ent == null) {
                runStylesheet = true;
            } else if (!ent.filesAndTimes.equals(filesAndTimes)) {
                this.docSelCache.remove(dirKey);
                runStylesheet = true;
            } else {
                anyProcessed = ent.anyProcessed;
                runStylesheet = false;
            }
        }
        if (runStylesheet) {
            InputSource docSelectorInput = new InputSource(new StringReader(inStr));
            if (Trace.getOutputLevel() >= 8) {
                Trace.debug("*** docSelector input ***\n" + inStr);
                Trace.debug("");
            }
            TreeBuilder tree = new TreeBuilder();
            Transformer docSelectorTrans = this.docSelector.newTransformer();
            docSelectorTrans.transform(new SAXSource(docSelectorInput), tree);
            NodeInfo result = tree.getCurrentRoot();
            if (Trace.getOutputLevel() >= 8) {
                Trace.debug("*** docSelector output ***\n" + XMLWriter.toString(result));
                Trace.debug("");
            }
            EasyNode root = new EasyNode(result);
            for (int i2 = 0; i2 < root.nChildren(); ++i2) {
                EasyNode node = root.child(i2);
                if (!node.isElement()) continue;
                String tagName = node.name();
                if (tagName.equalsIgnoreCase("indexFiles")) {
                    root = node;
                    i2 = -1;
                    continue;
                }
                if (tagName.equalsIgnoreCase("indexFile")) {
                    if (!this.processFile(dirPath, node)) continue;
                    anyProcessed = true;
                    continue;
                }
                Trace.error("Error: docSelector returned unknown element '" + tagName + "'");
                return;
            }
            this.docSelCache.put(dirKey, new CacheEntry(filesAndTimes, anyProcessed));
        }
        if (anyProcessed) {
            return;
        }
        Iterator i3 = list.iterator();
        while (i3.hasNext()) {
            File subFile = new File(currFile, (String)i3.next());
            if (!subFile.getAbsoluteFile().isDirectory()) continue;
            this.processDir(subFile, level + 1);
        }
    }

    public boolean processFile(String dir, EasyNode parentEl) throws Exception {
        File srcPath = null;
        Vector<Templates> preFilterVec = new Vector<Templates>();
        Templates displayStyle = null;
        String fileName = null;
        String format = null;
        boolean removeDoctypeDecl = false;
        for (int i = 0; i < parentEl.nAttrs(); ++i) {
            String attrName = parentEl.attrName(i);
            String attrVal = parentEl.attrValue(i);
            if (attrName.equalsIgnoreCase("fileName")) {
                fileName = attrVal;
                srcPath = new File(Path.normalizeFileName(dir + attrVal));
                if (srcPath.canRead()) continue;
                Trace.error("Error: cannot read input document '" + srcPath + "'");
                return false;
            }
            if (attrName.equalsIgnoreCase("preFilter")) {
                StringTokenizer st = new StringTokenizer(attrVal, ";,");
                while (st.hasMoreTokens()) {
                    String partialPath = st.nextToken();
                    String preFilterPath = Path.resolveRelOrAbs(this.cfgInfo.xtfHomePath, partialPath);
                    preFilterVec.add(this.stylesheetCache.find(preFilterPath));
                }
                continue;
            }
            if (attrName.equalsIgnoreCase("displayStyle")) {
                String displayPath = Path.resolveRelOrAbs(this.cfgInfo.xtfHomePath, attrVal);
                displayStyle = this.stylesheetCache.find(displayPath);
                continue;
            }
            if (attrName.equalsIgnoreCase("type")) {
                format = attrVal;
                if (format.equalsIgnoreCase("XML")) {
                    format = "XML";
                    continue;
                }
                if (format.equalsIgnoreCase("PDF")) {
                    format = "PDF";
                    continue;
                }
                if (format.equalsIgnoreCase("HTML")) {
                    format = "HTML";
                    continue;
                }
                if (format.equalsIgnoreCase("DOC") || format.equalsIgnoreCase("MSWord")) {
                    format = "MSWord";
                    continue;
                }
                if (format.equalsIgnoreCase("Text")) {
                    format = "Text";
                    continue;
                }
                if (format.equalsIgnoreCase("MARC")) {
                    format = "MARC";
                    continue;
                }
                Trace.error("Error: docSelector returned unknown type: '" + format + "'");
                return false;
            }
            if (attrName.equalsIgnoreCase("removeDoctypeDecl")) {
                if (attrVal.matches("^yes$|^true$")) {
                    removeDoctypeDecl = true;
                    continue;
                }
                if (attrVal.matches("^no$|^false$")) {
                    removeDoctypeDecl = false;
                    continue;
                }
                Trace.error("Error: docSelector returned invalid value for " + attrName + " attribute: " + "expected 'true', 'yes', 'false', or 'no', but found '" + attrVal + "'");
                return false;
            }
            Trace.error("Error: docSelector returned unknown attribute: '" + attrName + "'");
            return false;
        }
        if (srcPath == null) {
            Trace.error("Error: docSelector must return 'fileName' attribute");
            return false;
        }
        if (format == null && fileName != null) {
            String lcFileName = fileName.toLowerCase();
            if (lcFileName.endsWith(".xml")) {
                format = "XML";
            } else if (lcFileName.endsWith(".pdf")) {
                format = "PDF";
            } else if (lcFileName.endsWith(".htm") || lcFileName.endsWith(".html")) {
                format = "HTML";
            } else if (lcFileName.endsWith(".doc")) {
                format = "MSWord";
            } else if (lcFileName.endsWith(".txt")) {
                format = "Text";
            } else if (lcFileName.endsWith(".marc") || lcFileName.endsWith(".mrc")) {
                format = "MARC";
            } else {
                Trace.warning("Warning: cannot deduce file type from extension on file '" + srcPath);
                return false;
            }
        }
        String key = IndexUtil.calcDocKey(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, srcPath);
        String systemId = srcPath.toURL().toString();
        StructuredFileProxy lazyStore = null;
        if (this.cfgInfo.buildLazyFiles) {
            File lazyFile = IndexUtil.calcLazyPath(new File(this.cfgInfo.xtfHomePath), this.cfgInfo.indexInfo, srcPath, true);
            lazyStore = new StructuredFileProxy(lazyFile);
        }
        Templates[] preFilters = null;
        if (!preFilterVec.isEmpty()) {
            preFilters = preFilterVec.toArray(new Templates[preFilterVec.size()]);
        }
        IndexSource srcFile = null;
        if (format.equalsIgnoreCase("XML")) {
            InputSource finalSrc = new InputSource(systemId);
            srcFile = new XMLIndexSource(finalSrc, srcPath, key, preFilters, displayStyle, lazyStore);
            if (removeDoctypeDecl) {
                ((XMLIndexSource)srcFile).removeDoctypeDecl(true);
            }
        } else if (format.equalsIgnoreCase("PDF")) {
            srcFile = new PDFIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("HTML")) {
            srcFile = new HTMLIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("MSWord")) {
            srcFile = new MSWordIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("Text")) {
            srcFile = new TextIndexSource(srcPath, key, preFilters, displayStyle, null);
        } else if (format.equalsIgnoreCase("MARC")) {
            srcFile = new MARCIndexSource(srcPath, key, preFilters, displayStyle);
        } else {
            throw new RuntimeException("Internal error: code missing support for type");
        }
        this.textProcessor.checkAndQueueText(srcFile);
        return true;
    }

    static class CacheEntry
    implements Serializable {
        String filesAndTimes;
        boolean anyProcessed;

        CacheEntry() {
        }

        CacheEntry(String filesAndTimes, boolean anyProcessed) {
            this.filesAndTimes = filesAndTimes;
            this.anyProcessed = anyProcessed;
        }
    }
}

