/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.cdlib.xtf.textIndexer.XTFTextAnalyzer;
import org.cdlib.xtf.util.FastStringReader;
import org.cdlib.xtf.util.Tester;
import org.cdlib.xtf.util.Trace;

public class TagFilter
extends TokenFilter {
    public static final String XML_TYPE = "ELEMENT".intern();
    private char[] srcChars;
    private boolean inElement = false;
    private String elementName = null;
    private boolean inEndTag = false;
    private Token elementStart = null;
    private boolean inQuote = false;
    private int quoteStart = -1;
    private boolean inAttrName = false;
    private int attrNameStart = -1;
    private String attrName = null;
    private LinkedList tokenQueue = new LinkedList();
    public static final Tester tester = new Tester("TagFilter"){

        private String testFilter(String in) throws IOException {
            int i;
            Token t;
            XTFTextAnalyzer analyzer = new XTFTextAnalyzer(null, null, null);
            TokenStream stream = analyzer.tokenStream("meta", new FastStringReader(in));
            StringBuffer outBuf = new StringBuffer();
            while ((t = stream.next()) != null) {
                if (t.getPositionIncrement() == 0) {
                    outBuf.append(',');
                } else {
                    for (i = 0; i < t.getPositionIncrement(); ++i) {
                        outBuf.append(':');
                    }
                }
                outBuf.append(t.termText());
            }
            char[] chars = outBuf.toString().toCharArray();
            block6: for (i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '\ue111': {
                        chars[i] = 33;
                        continue block6;
                    }
                    case '\ue112': {
                        chars[i] = 64;
                    }
                }
            }
            String out = new String(chars);
            Trace.debug(in + " --> " + out);
            return out;
        }

        protected void testImpl() {
            block13: {
                try {
                    assert (this.testFilter("x y").equals(":x:y"));
                    assert (this.testFilter("<element>").equals(":!<element:!>element"));
                    assert (this.testFilter("<element>x y z</element>").equals(":!<element:!>element:x:y:z:!/element"));
                    assert (this.testFilter("<element attr=\"a\"/>").equals(":!<element:@[attr:@a:@]attr:!>element:!/element"));
                    assert (this.testFilter("<element attr=\"a b c\"/>").equals(":!<element:@[attr:@a:@b:@c:@]attr:!>element:!/element"));
                    assert (this.testFilter("<element attr=\"\"/>").equals(":!<element:@[attr:@:@]attr:!>element:!/element"));
                    assert (this.testFilter("<element/>").equals(":!<element:!>element:!/element"));
                    assert (this.testFilter("<element att1=\"foo bar\" att2=\"wow\">hello there</element>").equals(":!<element:@[att1:@foo:@bar:@]att1:@[att2:@wow:@]att2:!>element:hello:there:!/element"));
                    String bump = "\uebbb5\uebbb";
                    assert (this.testFilter("x" + bump + "<element att=\"a\"/>").equals(":x::::::!<element:@[att:@a:@]att:!>element:!/element"));
                    assert (this.testFilter("<el1/>" + bump + "<el2/>").equals(":!<el1:!>el1:!/el1::::::!<el2:!>el2:!/el2"));
                    assert (this.testFilter("<$ foo=\"bar\">xyz").equals(":!<$:@[foo:@bar:@]foo:!>$:xyz"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
        }
    };

    public TagFilter(TokenStream input, String srcText) {
        super(input);
        this.srcChars = srcText.toCharArray();
    }

    public Token next() throws IOException {
        while (this.tokenQueue.isEmpty()) {
            Token curToken = this.input.next();
            Token toReturn = this.processNext(curToken);
            if (toReturn == null && curToken != null) continue;
            if (this.tokenQueue.isEmpty()) {
                return toReturn;
            }
            this.tokenQueue.add(toReturn);
        }
        return (Token)this.tokenQueue.removeFirst();
    }

    private Token processNext(Token curToken) {
        int endPos;
        int startPos = curToken != null ? curToken.startOffset() : this.srcChars.length;
        int n = endPos = curToken != null ? curToken.endOffset() : this.srcChars.length;
        if (!this.inElement) {
            if (curToken == null) {
                return null;
            }
            if (startPos > 0 && this.srcChars[startPos - 1] == '&') {
                String tokVal;
                if (curToken.termText().equals("amp")) {
                    tokVal = "&";
                } else if (curToken.termText().equals("lt")) {
                    tokVal = "<";
                } else if (curToken.termText().equals("gt")) {
                    tokVal = ">";
                } else if (curToken.termText().equals("quot")) {
                    tokVal = "\"";
                } else if (curToken.termText().equals("apos")) {
                    tokVal = "'";
                } else {
                    return null;
                }
                return new Token(tokVal, startPos - 1, endPos + 1, XML_TYPE);
            }
            if (this.srcChars[startPos] != '<') {
                return curToken;
            }
            this.elementStart = curToken;
            this.inElement = true;
            return null;
        }
        if (this.elementStart != null) {
            this.elementName = new String(this.srcChars, startPos, endPos - startPos);
            int start = this.elementStart.startOffset() + 1;
            int end = endPos;
            this.inEndTag = this.srcChars[start] == '/';
            String name = '\ue111' + (this.inEndTag ? "" : "<") + new String(this.srcChars, start, end - start);
            Token newToken = new Token(name, this.elementStart.startOffset(), end, XML_TYPE);
            newToken.setPositionIncrement(this.elementStart.getPositionIncrement());
            this.elementStart = null;
            return newToken;
        }
        if (this.inQuote) {
            int i;
            for (i = this.quoteStart + 1; i < startPos && this.srcChars[i] != '\"'; ++i) {
            }
            if (i < startPos) {
                String tokValue = "\ue112]" + this.attrName;
                this.tokenQueue.add(new Token(tokValue, startPos, startPos, XML_TYPE));
                this.inQuote = false;
            } else {
                this.quoteStart = endPos - 1;
            }
        }
        if (this.srcChars[startPos] == '>') {
            this.inElement = false;
            if (!this.inEndTag) {
                this.tokenQueue.add(new Token("\ue111>" + this.elementName, startPos, endPos, XML_TYPE));
            }
            this.inEndTag = false;
            if (this.srcChars[startPos - 1] == '/') {
                String name = "\ue111/" + this.elementName;
                return new Token(name, startPos, endPos, XML_TYPE);
            }
            return null;
        }
        if (this.inQuote) {
            String name = '\ue112' + curToken.termText();
            return new Token(name, startPos, endPos, XML_TYPE);
        }
        if (!this.inAttrName) {
            this.attrNameStart = startPos;
            this.inAttrName = true;
            return null;
        }
        if (this.srcChars[startPos] != '=') {
            return null;
        }
        this.attrName = new String(this.srcChars, this.attrNameStart, startPos - this.attrNameStart).trim();
        this.tokenQueue.add(new Token("\ue112[" + this.attrName, this.attrNameStart, endPos, XML_TYPE));
        this.inAttrName = false;
        this.inQuote = true;
        this.quoteStart = endPos;
        while (this.quoteStart < this.srcChars.length && this.srcChars[this.quoteStart] != '\"') {
            ++this.quoteStart;
        }
        if (this.quoteStart + 1 < this.srcChars.length && this.srcChars[this.quoteStart + 1] == '\"') {
            return new Token("\ue112", this.quoteStart, this.quoteStart, XML_TYPE);
        }
        return null;
    }
}

