/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import org.cdlib.xtf.textIndexer.IdxTreeCleaner;
import org.cdlib.xtf.textIndexer.IdxTreeCuller;
import org.cdlib.xtf.textIndexer.IdxTreeDictMaker;
import org.cdlib.xtf.textIndexer.IdxTreeOptimizer;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.SrcTreeProcessor;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class TextIndexer {
    public static final String CURRENT_VERSION = "2.1.1";
    public static final String REQUIRED_VERSION = "2.0";

    public static void main(String[] args) {
        try {
            String ending;
            File idxRootDir;
            IndexerConfig cfgInfo = new IndexerConfig();
            XMLConfigParser cfgParser = new XMLConfigParser();
            SrcTreeProcessor srcTreeProcessor = new SrcTreeProcessor();
            IdxTreeCleaner indexCleaner = new IdxTreeCleaner();
            int startArg = 0;
            boolean showUsage = false;
            boolean firstIndex = true;
            long startTime = System.currentTimeMillis();
            Trace.info("TextIndexer v2.1.1");
            Trace.info("");
            Trace.tab();
            cfgInfo.xtfHomePath = System.getProperty("xtf.home");
            if (cfgInfo.xtfHomePath == null || cfgInfo.xtfHomePath.length() == 0) {
                Trace.error("Error: xtf.home property not found");
                System.exit(1);
            }
            cfgInfo.xtfHomePath = Path.normalizePath(cfgInfo.xtfHomePath);
            if (!new File(cfgInfo.xtfHomePath).isDirectory()) {
                Trace.error("Error: xtf.home directory \"" + cfgInfo.xtfHomePath + "\" does not exist or cannot be read.");
                System.exit(1);
            }
            while (true) {
                if (args.length < 2) {
                    showUsage = true;
                } else {
                    int ret = cfgInfo.readCmdLine(args, startArg);
                    if (ret == -1) {
                        if (startArg != 0) break;
                        showUsage = true;
                    } else {
                        if (!new File(cfgInfo.cfgFilePath).isAbsolute()) {
                            cfgInfo.cfgFilePath = Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.cfgFilePath);
                        }
                        if (cfgParser.configure(cfgInfo) < 0) {
                            Trace.error("Error: index '" + cfgInfo.indexInfo.indexName + "' not found\n");
                            System.exit(1);
                        }
                        cfgInfo.mustClean = cfgInfo.clean;
                        Trace.setOutputLevel(cfgInfo.traceLevel);
                    }
                    startArg = ret;
                }
                if (showUsage) {
                    Trace.error("Usage: textIndexer {options} -index indexname");
                    Trace.error("Available options:");
                    Trace.tab();
                    Trace.error("-config <configfile>                  Default: -config textIndexer.conf");
                    Trace.error("-incremental|-clean                   Default: -incremental");
                    Trace.error("-optimize|-nooptimize                 Default: -optimize");
                    Trace.error("-trace errors|warnings|info|debug     Default: -trace info");
                    Trace.error("-dir <subdir>                         Default: (all data directories)");
                    Trace.error("-buildlazy|-nobuildlazy               Default: -buildlazy");
                    Trace.error("-updatespell|-noupdatespell           Default: -updatespell");
                    Trace.error("\n");
                    Trace.untab();
                    System.exit(1);
                }
                File xtfHomeFile = new File(cfgInfo.xtfHomePath);
                if (firstIndex) {
                    if (!cfgInfo.mustClean) {
                        idxRootDir = new File(Path.resolveRelOrAbs(xtfHomeFile, cfgInfo.indexInfo.indexPath));
                        Trace.info("");
                        Trace.info("Purging Incomplete Documents From Indexes:");
                        Trace.tab();
                        indexCleaner.processDir(idxRootDir);
                        Trace.untab();
                        Trace.info("Done.");
                    }
                    Trace.info("");
                    Trace.info("Indexing New/Updated Documents:");
                    Trace.tab();
                    firstIndex = false;
                }
                Trace.info("Index: \"" + cfgInfo.indexInfo.indexName + "\"");
                if (Trace.getOutputLevel() == 8) {
                    Trace.more(" [ Chunk Size = " + cfgInfo.indexInfo.getChunkSize() + ", Overlap = " + cfgInfo.indexInfo.getChunkOvlp() + " ]");
                }
                Trace.tab();
                String srcRootDir = Path.resolveRelOrAbs(xtfHomeFile, cfgInfo.indexInfo.sourcePath);
                if (cfgInfo.indexInfo.subDir != null) {
                    srcRootDir = Path.resolveRelOrAbs(srcRootDir, Path.normalizePath(cfgInfo.indexInfo.subDir));
                }
                if (!cfgInfo.skipIndexing) {
                    srcTreeProcessor.open(cfgInfo);
                    srcTreeProcessor.processDir(new File(srcRootDir), 0);
                    srcTreeProcessor.close();
                    IdxTreeCuller culler = new IdxTreeCuller();
                    Trace.info("Removing Missing Documents From Index:");
                    Trace.tab();
                    culler.cullIndex(new File(cfgInfo.xtfHomePath), cfgInfo.indexInfo);
                    Trace.untab();
                    Trace.info("Done.");
                }
                Trace.untab();
                Trace.info("Done.");
            }
            Trace.untab();
            Trace.info("Done.");
            if (cfgInfo.optimize) {
                IdxTreeOptimizer optimizer = new IdxTreeOptimizer();
                Trace.info("");
                Trace.info("Optimizing Index:");
                Trace.tab();
                idxRootDir = new File(Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath));
                optimizer.processDir(idxRootDir);
                Trace.untab();
                Trace.info("Done.");
            } else {
                Trace.info("");
                Trace.info("Skipping Optimization Pass.");
            }
            if (cfgInfo.updateSpellDict && cfgInfo.indexInfo.createSpellcheckDict) {
                IdxTreeDictMaker dictMaker = new IdxTreeDictMaker();
                Trace.info("");
                Trace.info("Updating Spellcheck Dictionary:");
                Trace.tab();
                idxRootDir = new File(Path.resolveRelOrAbs(cfgInfo.xtfHomePath, cfgInfo.indexInfo.indexPath));
                dictMaker.processDir(idxRootDir);
                Trace.untab();
                Trace.info("Done.");
            } else {
                Trace.info("");
                Trace.info("Skipping Spellcheck Dictionary Pass.");
            }
            Trace.untab();
            Trace.info("");
            long timeMsec = System.currentTimeMillis() - startTime;
            long timeSec = timeMsec / 1000L;
            long timeMin = timeSec / 60L;
            long timeHour = timeMin / 60L;
            Trace.info("Total time: ");
            if (timeHour > 0L) {
                ending = timeHour == 1L ? "" : "s";
                Trace.more(4, timeHour + " hour" + ending + ", ");
            }
            if (timeMin > 0L) {
                ending = timeMin % 60L == 1L ? "" : "s";
                Trace.more(4, timeMin % 60L + " minute" + ending + ", ");
            }
            ending = timeSec % 60L == 1L ? "" : "s";
            Trace.more(4, timeSec % 60L + " second" + ending + ".");
            Trace.info("Indexing complete.");
            Trace.info("");
        }
        catch (Throwable t) {
            Trace.clearTabs();
            Trace.error("*** Error: " + t.getClass());
            Trace.error("");
            t.printStackTrace(System.out);
            Trace.error("Indexing Process Aborted.");
            System.exit(1);
        }
    }
}

