/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigParser
extends DefaultHandler {
    private boolean isConfigFile = false;
    private boolean indexNameFound = false;
    private boolean inNamedIndexBlock = false;
    private IndexerConfig configInfo;

    public int configure(IndexerConfig cfgInfo) throws Exception {
        this.isConfigFile = false;
        this.indexNameFound = false;
        this.inNamedIndexBlock = false;
        try {
            if (!new File(cfgInfo.cfgFilePath).canRead()) {
                Trace.error("Error: unable to read textIndexer config file \"" + cfgInfo.cfgFilePath + "\"");
                return -1;
            }
            this.configInfo = cfgInfo;
            SAXParser xmlParser = IndexUtil.createSAXParser();
            xmlParser.parse(new File(cfgInfo.cfgFilePath).toURI().toString(), (DefaultHandler)this);
        }
        catch (Throwable t) {
            Trace.error("*** Caught an XML Parser Exception: " + t.getClass() + "\n" + "    With message: " + t.getMessage());
            throw t instanceof Exception ? (Exception)t : new RuntimeException(t);
        }
        if (!this.isConfigFile || !this.indexNameFound) {
            return -1;
        }
        if (cfgInfo.indexInfo.indexPath == null || cfgInfo.indexInfo.indexPath.equals("")) {
            Trace.error("Error: Index configuration file failed to specify 'db' element");
            return -1;
        }
        if (cfgInfo.indexInfo.sourcePath == null || cfgInfo.indexInfo.sourcePath.equals("")) {
            Trace.error("Error: Index configuration file failed to specify 'sourcePath' element");
            return -1;
        }
        if (cfgInfo.indexInfo.docSelectorPath == null || cfgInfo.indexInfo.docSelectorPath.equals("")) {
            Trace.error("Error: Index configuration file failed to specify 'docSelectorPath' element");
            return -1;
        }
        return 0;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equalsIgnoreCase("textIndexer-config")) {
            this.isConfigFile = true;
            return;
        }
        if (!this.isConfigFile) {
            return;
        }
        if (qName.equalsIgnoreCase("index")) {
            String xmlIdxName = atts.getValue("name").trim();
            if (xmlIdxName == null || xmlIdxName.length() == 0) {
                return;
            }
            String idxName = this.configInfo.indexInfo.indexName;
            if (xmlIdxName.equalsIgnoreCase(idxName)) {
                this.indexNameFound = true;
                this.inNamedIndexBlock = true;
                return;
            }
            this.inNamedIndexBlock = false;
            return;
        }
        if (!this.inNamedIndexBlock) {
            return;
        }
        if (qName.equalsIgnoreCase("db")) {
            this.configInfo.indexInfo.indexPath = Path.normalizePath(atts.getValue("path"));
            return;
        }
        if (qName.equalsIgnoreCase("src")) {
            this.configInfo.indexInfo.sourcePath = Path.normalizePath(atts.getValue("path"));
            return;
        }
        if (qName.equalsIgnoreCase("docSelector")) {
            this.configInfo.indexInfo.docSelectorPath = Path.normalizePath(atts.getValue("path"));
            return;
        }
        if (qName.equalsIgnoreCase("chunk")) {
            String value = atts.getValue("size");
            if (value == null || value.length() == 0) {
                this.configInfo.indexInfo.setChunkSize(100);
                this.configInfo.indexInfo.setChunkOvlp(50);
                return;
            }
            this.configInfo.indexInfo.setChunkSize(Math.max(2, Integer.parseInt(value)));
            value = atts.getValue("overlap");
            if (value == null || value.length() == 0) {
                this.configInfo.indexInfo.setChunkOvlp(this.configInfo.indexInfo.chunkAtt[0]);
                return;
            }
            this.configInfo.indexInfo.setChunkOvlp(Integer.parseInt(value));
            return;
        }
        if (qName.equalsIgnoreCase("stopwords")) {
            String list = atts.getValue("list");
            String path = atts.getValue("path");
            if (list != null && list.length() > 0) {
                this.configInfo.indexInfo.stopWords = atts.getValue("list");
            } else if (path != null && path.length() > 0) {
                path = Path.normalizeFileName(atts.getValue("path"));
                File file = new File(new File(this.configInfo.xtfHomePath), path);
                try {
                    InputStream stream = new FileInputStream(file);
                    if (path.endsWith(".gz")) {
                        stream = new GZIPInputStream(stream);
                    }
                    InputStreamReader reader = new InputStreamReader(stream);
                    char[] buf = new char[(int)file.length()];
                    int length = reader.read(buf);
                    this.configInfo.indexInfo.stopWords = new String(buf, 0, length);
                }
                catch (IOException e) {
                    Trace.error("Error reading stop-words file \"" + path + "\": " + e);
                    System.exit(1);
                }
            } else {
                this.configInfo.indexInfo.stopWords = "a an and are as at be but by for if in into is it no not of on or s such t that the their then there these they this to was will with";
            }
            return;
        }
        if (qName.equalsIgnoreCase("pluralmap")) {
            this.configInfo.indexInfo.pluralMapPath = Path.normalizePath(atts.getValue("path"));
            return;
        }
        if (qName.equalsIgnoreCase("accentmap")) {
            this.configInfo.indexInfo.accentMapPath = Path.normalizePath(atts.getValue("path"));
            return;
        }
        if (qName.equalsIgnoreCase("spellcheck")) {
            String val = atts.getValue("createDict");
            if (val == null) {
                val = atts.getValue("createdict");
            }
            if ("yes".equals(val) || "true".equals(val)) {
                this.configInfo.indexInfo.createSpellcheckDict = true;
            } else if ("no".equals(val) || "false".equals(val)) {
                this.configInfo.indexInfo.createSpellcheckDict = false;
            } else {
                Trace.error("Unrecognized value for 'createDict' attribute of config option: '" + qName + "'");
                System.exit(1);
            }
            return;
        }
        if (qName.equalsIgnoreCase("whitespace")) {
            String val = atts.getValue("strip");
            if ("yes".equals(val) || "true".equals(val)) {
                this.configInfo.indexInfo.stripWhitespace = true;
            } else if ("no".equals(val) || "false".equals(val)) {
                this.configInfo.indexInfo.stripWhitespace = false;
            } else {
                Trace.error("Unrecognized value for 'strip' attribute of config option: '" + qName + "'");
                System.exit(1);
            }
            return;
        }
        Trace.error("Unknown config option: '" + qName + "'");
        System.exit(1);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("index")) {
            this.inNamedIndexBlock = false;
        }
    }
}

