/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NamePool;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.bigram.BigramStopFilter;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.store.FSDirectory;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.LazyKeyManager;
import org.cdlib.xtf.lazyTree.LazyTreeBuilder;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.textIndexer.IndexRecord;
import org.cdlib.xtf.textIndexer.IndexSource;
import org.cdlib.xtf.textIndexer.SectionInfoStack;
import org.cdlib.xtf.textIndexer.XTFTextAnalyzer;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.FastStringReader;
import org.cdlib.xtf.util.FastTokenizer;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.WordMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTextProcessor
extends DefaultHandler {
    private static final int bufStartSize = 16384;
    private int chunkCount = 0;
    private int curNode = -1;
    private int nodeWordCount = 0;
    private int chunkStartNode = -1;
    private int chunkWordCount = 0;
    private int chunkWordOffset = 0;
    private int nextChunkStartNode = -1;
    private int nextChunkWordCount = 0;
    private int nextChunkWordOffset = 0;
    private int nextChunkStartIdx = 0;
    private int chunkWordSize = 0;
    private int chunkWordOvlp = 0;
    private int chunkWordOvlpStart = 0;
    private Set stopSet = null;
    private WordMap pluralMap = null;
    private CharMap accentMap = null;
    private boolean forcedChunk = false;
    private IndexInfo indexInfo;
    private String xtfHomePath;
    private LinkedList fileQueue = new LinkedList();
    private IndexSource curIdxSrc;
    private IndexRecord curIdxRecord;
    private String curPrettyKey;
    private String indexPath;
    private LazyTreeBuilder lazyBuilder;
    private StructuredStore lazyStore;
    private Receiver lazyReceiver;
    private ReceivingContentHandler lazyHandler;
    private char[] charBuf = new char[1024];
    private int charBufPos = 0;
    private int inMeta = 0;
    private LinkedList metaInfo;
    private MetaField metaField;
    private StringBuffer metaBuf = new StringBuffer();
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private IndexWriter indexWriter;
    private SpellWriter spellWriter;
    private HashSet tokenizedFields;
    private static final int MAX_DELETION_BATCH = 50;
    private StringBuffer blurbedText;
    private StringBuffer accumText;
    private StringBuffer compactedAccumText;
    private SectionInfoStack section = new SectionInfoStack();
    private static final String xtfUri = "http://cdlib.org/xtf";

    public void open(String homePath, IndexInfo idxInfo, boolean clean) throws IOException {
        this.fileQueue = new LinkedList();
        try {
            String accentMapName;
            this.indexInfo = idxInfo;
            this.xtfHomePath = homePath;
            this.indexPath = this.getIndexPath();
            if (this.indexInfo.stopWords != null) {
                this.stopSet = BigramStopFilter.makeStopSet(this.indexInfo.stopWords);
            }
            if (clean) {
                Path.createPath(this.indexPath);
                this.createIndex(this.indexInfo);
            } else {
                Path.createPath(this.indexPath);
                FSDirectory idxDir = FSDirectory.getDirectory(this.indexPath);
                if (!IndexReader.indexExists(idxDir)) {
                    this.createIndex(this.indexInfo);
                }
            }
            this.openIdxForReading();
            Hits match = this.indexSearcher.search(new TermQuery(new Term("indexInfo", "1")));
            if (match.length() == 0) {
                throw new RuntimeException("Index missing indexInfo");
            }
            Document doc = match.doc(0);
            String indexVersion = doc.get("xtfIndexVersion");
            if (indexVersion == null) {
                indexVersion = "1.0";
            }
            if (indexVersion.compareTo("2.0") < 0) {
                throw new RuntimeException("Incompatible index version " + indexVersion + "; require at least " + "2.0" + "... consider re-indexing with '-clean'.");
            }
            if (Integer.parseInt(doc.get("chunkSize")) != this.indexInfo.getChunkSize()) {
                throw new RuntimeException("Index chunk size (" + doc.get("chunkSize") + ") doesn't match config (" + this.indexInfo.getChunkSize() + ")");
            }
            if (Integer.parseInt(doc.get("chunkOvlp")) != this.indexInfo.getChunkOvlp()) {
                throw new RuntimeException("Index chunk overlap (" + doc.get("chunkOvlp") + ") doesn't match config (" + this.indexInfo.getChunkOvlp() + ")");
            }
            String stopWords = this.indexInfo.stopWords;
            if (stopWords == null) {
                stopWords = "";
            }
            if (!doc.get("stopWords").equals(stopWords)) {
                throw new RuntimeException("Index stop words (" + doc.get("stopWords") + ") doesn't match config (" + this.indexInfo.stopWords + ")");
            }
            String pluralMapName = doc.get("pluralMap");
            if (pluralMapName != null && pluralMapName.length() > 0) {
                File pluralMapFile = new File(Path.normalizePath(this.indexPath + pluralMapName));
                InputStream stream = new FileInputStream(pluralMapFile);
                if (pluralMapName.endsWith(".gz")) {
                    stream = new GZIPInputStream(stream);
                }
                this.pluralMap = new WordMap(stream);
            }
            if ((accentMapName = doc.get("accentMap")) != null && accentMapName.length() > 0) {
                File accentMapFile = new File(Path.normalizePath(this.indexPath + accentMapName));
                InputStream stream = new FileInputStream(accentMapFile);
                if (accentMapName.endsWith(".gz")) {
                    stream = new GZIPInputStream(stream);
                }
                this.accentMap = new CharMap(stream);
            }
            this.tokenizedFields = XtfSearcher.readTokenizedFields(this.indexPath, this.indexReader);
        }
        catch (IOException e) {
            Trace.tab();
            Trace.error("*** IOException Opening or Creating Index: " + e);
            Trace.untab();
            this.close();
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.spellWriter != null) {
            this.spellWriter.close();
        }
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
        }
        if (this.indexReader != null) {
            this.indexReader.close();
        }
        this.spellWriter = null;
        this.indexWriter = null;
        this.indexSearcher = null;
        this.indexReader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(IndexInfo indexInfo) throws IOException {
        try {
            String stopWords;
            String targetPath;
            String sourcePath;
            String fileName;
            Path.deleteDir(new File(this.indexPath));
            this.indexWriter = new IndexWriter(this.indexPath, (Analyzer)new XTFTextAnalyzer(this.stopSet, this.pluralMap, this.accentMap), true);
            Document doc = new Document();
            doc.add(new Field("indexInfo", "1", Field.Store.YES, Field.Index.UN_TOKENIZED));
            doc.add(new Field("xtfIndexVersion", "2.1.1", Field.Store.YES, Field.Index.NO));
            doc.add(new Field("chunkSize", indexInfo.getChunkSizeStr(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("chunkOvlp", indexInfo.getChunkOvlpStr(), Field.Store.YES, Field.Index.NO));
            if (indexInfo.pluralMapPath != null && indexInfo.pluralMapPath.length() > 0) {
                fileName = new File(indexInfo.pluralMapPath).getName();
                sourcePath = Path.normalizeFileName(this.xtfHomePath + indexInfo.pluralMapPath);
                targetPath = Path.normalizeFileName(this.indexPath + fileName);
                Path.copyFile(new File(sourcePath), new File(targetPath));
                doc.add(new Field("pluralMap", fileName, Field.Store.YES, Field.Index.NO));
            }
            if (indexInfo.accentMapPath != null && indexInfo.accentMapPath.length() > 0) {
                fileName = new File(indexInfo.accentMapPath).getName();
                sourcePath = Path.normalizeFileName(this.xtfHomePath + indexInfo.accentMapPath);
                targetPath = Path.normalizeFileName(this.indexPath + fileName);
                Path.copyFile(new File(sourcePath), new File(targetPath));
                doc.add(new Field("accentMap", fileName, Field.Store.YES, Field.Index.NO));
            }
            if ((stopWords = indexInfo.stopWords) == null) {
                stopWords = "";
            }
            doc.add(new Field("stopWords", stopWords, Field.Store.YES, Field.Index.NO));
            this.indexWriter.addDocument(doc);
        }
        finally {
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            }
        }
    }

    public void checkAndQueueText(IndexSource idxSrc) throws ParserConfigurationException, SAXException, IOException {
        int ret = this.checkFile(idxSrc);
        if (ret == 1) {
            return;
        }
        boolean deleteFirst = ret == 2;
        this.queueText(idxSrc, deleteFirst);
    }

    public void queueText(IndexSource idxSrc) {
        this.queueText(idxSrc, false);
    }

    public void queueText(IndexSource srcInfo, boolean deleteFirst) {
        this.fileQueue.add(new FileQueueEntry(srcInfo, deleteFirst));
    }

    public int getQueueSize() {
        return this.fileQueue.size();
    }

    public boolean removeSingleDoc(File srcFile, String key) throws ParserConfigurationException, SAXException, IOException {
        this.openIdxForReading();
        int nDeleted = this.indexReader.deleteDocuments(new Term("key", key));
        if (srcFile != null) {
            File lazyFile = IndexUtil.calcLazyPath(new File(this.xtfHomePath), this.indexInfo, srcFile, false);
            Path.deletePath(lazyFile.toString());
        }
        return nDeleted > 0;
    }

    public boolean docExists(String key) throws ParserConfigurationException, SAXException, IOException {
        BooleanQuery query = new BooleanQuery();
        Term docInfo = new Term("docInfo", "1");
        Term srcPath = new Term("key", key);
        query.add(new TermQuery(docInfo), BooleanClause.Occur.MUST);
        query.add(new TermQuery(srcPath), BooleanClause.Occur.MUST);
        Hits match = this.indexSearcher.search(query);
        return match.length() > 0;
    }

    public void batchDelete() throws IOException {
        if (this.fileQueue.isEmpty() || !((FileQueueEntry)this.fileQueue.getFirst()).deleteFirst) {
            return;
        }
        this.openIdxForReading();
        Iterator iter = this.fileQueue.iterator();
        for (int batchSize = 0; iter.hasNext() && batchSize < 50; ++batchSize) {
            FileQueueEntry ent = (FileQueueEntry)iter.next();
            if (!ent.deleteFirst) continue;
            this.indexReader.deleteDocuments(new Term("key", ent.idxSrc.key()));
            ent.deleteFirst = false;
        }
    }

    public void processQueuedTexts() throws IOException {
        this.blurbedText = new StringBuffer(16384);
        this.accumText = new StringBuffer(16384);
        this.compactedAccumText = new StringBuffer(16384);
        long totalSize = 0L;
        for (FileQueueEntry ent : this.fileQueue) {
            totalSize += ent.idxSrc.totalSize();
        }
        if (totalSize < 1L) {
            totalSize = 1L;
        }
        long processedSize = 0L;
        int recordBatchSize = 100;
        while (!this.fileQueue.isEmpty()) {
            boolean printDone = false;
            this.batchDelete();
            this.openIdxForWriting();
            FileQueueEntry ent = (FileQueueEntry)this.fileQueue.removeFirst();
            IndexSource idxFile = ent.idxSrc;
            assert (!ent.deleteFirst);
            try {
                IndexRecord idxRec;
                while ((idxRec = idxFile.nextRecord()) != null) {
                    long fileBytesDone = (long)idxRec.percentDone() * idxFile.totalSize() / 100L;
                    int percentDone = (int)((processedSize + fileBytesDone) * 100L / totalSize);
                    int recordNum = idxRec.recordNum();
                    String key = idxFile.key();
                    String string = this.curPrettyKey = key.indexOf(58) >= 0 ? key.substring(key.indexOf(58) + 1) : key;
                    if (recordNum > 0) {
                        this.curPrettyKey = this.curPrettyKey + "/" + recordNum;
                    }
                    if (recordNum == 0 || recordNum % 100 == 1) {
                        if (printDone) {
                            Trace.more(4, "Done.");
                        }
                        String msg = "";
                        msg = "(" + percentDone + "%) ";
                        while (msg.length() < 7) {
                            msg = msg + " ";
                        }
                        Trace.info(msg + "Indexing [" + this.curPrettyKey + "] ... ");
                        printDone = true;
                    }
                    this.processText(idxFile, idxRec, recordNum);
                }
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            if (printDone) {
                Trace.more(4, "Done.");
            }
            processedSize += idxFile.totalSize();
        }
    }

    private int processText(IndexSource file, IndexRecord record, int recordNum) throws IOException {
        this.accumText.setLength(0);
        this.compactedAccumText.setLength(0);
        this.curIdxSrc = file;
        this.curIdxRecord = record;
        this.lazyStore = record.lazyStore();
        if (this.lazyStore != null) {
            Configuration config = new Configuration();
            config.setNamePool(NamePool.getDefaultNamePool());
            this.lazyBuilder = new LazyTreeBuilder(config);
            this.lazyReceiver = this.lazyBuilder.begin(this.lazyStore);
            this.lazyBuilder.setNamePool(config.getNamePool());
            this.lazyHandler = new ReceivingContentHandler();
            this.lazyHandler.setReceiver(this.lazyReceiver);
            this.lazyHandler.setPipelineConfiguration(this.lazyReceiver.getPipelineConfiguration());
        } else {
            this.lazyBuilder = null;
            this.lazyReceiver = null;
            this.lazyHandler = null;
        }
        this.chunkWordSize = this.indexInfo.getChunkSize();
        this.chunkWordOvlp = this.indexInfo.getChunkOvlp();
        this.chunkWordOvlpStart = this.chunkWordSize - this.chunkWordOvlp;
        this.curNode = 0;
        this.chunkStartNode = -1;
        this.nextChunkStartNode = -1;
        this.nodeWordCount = 0;
        this.chunkWordCount = 0;
        this.chunkWordOffset = 0;
        this.nextChunkStartIdx = 0;
        this.nextChunkWordCount = 0;
        this.nextChunkWordOffset = 0;
        this.forcedChunk = false;
        this.inMeta = 0;
        this.metaBuf.setLength(0);
        this.metaInfo = null;
        this.chunkCount = 0;
        this.section.push();
        int result = this.parseText();
        if (this.lazyBuilder != null) {
            Templates displayStyle;
            this.lazyBuilder.finish(this.lazyReceiver, false);
            if (result == 0 && (displayStyle = file.displayStyle()) != null) {
                try {
                    this.precacheXSLKeys();
                }
                catch (IOException e) {
                    Trace.tab();
                    Trace.error("Error pre-caching XSL keys from display stylesheet \"" + displayStyle + "\": " + e);
                    Trace.untab();
                    throw e;
                }
                catch (Throwable t) {
                    Trace.tab();
                    Trace.error("Error pre-caching XSL keys from display stylesheet \"" + displayStyle + "\": " + t);
                    Trace.untab();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new IOException("Error pre-caching XSL keys from display stylesheet \"" + displayStyle + "\": " + t);
                }
            }
            this.lazyStore.close();
        }
        return result;
    }

    private int parseText() {
        try {
            SAXParser xmlParser = IndexUtil.createSAXParser();
            InputSource xmlSource = this.curIdxRecord.xmlSource();
            Templates[] prefilters = this.curIdxSrc.preFilters();
            if (prefilters == null || prefilters.length == 0) {
                xmlParser.parse(xmlSource, (DefaultHandler)this);
                return 0;
            }
            IndexUtil.applyPreFilters(prefilters, xmlParser.getXMLReader(), xmlSource, new SAXResult(this));
        }
        catch (Throwable t) {
            if (this.lazyReceiver != null) {
                this.lazyBuilder.abort(this.lazyReceiver);
                this.lazyBuilder = null;
                this.lazyReceiver = null;
                this.lazyHandler = null;
            }
            Trace.more(4, "Skipping Due to Errors");
            String message = "*** XML Parser Exception: " + t.getClass() + "\n" + "    With message: " + t.getMessage() + "\n" + "    File: " + this.curPrettyKey;
            if (this.curIdxRecord.recordNum() > 0) {
                message = message + "\n    Record number: " + this.curIdxRecord.recordNum();
            }
            Trace.info(message);
            return -1;
        }
        return 0;
    }

    private void precacheXSLKeys() throws Exception {
        Templates stylesheet = this.curIdxSrc.displayStyle();
        PreparedStylesheet pss = (PreparedStylesheet)stylesheet;
        Executable exec = pss.getExecutable();
        if (!(exec.getKeyManager() instanceof LazyKeyManager)) {
            exec.setKeyManager(new LazyKeyManager(pss.getConfiguration(), exec.getKeyManager()));
        }
        Transformer trans = pss.newTransformer();
        LazyKeyManager keyMgr = (LazyKeyManager)exec.getKeyManager();
        LazyDocument doc = (LazyDocument)this.lazyBuilder.load(this.lazyStore);
        int nKeysCreated = keyMgr.createAllKeys(doc, ((Controller)trans).newXPathContext());
        Trace.more(4, "(" + nKeysCreated + " stored " + (nKeysCreated == 1 ? "key" : "keys") + ") ... ");
        doc.close();
    }

    public void startDocument() throws SAXException {
        if (this.lazyHandler != null) {
            this.lazyHandler.startDocument();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int metaIndex;
        String metaVal;
        this.flushCharacters();
        if (this.lazyHandler != null) {
            this.lazyHandler.startElement(uri, localName, qName, atts);
        }
        String string = metaVal = (metaIndex = atts.getIndex(xtfUri, "meta")) >= 0 ? atts.getValue(metaIndex) : "";
        if (metaIndex >= 0 && ("yes".equals(metaVal) || "true".equals(metaVal))) {
            String tokStr;
            String tokStr2;
            String tokStr3;
            String tokStr4;
            String tokStr5;
            if (this.inMeta > 0) {
                throw new RuntimeException("Meta-data fields may not nest");
            }
            this.inMeta = 1;
            if (this.metaInfo == null) {
                this.metaInfo = new LinkedList();
            }
            boolean store = true;
            int tokIdx = atts.getIndex(xtfUri, "store");
            if (tokIdx >= 0 && (tokStr5 = atts.getValue(tokIdx)) != null && (tokStr5.equals("no") || tokStr5.equals("false"))) {
                store = false;
            }
            boolean index = true;
            tokIdx = atts.getIndex(xtfUri, "index");
            if (tokIdx >= 0 && (tokStr4 = atts.getValue(tokIdx)) != null && (tokStr4.equals("no") || tokStr4.equals("false"))) {
                index = false;
            }
            if ((tokIdx = atts.getIndex(xtfUri, "noIndex")) >= 0 && (tokStr4 = atts.getValue(tokIdx)) != null && (tokStr4.equals("yes") || tokStr4.equals("true"))) {
                index = false;
            }
            boolean tokenize = true;
            tokIdx = atts.getIndex(xtfUri, "tokenize");
            if (tokIdx >= 0 && (tokStr3 = atts.getValue(tokIdx)) != null && (tokStr3.equals("no") || tokStr3.equals("false"))) {
                tokenize = false;
            }
            boolean isFacet = false;
            tokIdx = atts.getIndex(xtfUri, "facet");
            if (tokIdx >= 0 && (tokStr2 = atts.getValue(tokIdx)) != null && (tokStr2.equals("yes") || tokStr2.equals("true"))) {
                isFacet = true;
            }
            boolean spell = true;
            tokIdx = atts.getIndex(xtfUri, "spell");
            if (tokIdx >= 0 && (tokStr = atts.getValue(tokIdx)) != null && (tokStr.equals("no") || tokStr.equals("false"))) {
                spell = false;
            }
            float boost = 1.0f;
            int boostIdx = atts.getIndex(xtfUri, "wordBoost");
            if (boostIdx < 0) {
                boostIdx = atts.getIndex(xtfUri, "wordboost");
            }
            if (boostIdx >= 0) {
                String boostStr = atts.getValue(boostIdx);
                boost = Float.parseFloat(boostStr);
            }
            if (localName.matches("^(text|key|docInfo|chunkCount|chunkOvlp|chunkSize|fileDate|indexInfo|stopWords|tokenizedFields|xtfIndexVersion)$")) {
                throw new RuntimeException("Reserved name '" + localName + "' not allowed as meta-data field");
            }
            this.metaField = new MetaField(localName, store, index, tokenize, isFacet, spell, boost);
            assert (this.metaBuf.length() == 0) : "Should have cleared meta-buf";
            String attrString = this.processMetaAttribs(atts);
            if (attrString.length() > 0) {
                this.metaBuf.append("<$ " + attrString + ">");
            }
        } else if (this.inMeta > 0) {
            ++this.inMeta;
            this.metaBuf.append("<" + localName);
            String attrString = this.processMetaAttribs(atts);
            if (attrString.length() > 0) {
                this.metaBuf.append(" " + attrString);
            }
            this.metaBuf.append(">");
        } else {
            String prevSectionType = this.section.sectionType();
            float prevWordBoost = this.section.wordBoost();
            int prevSpellFlag = this.section.spellFlag();
            this.ProcessNodeAttributes(atts);
            if (this.section.sectionType() != prevSectionType || this.section.wordBoost() != prevWordBoost || this.section.spellFlag() != prevSpellFlag) {
                this.forceNewChunk(prevSectionType, prevWordBoost, prevSpellFlag);
                Trace.tab();
                Trace.debug("Begin Section [" + this.section.sectionType() + "]");
                Trace.untab();
            }
        }
        this.incrementNode();
    }

    private String processMetaAttribs(Attributes atts) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attrUri = atts.getURI(i);
            if (attrUri.equals(xtfUri)) continue;
            if (buf.length() > 0) {
                buf.append(' ');
            }
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            buf.append(name + "=\"" + value + "\"");
        }
        return buf.toString();
    }

    private void incrementNode() {
        ++this.curNode;
        this.nodeWordCount = 0;
        if (this.accumText.length() > 0) {
            this.accumText.append('\ue90d');
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushCharacters();
        if (this.lazyHandler != null) {
            this.lazyHandler.endElement(uri, localName, qName);
        }
        if (this.inMeta > 1) {
            this.metaBuf.append("</" + localName + ">");
        }
        if (this.inMeta == 1) {
            this.metaField.value = this.metaBuf.toString().trim();
            if (this.metaField.tokenize && !this.metaField.isFacet) {
                if (this.metaField.value.length() > 0 && this.metaField.value.charAt(0) == '<') {
                    int insertPoint = this.metaField.value.indexOf(62) + 1;
                    this.metaField.value = this.metaField.value.substring(0, insertPoint) + '\uebeb' + this.metaField.value.substring(insertPoint) + '\uee1d';
                } else {
                    this.metaField.value = '\uebeb' + this.metaField.value + '\uee1d';
                }
            }
            boolean add = true;
            int nFound = 0;
            for (MetaField mf : this.metaInfo) {
                boolean found = mf.name.equals(this.metaField.name);
                if (found) {
                    ++nFound;
                }
                if (!found || !mf.tokenize || mf.isFacet) continue;
                StringBuffer buf = new StringBuffer();
                buf.append(mf.value);
                buf.append('\uebbb');
                buf.append('x');
                buf.append('\uebbb');
                buf.append(' ');
                buf.append(this.metaField.value);
                mf.value = buf.toString();
                add = false;
            }
            if (add) {
                if (nFound > 0) {
                    this.metaField.wordBoost = 1.0f;
                }
                this.metaInfo.add(this.metaField);
            }
            this.metaField = null;
            this.metaBuf.setLength(0);
            this.inMeta = 0;
        } else if (this.inMeta > 1) {
            --this.inMeta;
        }
        String prevSectionType = this.section.sectionType();
        float prevWordBoost = this.section.wordBoost();
        int prevSpellFlag = this.section.spellFlag();
        this.section.pop();
        if (this.section.sectionType() != prevSectionType || this.section.wordBoost() != prevWordBoost || this.section.spellFlag() != prevSpellFlag) {
            this.forceNewChunk(prevSectionType, prevWordBoost, prevSpellFlag);
            Trace.tab();
            Trace.debug("End Section [" + prevSectionType + "]");
            Trace.untab();
        }
        if (this.lazyBuilder != null) assert (this.lazyBuilder.getNodeNum(this.lazyReceiver) == this.curNode + 1);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.lazyHandler != null) {
            this.lazyHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.lazyHandler != null) {
            this.lazyHandler.endPrefixMapping(prefix);
        }
    }

    public void endDocument() throws SAXException {
        this.indexText(this.section.sectionType(), this.section.wordBoost(), this.section.spellFlag());
        this.saveDocInfo();
        if (this.lazyHandler != null) {
            this.lazyHandler.endDocument();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.charBufPos + length > this.charBuf.length) {
            char[] old = this.charBuf;
            this.charBuf = new char[this.charBufPos + length + 1024];
            System.arraycopy(old, 0, this.charBuf, 0, this.charBufPos);
        }
        System.arraycopy(ch, start, this.charBuf, this.charBufPos, length);
        this.charBufPos += length;
    }

    public void flushCharacters() throws SAXException {
        char[] ch = this.charBuf;
        int length = this.charBufPos;
        int start = 0;
        this.charBufPos = 0;
        int i = 0;
        if (this.indexInfo.stripWhitespace) {
            for (i = 0; i < length && Character.isWhitespace(this.charBuf[i]); ++i) {
            }
        }
        if (i == length) {
            return;
        }
        if (this.lazyHandler != null) {
            this.lazyHandler.characters(ch, start, length);
        }
        this.incrementNode();
        if (this.inMeta > 0) {
            String tmp = new String(ch, start, length);
            if (tmp.indexOf(38) >= 0) {
                tmp = tmp.replaceAll("&", "&amp;");
            }
            if (tmp.indexOf(60) >= 0) {
                tmp = tmp.replaceAll("<", "&lt;");
            }
            if (tmp.indexOf(62) >= 0) {
                tmp = tmp.replaceAll(">", "&gt;");
            }
            this.metaBuf.append(tmp);
            return;
        }
        if (this.section.indexFlag() == 0) {
            return;
        }
        this.blurbedText.setLength(0);
        this.blurbedText.append(ch, start, length);
        this.blurbify(this.blurbedText, true);
        this.insertVirtualWords(this.blurbedText);
        if (this.blurbedText.length() <= 0) {
            return;
        }
        String blurbedTextStr = this.blurbedText.toString();
        FastStringReader reader = new FastStringReader(blurbedTextStr);
        FastTokenizer result = new FastTokenizer(reader);
        int punctStart = 0;
        int accumTextLen = this.trimAccumText(true);
        boolean mustGetNextWord = true;
        Token word = null;
        try {
            while (true) {
                if (mustGetNextWord) {
                    word = ((TokenStream)result).next();
                }
                if (word != null) {
                    mustGetNextWord = true;
                    if (this.chunkStartNode < 0) {
                        this.chunkStartNode = this.curNode;
                        this.chunkWordOffset = this.nodeWordCount;
                    }
                    int wordStart = word.startOffset();
                    int wordEnd = word.endOffset();
                    int punctLen = wordStart - punctStart;
                    if (this.chunkWordCount == this.chunkWordOvlpStart) {
                        this.nextChunkStartIdx = accumTextLen + punctLen;
                        this.nextChunkStartNode = this.curNode;
                        this.nextChunkWordOffset = this.nodeWordCount;
                        this.nextChunkWordCount = 0;
                    }
                    this.accumText.append(blurbedTextStr.substring(punctStart, wordEnd));
                    punctStart = wordEnd;
                    ++this.chunkWordCount;
                    ++this.nextChunkWordCount;
                    if (!word.termText().equals("qw")) {
                        ++this.nodeWordCount;
                    }
                    if (this.chunkWordCount == this.chunkWordSize) {
                        word = ((TokenStream)result).next();
                        mustGetNextWord = false;
                        int punctEnd = word == null ? this.blurbedText.length() : word.startOffset();
                        this.accumText.append(blurbedTextStr.substring(punctStart, punctEnd));
                        this.trimAccumText(false);
                        this.indexText(this.section.sectionType(), this.section.wordBoost(), this.section.spellFlag());
                        punctStart = punctEnd;
                        this.chunkStartNode = this.nextChunkStartNode;
                        this.chunkWordOffset = this.nextChunkWordOffset;
                        this.chunkWordCount = this.nextChunkWordCount;
                        this.accumText.delete(0, this.nextChunkStartIdx);
                        accumTextLen = this.trimAccumText(true);
                        this.nextChunkStartIdx = 0;
                        this.nextChunkWordCount = 0;
                        continue;
                    }
                    accumTextLen = this.trimAccumText(false);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Trace.tab();
            Trace.error("*** Exception Processing text: " + e);
            Trace.untab();
            throw new SAXException(e);
        }
        catch (Throwable t) {
            Trace.tab();
            Trace.error("*** Exception Processing text: " + t);
            Trace.untab();
            throw new RuntimeException(t);
        }
        this.accumText.append(blurbedTextStr.substring(punctStart, blurbedTextStr.length()));
        this.trimAccumText(false);
    }

    private void forceNewChunk(String sectionType, float wordBoost, int spellFlag) {
        if (this.nextChunkStartIdx > 0) {
            this.indexText(sectionType, wordBoost, spellFlag);
            this.chunkStartNode = this.nextChunkStartNode;
            this.chunkWordOffset = this.nextChunkWordOffset;
            this.chunkWordCount = this.nextChunkWordCount;
            this.accumText.delete(0, this.nextChunkStartIdx);
            this.trimAccumText(true);
            this.nextChunkStartIdx = 0;
            this.nextChunkWordCount = 0;
        }
        this.indexText(sectionType, wordBoost, spellFlag);
        this.chunkWordOffset += this.chunkWordCount;
        this.chunkWordCount = 0;
        this.nextChunkWordCount = 0;
        this.nextChunkWordOffset = 0;
        this.accumText.setLength(0);
        this.chunkStartNode = -1;
        this.forcedChunk = true;
    }

    private int trimAccumText(boolean oneEndSpace) {
        int length = this.accumText.length();
        while (length > 0 && this.accumText.charAt(length - 1) == ' ') {
            this.accumText.deleteCharAt(--length);
        }
        if (length > 0 && oneEndSpace) {
            this.accumText.append(' ');
            ++length;
        }
        return length;
    }

    private void blurbify(StringBuffer text, boolean trim) {
        int i;
        int length = text.length();
        for (i = 0; i < length; ++i) {
            char theChar = text.charAt(i);
            if (theChar != '\uebbb' && theChar != '\ue90d' && (theChar == ' ' || !Character.isWhitespace(theChar))) continue;
            text.setCharAt(i, ' ');
        }
        i = 0;
        while (i < length - 1) {
            if (text.charAt(i) == ' ' && text.charAt(i + 1) == ' ') {
                text.deleteCharAt(i);
                --length;
                continue;
            }
            ++i;
        }
        if (trim) {
            while (length > 0 && text.charAt(0) == ' ') {
                text.deleteCharAt(0);
                --length;
            }
            while (length > 0 && text.charAt(length - 1) == ' ') {
                text.deleteCharAt(--length);
            }
        }
    }

    private void insertVirtualWords(StringBuffer text) {
        String vWord = "qw ";
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            if (!this.isEndOfSentence(i, len, text)) continue;
            if (i < len - 1 && text.charAt(i + 1) == '\"') {
                ++i;
            }
            this.insertVirtualWords(vWord, this.section.sentenceBump(), text, i + 1);
            len = text.length();
        }
        if (this.section.sectionBump() == 0) {
            if (this.forcedChunk) {
                this.insertVirtualWords(vWord, this.chunkWordOvlp, text, 0);
                this.forcedChunk = false;
            }
        } else {
            this.insertVirtualWords(vWord, this.section.useSectionBump(), text, 0);
        }
    }

    private boolean isEndOfSentence(int idx, int len, StringBuffer text) {
        char currChar = text.charAt(idx);
        if (!this.isSentencePunctuationChar(currChar)) {
            return false;
        }
        int prevChar = 32;
        char nextChar = ' ';
        if (idx > 0) {
            prevChar = text.charAt(idx - 1);
        }
        if (idx < len - 1) {
            nextChar = text.charAt(idx + 1);
        }
        if (currChar == '.') {
            if (Character.isLetterOrDigit(nextChar)) {
                return false;
            }
            return prevChar != 46 && nextChar != '.';
        }
        if (currChar == '!') {
            return !this.isSentencePunctuationChar(nextChar);
        }
        return currChar == '?' && !this.isSentencePunctuationChar(nextChar);
    }

    private boolean isSentencePunctuationChar(char theChar) {
        return theChar == '.' || theChar == '?' || theChar == '!';
    }

    private void insertVirtualWords(String vWord, int count, StringBuffer text, int pos) {
        if (count == 0) {
            return;
        }
        text.insert(pos++, ' ');
        for (int j = 0; j < count; ++j) {
            text.insert(pos, vWord);
        }
    }

    private void indexText(String sectionType, float wordBoost, int spellFlag) {
        try {
            this.compactVirtualWords();
        }
        catch (Throwable t) {
            Trace.tab();
            Trace.error("*** Exception Compacting Virtual Words: " + t);
            Trace.untab();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (this.compactedAccumText.length() == 0) {
            return;
        }
        Document doc = new Document();
        doc.add(new Field("key", this.curIdxSrc.key(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        if (sectionType != null && sectionType.length() > 0) {
            doc.add(new Field("sectionType", sectionType, Field.Store.YES, Field.Index.TOKENIZED));
        }
        String nodeStr = Integer.toString(this.chunkStartNode);
        String wordOffsetStr = Integer.toString(this.chunkWordOffset);
        String textStr = this.compactedAccumText.toString();
        Trace.tab();
        Trace.debug("node " + nodeStr + ", offset = " + wordOffsetStr);
        Trace.more(" text = [" + textStr + "]");
        Trace.untab();
        doc.add(new Field("node", nodeStr, Field.Store.YES, Field.Index.NO));
        doc.add(new Field("wordOffset", wordOffsetStr, Field.Store.YES, Field.Index.NO));
        Field textField = new Field("text", textStr, Field.Store.YES, Field.Index.TOKENIZED);
        textField.setBoost(wordBoost);
        XTFTextAnalyzer analyzer = (XTFTextAnalyzer)this.indexWriter.getAnalyzer();
        analyzer.clearMisspelledFields();
        if (spellFlag == 0) {
            analyzer.addMisspelledField("text");
        }
        doc.add(textField);
        try {
            this.indexWriter.addDocument(doc);
            ++this.chunkCount;
        }
        catch (Throwable t) {
            Trace.tab();
            Trace.error("*** Exception Adding Text to Index: " + t);
            Trace.untab();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static boolean isAllWhitespace(String str, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void compactVirtualWords() throws IOException {
        char marker = '\uebbb';
        String vWord = "qw";
        this.compactedAccumText.setLength(0);
        this.compactedAccumText.append(this.accumText);
        String textStr = this.compactedAccumText.toString();
        FastStringReader reader = new FastStringReader(textStr);
        FastTokenizer tokenList = new FastTokenizer(reader);
        int posAdj = 0;
        Token theToken = null;
        boolean mustGetNextToken = true;
        while (true) {
            int vRunStart;
            if (mustGetNextToken) {
                theToken = ((TokenStream)tokenList).next();
            } else {
                mustGetNextToken = true;
            }
            if (theToken == null) break;
            int vWordCount = 0;
            int vRunEnd = vRunStart = posAdj + theToken.startOffset();
            while (vWord.equalsIgnoreCase(theToken.termText())) {
                if (vWordCount > 0 && !XMLTextProcessor.isAllWhitespace(textStr, vRunEnd - posAdj, theToken.startOffset())) {
                    mustGetNextToken = false;
                    break;
                }
                vRunEnd = posAdj + theToken.endOffset();
                ++vWordCount;
                theToken = ((TokenStream)tokenList).next();
                if (theToken != null) continue;
            }
            if (vWordCount <= 0) continue;
            int vRunLen = vRunEnd - vRunStart;
            this.compactedAccumText.delete(vRunStart, vRunEnd);
            posAdj -= vRunLen;
            String bumpStr = marker + Integer.toString(vWordCount) + marker;
            this.compactedAccumText.insert(vRunStart, bumpStr);
            posAdj += bumpStr.length();
        }
        int i = 0;
        while (i < this.compactedAccumText.length() - 1) {
            char currChar = this.compactedAccumText.charAt(i);
            char nextChar = this.compactedAccumText.charAt(i + 1);
            if (currChar == ' ' && (nextChar == ' ' || nextChar == marker)) {
                this.compactedAccumText.deleteCharAt(i);
                continue;
            }
            ++i;
        }
    }

    private boolean trueOrFalse(String value, boolean defaultResult) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultResult;
    }

    private void ProcessNodeAttributes(Attributes atts) {
        String sectionTypeStr = this.section.sectionType();
        float wordBoost = this.section.wordBoost();
        int sentenceBump = this.section.sentenceBump();
        int indexFlag = -1;
        int spellFlag = -1;
        int sectionBump = 0;
        for (int i = 0; i < atts.getLength(); ++i) {
            String valueStr;
            if (!xtfUri.equals(atts.getURI(i))) continue;
            String attName = atts.getLocalName(i);
            if (attName.equalsIgnoreCase("sectionType")) {
                sectionTypeStr = atts.getValue(i);
                continue;
            }
            if (attName.equalsIgnoreCase("sectionTypeAdd")) {
                sectionTypeStr = sectionTypeStr + " " + atts.getValue(i);
                continue;
            }
            if (attName.equalsIgnoreCase("sectionBump")) {
                valueStr = atts.getValue(i);
                sectionBump = Integer.parseInt(valueStr);
                continue;
            }
            if (attName.equalsIgnoreCase("wordBoost")) {
                valueStr = atts.getValue(i);
                wordBoost = Float.parseFloat(valueStr);
                continue;
            }
            if (attName.equalsIgnoreCase("sentenceBump")) {
                valueStr = atts.getValue(i);
                sentenceBump = Integer.parseInt(valueStr);
                continue;
            }
            if (attName.equalsIgnoreCase("noIndex")) {
                boolean defaultNoIndexFlag = indexFlag != 1;
                valueStr = atts.getValue(i);
                indexFlag = this.trueOrFalse(valueStr, defaultNoIndexFlag) ? 0 : 1;
                continue;
            }
            if (attName.equalsIgnoreCase("index")) {
                boolean defaultIndexFlag = this.section.indexFlag() == 1;
                valueStr = atts.getValue(i);
                indexFlag = this.trueOrFalse(valueStr, defaultIndexFlag) ? 1 : 0;
                continue;
            }
            if (attName.equalsIgnoreCase("proximityBreak")) {
                valueStr = atts.getValue(i);
                if (!this.trueOrFalse(valueStr, false)) continue;
                this.forceNewChunk(this.section.sectionType(), this.section.wordBoost(), this.section.spellFlag());
                this.chunkStartNode = -1;
                this.chunkWordOffset = -1;
                Trace.tab();
                Trace.debug("Proximity Break");
                Trace.untab();
                continue;
            }
            if (attName.equalsIgnoreCase("wordBoost")) {
                valueStr = atts.getValue(i);
                float newBoost = Float.parseFloat(valueStr);
                if (wordBoost == newBoost) continue;
                this.forceNewChunk(this.section.sectionType(), this.section.wordBoost(), this.section.spellFlag());
                this.chunkStartNode = -1;
                this.chunkWordOffset = -1;
                wordBoost = newBoost;
                Trace.tab();
                Trace.debug("Word Boost: " + newBoost);
                Trace.untab();
                continue;
            }
            if (attName.equalsIgnoreCase("spell")) {
                boolean defaultSpellFlag = this.section.spellFlag() == 1;
                valueStr = atts.getValue(i);
                int n = spellFlag = this.trueOrFalse(valueStr, defaultSpellFlag) ? 1 : 0;
                if (spellFlag == this.section.spellFlag()) continue;
                this.forceNewChunk(this.section.sectionType(), this.section.wordBoost(), this.section.spellFlag());
                this.chunkStartNode = -1;
                this.chunkWordOffset = -1;
                Trace.tab();
                Trace.debug("Spell: " + spellFlag);
                Trace.untab();
                continue;
            }
            Trace.tab();
            Trace.warning("*** Warning: Unrecognized XTF Attribute [ " + atts.getQName(i) + "=" + atts.getValue(i) + " ].");
            Trace.untab();
        }
        this.section.push(indexFlag, sectionTypeStr, sectionBump, wordBoost, sentenceBump, spellFlag);
    }

    private void saveDocInfo() {
        File srcPath;
        Document doc = new Document();
        doc.add(new Field("docInfo", "1", Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add(new Field("chunkCount", Integer.toString(this.chunkCount), Field.Store.YES, Field.Index.NO));
        doc.add(new Field("key", this.curIdxSrc.key(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        int recordNum = this.curIdxRecord.recordNum();
        if (recordNum > 0) {
            doc.add(new Field("recordNum", Integer.toString(recordNum), Field.Store.YES, Field.Index.NO));
        }
        if ((srcPath = this.curIdxSrc.path()) != null) {
            String fileDateStr = DateTools.timeToString(srcPath.lastModified(), DateTools.Resolution.MILLISECOND);
            doc.add(new Field("fileDate", fileDateStr, Field.Store.YES, Field.Index.NO));
        }
        XTFTextAnalyzer analyzer = (XTFTextAnalyzer)this.indexWriter.getAnalyzer();
        analyzer.clearFacetFields();
        if (this.metaInfo == null || this.metaInfo.isEmpty()) {
            Trace.tab();
            Trace.warning("*** Warning: No meta data found for document.");
            Trace.untab();
        } else {
            for (MetaField metaField : this.metaInfo) {
                if (metaField.isFacet && metaField.index) {
                    metaField.tokenize = true;
                    analyzer.addFacetField(metaField.name);
                }
                if (!metaField.spell && metaField.index) {
                    analyzer.addMisspelledField(metaField.name);
                }
                Field docField = new Field(metaField.name, metaField.value, metaField.store ? Field.Store.YES : Field.Store.NO, metaField.index ? (metaField.tokenize ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO);
                docField.setBoost(metaField.wordBoost);
                doc.add(docField);
                if (!metaField.tokenize || metaField.isFacet || this.tokenizedFields.contains(metaField.name)) continue;
                this.addToTokenizedFieldsFile(metaField.name);
                this.tokenizedFields.add(metaField.name);
            }
        }
        try {
            this.indexWriter.addDocument(doc);
        }
        catch (Throwable t) {
            Trace.tab();
            Trace.error("*** Exception Adding docInfo to Index: " + t);
            Trace.untab();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private void addToTokenizedFieldsFile(String field) {
        try {
            File tokFieldsFile = new File(Path.normalizePath(this.indexPath + "tokenizedFields.txt"));
            FileWriter writer = new FileWriter(tokFieldsFile, true);
            writer.append(field + "\n");
            writer.close();
        }
        catch (Throwable t) {
            Trace.tab();
            Trace.error("*** Exception Adding to tokenizedFields.txt: " + t);
            Trace.untab();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private String getIndexPath() throws IOException {
        String idxPath = Path.resolveRelOrAbs(this.xtfHomePath, this.indexInfo.indexPath);
        return Path.normalizePath(idxPath);
    }

    private int checkFile(IndexSource srcInfo) throws IOException {
        BooleanQuery query = new BooleanQuery();
        Term docInfo = new Term("docInfo", "1");
        Term keyTerm = new Term("key", srcInfo.key());
        query.add(new TermQuery(docInfo), BooleanClause.Occur.MUST);
        query.add(new TermQuery(keyTerm), BooleanClause.Occur.MUST);
        boolean docInIndex = false;
        boolean docChanged = false;
        Hits match = this.indexSearcher.search(query);
        if (match.length() > 0) {
            docInIndex = true;
            Document doc = match.doc(0);
            String indexDateStr = doc.get("fileDate");
            File srcPath = srcInfo.path();
            String fileDateStr = DateTools.timeToString(srcPath.lastModified(), DateTools.Resolution.MILLISECOND);
            if (fileDateStr.compareTo(indexDateStr) != 0) {
                File lazyFile = IndexUtil.calcLazyPath(new File(this.xtfHomePath), this.indexInfo, srcPath, false);
                Path.deletePath(lazyFile.toString());
                docInIndex = true;
                docChanged = true;
            }
        }
        if (!docInIndex) {
            return 0;
        }
        if (!docChanged) {
            return 1;
        }
        return 2;
    }

    public void optimizeIndex() throws IOException {
        try {
            this.openIdxForWriting();
            this.indexWriter.optimize();
        }
        catch (IOException e) {
            Trace.tab();
            Trace.error("*** Exception Optimizing Index: " + e);
            Trace.untab();
            throw e;
        }
        finally {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
            this.indexWriter = null;
        }
        assert (this.indexWriter == null) : "indexWriter not closed in finally block";
    }

    private void openIdxForReading() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        this.indexWriter = null;
        if (this.spellWriter != null) {
            this.spellWriter.close();
        }
        this.spellWriter = null;
        if (this.indexReader == null) {
            this.indexReader = IndexReader.open(this.indexPath);
        }
        if (this.indexSearcher == null) {
            this.indexSearcher = new IndexSearcher(this.indexReader);
        }
    }

    private void openIdxForWriting() throws IOException {
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
        }
        if (this.indexReader != null) {
            this.indexReader.close();
        }
        this.indexSearcher = null;
        this.indexReader = null;
        if (this.indexWriter != null) {
            return;
        }
        XTFTextAnalyzer analyzer = new XTFTextAnalyzer(this.stopSet, this.pluralMap, this.accentMap);
        this.indexWriter = new IndexWriter(this.indexPath, (Analyzer)analyzer, false);
        this.indexWriter.setMaxBufferedDocs(100);
        if (this.indexInfo.createSpellcheckDict) {
            if (this.spellWriter == null) {
                this.spellWriter = SpellWriter.open(new File(this.indexPath + "spellDict/"));
                this.spellWriter.setStopwords(this.stopSet);
                this.spellWriter.setMinWordFreq(3);
            }
            analyzer.setSpellWriter(this.spellWriter);
        }
    }

    private class FileQueueEntry {
        public IndexSource idxSrc;
        public boolean deleteFirst;

        public FileQueueEntry(IndexSource idxSrc, boolean deleteFirst) {
            this.idxSrc = idxSrc;
            this.deleteFirst = deleteFirst;
        }
    }

    private class MetaField {
        public String name;
        public String value;
        public boolean store;
        public boolean index;
        public boolean tokenize;
        public boolean isFacet;
        public boolean spell;
        public float wordBoost;

        public MetaField(String name, boolean store, boolean index, boolean tokenize, boolean isFacet, boolean spell, float wordBoost) {
            this.name = name;
            this.store = store;
            this.index = index;
            this.tokenize = tokenize;
            this.isFacet = isFacet;
            this.spell = spell;
            this.wordBoost = wordBoost;
        }
    }
}

