/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.bigram.BigramStopFilter;
import org.apache.lucene.spelt.SpellWriter;
import org.cdlib.xtf.textIndexer.AccentFoldingFilter;
import org.cdlib.xtf.textIndexer.FacetTokenizer;
import org.cdlib.xtf.textIndexer.PluralFoldingFilter;
import org.cdlib.xtf.textIndexer.SpellWritingFilter;
import org.cdlib.xtf.textIndexer.StartEndFilter;
import org.cdlib.xtf.textIndexer.TagFilter;
import org.cdlib.xtf.textIndexer.XtfSpecialTokensFilter;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.FastStringReader;
import org.cdlib.xtf.util.FastTokenizer;
import org.cdlib.xtf.util.WordMap;

public class XTFTextAnalyzer
extends Analyzer {
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;
    private String srcText;
    private HashSet facetFields = new HashSet();
    private HashSet misspelledFields = new HashSet();
    private SpellWriter spellWriter = null;

    public XTFTextAnalyzer(Set stopSet, WordMap pluralMap, CharMap accentMap) {
        this.stopSet = stopSet;
        this.pluralMap = pluralMap;
        this.accentMap = accentMap;
    }

    public void clearFacetFields() {
        this.facetFields.clear();
    }

    public void addFacetField(String fieldName) {
        this.facetFields.add(fieldName);
    }

    public void clearMisspelledFields() {
        this.misspelledFields.clear();
    }

    public void addMisspelledField(String fieldName) {
        this.misspelledFields.add(fieldName);
    }

    public void setSpellWriter(SpellWriter writer) {
        this.spellWriter = writer;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        FastStringReader fastReader = reader instanceof FastStringReader ? (FastStringReader)reader : new FastStringReader(reader);
        this.srcText = fastReader.getString();
        if (this.facetFields.contains(fieldName)) {
            return new FacetTokenizer(this.srcText);
        }
        TokenStream result = new FastTokenizer(fastReader);
        result = new StandardFilter(result);
        if (!fieldName.equals("text")) {
            result = new TagFilter(result, this.srcText);
        }
        result = new XtfSpecialTokensFilter(result, this.srcText);
        result = new LowerCaseFilter(result);
        if (this.spellWriter != null && !this.misspelledFields.contains(fieldName)) {
            result = new SpellWritingFilter(result, this.spellWriter);
        }
        if (this.pluralMap != null) {
            result = new PluralFoldingFilter(result, this.pluralMap);
        }
        if (this.accentMap != null) {
            result = new AccentFoldingFilter(result, this.accentMap);
        }
        if (this.stopSet != null) {
            result = fieldName.equals("text") ? new BigramStopFilter(result, this.stopSet) : new BigramStopFilter(result, this.stopSet){

                protected boolean isStopWord(String word) {
                    if (word.length() > 0 && word.charAt(0) == '\uebeb') {
                        word = word.substring(1);
                    }
                    if (word.length() > 0 && word.charAt(word.length() - 1) == '\uee1d') {
                        word = word.substring(0, word.length() - 1);
                    }
                    return super.isStopWord(word);
                }
            };
        }
        if (!fieldName.equals("text")) {
            result = new StartEndFilter(result);
        }
        return result;
    }
}

