/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

public class Base64 {
    private static int decodeChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        return 0;
    }

    private static String decodeBits(int bits1, int pos1, int count1, int bits2, int pos2, int count2) {
        int num1 = bits1 >> pos1 & 255 >> 8 - count1;
        int num2 = bits2 >> pos2 & 255 >> 8 - count2;
        char c = (char)((num1 << count2) + num2);
        return Character.toString(c);
    }

    private static String decodeQuantum(String quantum) {
        int[] bits = new int[4];
        for (int i = 0; i < 4; ++i) {
            bits[i] = Base64.decodeChar(quantum.charAt(i));
        }
        String ch1 = Base64.decodeBits(bits[0], 0, 6, bits[1], 4, 2);
        String ch2 = Base64.decodeBits(bits[1], 0, 4, bits[2], 2, 4);
        String ch3 = Base64.decodeBits(bits[2], 0, 2, bits[3], 0, 6);
        if (quantum.endsWith("==")) {
            return ch1;
        }
        if (quantum.endsWith("=")) {
            return ch1 + ch2;
        }
        return ch1 + ch2 + ch3;
    }

    public static String decodeString(String base64) {
        String out = "";
        while (base64.length() >= 4) {
            String quantum = base64.substring(0, 4);
            base64 = base64.substring(4);
            String str = Base64.decodeQuantum(quantum);
            out = out + str;
        }
        return out;
    }
}

