/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;

public class CheckingTokenStream
extends TokenStream {
    TokenStream main;
    TokenStream ref;
    private static final String APOSTROPHE_TYPE = StandardTokenizerConstants.tokenImage[2];
    private static final String ACRONYM_TYPE = StandardTokenizerConstants.tokenImage[3];

    public CheckingTokenStream(TokenStream main, TokenStream ref) {
        this.main = main;
        this.ref = ref;
        boolean flag = false;
        if (!$assertionsDisabled) {
            flag = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!flag) {
            throw new RuntimeException("CheckingTokenStream requires assertions to be enabled");
        }
    }

    public Token next() throws IOException {
        Token t1 = this.main.next();
        Token t2 = this.ref.next();
        if (t1 == null || t2 == null) {
            assert (t1 == t2);
        } else {
            assert (t1.termText().equals(t2.termText()));
            assert (t1.startOffset() == t2.startOffset());
            assert (t1.endOffset() == t2.endOffset());
            assert (t1.getPositionIncrement() == t2.getPositionIncrement());
            assert (this.idType(t1.type()).equals(this.idType(t2.type())));
        }
        return t1;
    }

    private String idType(String type) {
        if (type.equals(APOSTROPHE_TYPE)) {
            return APOSTROPHE_TYPE;
        }
        if (type.equals(ACRONYM_TYPE)) {
            return ACRONYM_TYPE;
        }
        return "other";
    }

    public void close() throws IOException {
        this.main.close();
        this.ref.close();
    }
}

