/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.Tester;

public class CircularQueue {
    private int maxSize;
    private Object[] entries;
    private int bottom;
    private int count;
    public static final Tester tester = new Tester("CircularQueue"){

        protected void testImpl() {
            CircularQueue queue = new CircularQueue(3);
            Integer one = 1;
            Integer two = 2;
            Integer three = 3;
            Integer four = 4;
            assert (queue.count() == 0);
            assert (queue.isEmpty());
            assert (queue.removeHead() == null);
            assert (queue.removeTail() == null);
            assert (queue.peek(0) == null);
            assert (queue.peek(1) == null);
            queue.addTail(one);
            queue.addTail(two);
            assert (!queue.isEmpty());
            assert (queue.count() == 2);
            assert (queue.peek(0) == one);
            assert (queue.peek(1) == two);
            queue.addTail(three);
            queue.addTail(four);
            assert (queue.count() == 3);
            assert (queue.peek(0) == two);
            assert (queue.peek(1) == three);
            assert (queue.peek(2) == four);
            assert (queue.peek(3) == null);
            queue.addHead(one);
            assert (queue.count() == 3);
            assert (queue.peek(0) == one);
            assert (queue.peek(1) == two);
            assert (queue.peek(2) == three);
            assert (queue.peek(3) == null);
            assert (queue.removeHead() == one);
            assert (queue.removeTail() == three);
            assert (queue.count() == 1);
            assert (queue.peek(0) == two);
            assert (queue.peek(1) == null);
            queue.addHead(one);
            queue.addTail(three);
            assert (queue.count() == 3);
            assert (queue.peek(0) == one);
            assert (queue.peek(1) == two);
            assert (queue.peek(2) == three);
            assert (queue.peek(3) == null);
        }
    };

    public CircularQueue(int maxSize) {
        this.maxSize = maxSize;
        this.entries = new Object[maxSize];
    }

    public final void addTail(Object obj) {
        if (this.count == this.maxSize) {
            this.removeHead();
        }
        int next = this.bottom + this.count >= this.maxSize ? this.bottom + this.count - this.maxSize : this.bottom + this.count;
        this.entries[next] = obj;
        ++this.count;
    }

    public final void addHead(Object obj) {
        if (this.count == this.maxSize) {
            this.removeTail();
        }
        this.bottom = this.bottom == 0 ? this.maxSize - 1 : this.bottom - 1;
        this.entries[this.bottom] = obj;
        ++this.count;
    }

    public final Object removeHead() {
        if (this.count == 0) {
            return null;
        }
        int first = this.bottom;
        this.bottom = this.bottom == this.maxSize - 1 ? 0 : ++this.bottom;
        --this.count;
        return this.entries[first];
    }

    public final Object removeTail() {
        if (this.count == 0) {
            return null;
        }
        int last = this.bottom + this.count - 1;
        if (last == this.maxSize) {
            last = 0;
        }
        --this.count;
        return this.entries[last];
    }

    public final Object peek(int distance) {
        if (this.count == 0) {
            return null;
        }
        if (distance >= this.count) {
            return null;
        }
        int n = this.bottom + distance;
        if (n >= this.maxSize) {
            n -= this.maxSize;
        }
        return this.entries[n];
    }

    public final void clear() {
        this.count = 0;
        this.bottom = 0;
    }

    public final int count() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final boolean isFull() {
        return this.count == this.maxSize;
    }
}

