/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.SubStoreReader;

public class DiskHashReader {
    static final int headerSize = 12;
    private SubStoreReader subfile;
    private int nSlots;
    private int slotSize;
    private byte[] slotBytes;
    private PackedByteBuf slotBuf;

    public DiskHashReader(SubStoreReader subfile) throws IOException {
        this.subfile = subfile;
        byte[] magic = new byte[4];
        subfile.read(magic);
        if (magic[0] != 104 || magic[1] != 97 || magic[2] != 115 || magic[3] != 104) {
            throw new IOException("SubStore isn't a proper DiskHash");
        }
        this.nSlots = subfile.readInt();
        this.slotSize = subfile.readInt();
        this.slotBytes = new byte[this.slotSize];
        this.slotBuf = new PackedByteBuf(this.slotBytes);
    }

    public void close() {
        try {
            this.subfile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.subfile = null;
    }

    public PackedByteBuf find(String key) throws IOException {
        if (key.length() == 0) {
            key = " ";
        }
        int slotNum = (key.hashCode() & 0xFFFFFF) % this.nSlots;
        this.subfile.seek(12 + slotNum * 4);
        int slotOffset = this.subfile.readInt();
        if (slotOffset == 0) {
            return null;
        }
        assert ((long)(slotOffset + this.slotSize) <= this.subfile.length()) : "Corrupt hash offset";
        this.subfile.seek(slotOffset);
        this.subfile.read(this.slotBytes);
        this.slotBuf.setBytes(this.slotBytes);
        while (true) {
            String name;
            if ((name = this.slotBuf.readString()).length() == 0) {
                return null;
            }
            if (name.equals(key)) break;
            this.slotBuf.skipBuffer();
        }
        return this.slotBuf.readBuffer();
    }
}

