/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.util.Prime;
import org.cdlib.xtf.util.DiskHashReader;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.Tester;

public class DiskHashWriter {
    private HashMap memMap = new HashMap(100);
    public static final Tester tester = new Tester("DiskHash"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void testImpl() throws Exception {
            StructuredFile.tester.test();
            File testFile = new File("DiskHashTest.sf");
            StructuredFile f = null;
            try {
                f = StructuredFile.create(testFile);
                DiskHashWriter w = new DiskHashWriter();
                PackedByteBuf buf = new PackedByteBuf(20);
                buf.writeInt(11);
                buf.writeString("hello");
                w.put("foo", buf);
                buf.reset();
                buf.writeInt(22);
                buf.writeString("kangaroo");
                w.put("bar", buf);
                w.outputTo(f.createSubStore("testhash"));
                DiskHashReader r = new DiskHashReader(f.openSubStore("testhash"));
                buf = r.find("bar");
                assert (buf != null);
                assert (buf.readInt() == 22);
                assert (buf.readString().equals("kangaroo"));
                buf = r.find("foo");
                assert (buf != null);
                assert (buf.readInt() == 11);
                assert (buf.readString().equals("hello"));
                assert (r.find("xyz") == null);
            }
            finally {
                if (f != null) {
                    f.close();
                }
                testFile.delete();
            }
        }
    };

    public void put(String key, PackedByteBuf val) {
        if (key.length() == 0) {
            key = " ";
        }
        this.memMap.put(key, val.clone());
    }

    public void outputTo(SubStoreWriter out) throws IOException {
        int i;
        int startOffset;
        int nItems = this.memMap.size();
        int hashSize = Prime.findAfter(nItems * 2);
        PackedByteBuf[] slots = new PackedByteBuf[hashSize];
        int maxSlotSize = 0;
        for (String key : this.memMap.keySet()) {
            PackedByteBuf val = (PackedByteBuf)this.memMap.get(key);
            int slotNum = (key.hashCode() & 0xFFFFFF) % hashSize;
            if (slots[slotNum] == null) {
                slots[slotNum] = new PackedByteBuf(val.length() + key.length() + 5);
            }
            slots[slotNum].writeString(key);
            slots[slotNum].writeBuffer(val);
        }
        for (int i2 = 0; i2 < hashSize; ++i2) {
            if (slots[i2] == null) continue;
            slots[i2].writeString("");
            maxSlotSize = Math.max(maxSlotSize, slots[i2].length());
        }
        out.write("hash".getBytes());
        out.writeInt(hashSize);
        out.writeInt(maxSlotSize);
        assert (12 == (int)out.length());
        int curOffset = startOffset = (int)out.length() + hashSize * 4;
        for (i = 0; i < hashSize; ++i) {
            if (slots[i] == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(curOffset);
            curOffset += slots[i].length();
            assert (slots[i].length() <= maxSlotSize);
        }
        assert (out.length() == (long)startOffset);
        for (i = 0; i < hashSize; ++i) {
            if (slots[i] == null) continue;
            slots[i].output(out);
        }
        assert (out.length() == (long)curOffset);
        out.write(new byte[maxSlotSize]);
        out.close();
    }
}

