/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DocTypeDeclRemover
extends BufferedInputStream {
    private boolean firstTime = true;
    private static final int BLOCK_SIZE = 16384;

    public DocTypeDeclRemover(InputStream in) {
        super(in, 16384);
    }

    public int read() throws IOException {
        if (this.firstTime) {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) != 1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.firstTime) {
            int end;
            super.read(b, off, len > 16383 ? 16383 : len);
            char[] cbuf = new char[this.count];
            for (int i = 0; i < this.count; ++i) {
                cbuf[i] = (char)(this.buf[i] & 0xFF);
            }
            String s = new String(cbuf);
            int start = s.indexOf("<!DOCTYPE");
            if (start >= 0 && (end = this.findEnd(s, start + 1)) >= 0) {
                this.buf[start + 2] = 45;
                this.buf[start + 3] = 45;
                for (int i = start + 4; i < end - 2; ++i) {
                    this.buf[i] = 122;
                }
                this.buf[end - 1] = 45;
                this.buf[end - 2] = 45;
            }
            cbuf = new char[this.count];
            for (int i = 0; i < this.count; ++i) {
                cbuf[i] = (char)(this.buf[i] & 0xFF);
            }
            s = new String(cbuf);
            this.pos = 0;
            this.firstTime = false;
        }
        return super.read(b, off, len);
    }

    private int findEnd(String s, int start) {
        int level = 0;
        char inQuote = '\u0000';
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inQuote != '\u0000' && c == inQuote) {
                inQuote = '\u0000';
                continue;
            }
            if (c == '\'' || c == '\"') {
                inQuote = c;
                continue;
            }
            if (inQuote != '\u0000') continue;
            if (c == '<') {
                ++level;
                continue;
            }
            if (c != '>' || --level >= 0) continue;
            return i;
        }
        return -1;
    }
}

