/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.Vector;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;

public class EasyNode {
    private NodeInfo wrapped;
    private Vector attrNames;
    private Vector attrValues;
    private Vector children;

    public EasyNode(NodeInfo toWrap) {
        this.wrapped = toWrap;
    }

    private void getAttrs() {
        NodeInfo attr;
        if (this.attrNames != null) {
            return;
        }
        this.attrNames = new Vector();
        this.attrValues = new Vector();
        AxisIterator iter = this.wrapped.iterateAxis((byte)2);
        while ((attr = (NodeInfo)iter.next()) != null) {
            String name = attr.getLocalPart();
            String val = attr.getStringValue();
            this.attrNames.add(name);
            this.attrValues.add(val);
        }
    }

    private void getChildren() {
        NodeInfo child;
        if (this.children != null) {
            return;
        }
        this.children = new Vector();
        AxisIterator iter = this.wrapped.iterateAxis((byte)3);
        while ((child = (NodeInfo)iter.next()) != null) {
            if (child.getNodeKind() != 1 && child.getNodeKind() != 3) continue;
            this.children.add(new EasyNode(child));
        }
    }

    public int nAttrs() {
        this.getAttrs();
        return this.attrNames.size();
    }

    public String attrName(int index) {
        this.getAttrs();
        return (String)this.attrNames.get(index);
    }

    public String attrValue(int index) {
        this.getAttrs();
        return (String)this.attrValues.get(index);
    }

    public boolean hasAttr(String name) {
        return this.attrValue(name) != null;
    }

    public String attrValue(String name) {
        this.getAttrs();
        for (int i = 0; i < this.attrNames.size(); ++i) {
            if (!((String)this.attrNames.get(i)).equalsIgnoreCase(name)) continue;
            return (String)this.attrValues.get(i);
        }
        return null;
    }

    public int nChildren() {
        this.getChildren();
        return this.children.size();
    }

    public EasyNode child(int index) {
        this.getChildren();
        return (EasyNode)this.children.get(index);
    }

    public EasyNode child(String name) {
        this.getChildren();
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((EasyNode)this.children.get(i)).name().equalsIgnoreCase(name)) continue;
            return (EasyNode)this.children.get(i);
        }
        return null;
    }

    public EasyNode parent() {
        NodeInfo parent = this.wrapped.getParent();
        if (parent == null) {
            return null;
        }
        return new EasyNode(parent);
    }

    public String name() {
        return this.wrapped.getLocalPart();
    }

    public boolean isElement() {
        return this.wrapped.getNodeKind() == 1;
    }

    public boolean isText() {
        return this.wrapped.getNodeKind() == 3;
    }

    public String toString() {
        return this.wrapped.getStringValue();
    }

    public NodeInfo getWrappedNode() {
        return this.wrapped;
    }
}

